/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.riding.behaviour.ActiveRidingContext;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingController;
import com.cobblemon.mod.common.duck.PlayerDuck;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.mixin.accessor.ChunkMapAccessor;
import com.cobblemon.mod.common.mixin.accessor.TrackedEntityAccessor;
import com.cobblemon.mod.common.net.messages.client.orientation.ClientboundUpdateDriverInputPacket;
import com.cobblemon.mod.common.net.messages.client.orientation.ClientboundUpdateOrientationPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.ClientboundUpdateRidingStatePacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public abstract class ServerEntityMixin {
    @Shadow
    @Final
    private Consumer<Packet<?>> broadcast;
    @Shadow
    @Final
    private Entity entity;
    @Unique
    private Matrix3f cobblemon$lastSentOrientation;
    @Unique
    private boolean cobblemon$lastSentActive;

    @Inject(method={"sendChanges()V"}, at={@At(value="TAIL")})
    private void cobblemon$sendChanges(CallbackInfo ci) {
        this.cobblemon$sendOrientationChanges();
        this.cobblemon$sendRidingStateChanges();
        this.cobblemon$sendDriverInput();
    }

    private void cobblemon$sendRidingStateChanges() {
        Entity entity = this.entity;
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        if (pokemonEntity.getRidingController() == null) {
            return;
        }
        RidingController ridingController = pokemonEntity.getRidingController();
        if (ridingController.getContext() == null) {
            return;
        }
        ActiveRidingContext context = ridingController.getContext();
        ResourceLocation ridingBehaviour = context.getBehaviour();
        RidingBehaviourState ridingState = context.getState();
        RidingBehaviourState previousRidingState = pokemonEntity.getPreviousRidingState();
        if (previousRidingState != null && !ridingState.shouldSync(previousRidingState)) {
            return;
        }
        this.cobblemon$broadcast(new ClientboundUpdateRidingStatePacket(pokemonEntity.getId(), ridingBehaviour, ridingState, null));
    }

    private void cobblemon$sendOrientationChanges() {
        Entity entity = this.entity;
        if (!(entity instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllable = (OrientationControllable)entity;
        OrientationController controller = controllable.getOrientationController();
        Matrix3f currOrientation = controller.getOrientation();
        boolean currActive = controller.getActive();
        if (currOrientation == null || currOrientation.equals((Object)this.cobblemon$lastSentOrientation) && currActive == this.cobblemon$lastSentActive) {
            return;
        }
        this.cobblemon$lastSentOrientation = new Matrix3f((Matrix3fc)currOrientation);
        this.cobblemon$lastSentActive = currActive;
        this.cobblemon$broadcast(new ClientboundUpdateOrientationPacket(currOrientation, currActive, this.entity.getId()));
    }

    private void cobblemon$sendDriverInput() {
        Entity entity = this.entity;
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        if (!(serverPlayer.getVehicle() instanceof PokemonEntity)) {
            return;
        }
        Vector3f driverInput = ((PlayerDuck)serverPlayer).getDriverInput();
        if (driverInput == null) {
            return;
        }
        Vector3f lastSentDriverInput = ((PlayerDuck)serverPlayer).getLastSentDriverInput();
        if (driverInput.equals((Object)lastSentDriverInput)) {
            return;
        }
        ((PlayerDuck)serverPlayer).setLastSentDriverInput(driverInput);
        this.cobblemon$broadcast(new ClientboundUpdateDriverInputPacket(driverInput, this.entity.getId()));
    }

    private void cobblemon$broadcast(NetworkPacket<?> packet) {
        Level level = this.entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ChunkMap chunkMap = level2.getChunkSource().chunkMap;
        Int2ObjectMap<?> entityMap = ((ChunkMapAccessor)chunkMap).getEntityMap();
        Object tracked = entityMap.get(this.entity.getId());
        if (!(tracked instanceof TrackedEntityAccessor)) {
            return;
        }
        TrackedEntityAccessor tracker = (TrackedEntityAccessor)tracked;
        Set<ServerPlayerConnection> seenBy = tracker.getSeenBy();
        for (ServerPlayerConnection conn : seenBy) {
            ServerPlayer player = conn.getPlayer();
            if (player == this.entity) continue;
            CobblemonNetwork.INSTANCE.sendPacketToPlayer(player, packet);
        }
    }
}

