/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.client;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.keybind.keybinds.PartySendBinding;
import com.cobblemon.mod.common.duck.RidePassenger;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokedex.scanner.PokedexUsageContext;
import com.google.common.primitives.Floats;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.Blaze3D;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public abstract class MouseHandlerMixin {
    @Shadow
    private double accumulatedScrollY;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    SmoothDouble xMouseSmoother = new SmoothDouble();
    @Unique
    SmoothDouble yMouseSmoother = new SmoothDouble();
    @Unique
    SmoothDouble pitchSmoother = new SmoothDouble();
    @Unique
    SmoothDouble rollSmoother = new SmoothDouble();
    @Unique
    SmoothDouble yawSmoother = new SmoothDouble();
    @Shadow
    @Final
    private SmoothDouble smoothTurnY;
    @Shadow
    @Final
    private SmoothDouble smoothTurnX;
    @Shadow
    private double accumulatedDX;
    @Shadow
    private double accumulatedDY;
    @Shadow
    private double lastHandleMovementTime;
    @Unique
    private double cobblemon$timeDelta;

    @Shadow
    public abstract boolean isMouseGrabbed();

    @Shadow
    protected abstract void turnPlayer(double var1);

    @Inject(method={"onScroll(JDD)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MouseHandler;accumulatedScrollY:D", opcode=181, ordinal=2, shift=At.Shift.BEFORE)}, cancellable=true)
    public void cobblemon$scrollParty(long window, double horizontal, double vertical, CallbackInfo ci) {
        if (PartySendBinding.INSTANCE.getWasDown()) {
            int i = (int)this.accumulatedScrollY;
            if (i > 0) {
                this.accumulatedScrollY -= (double)i;
                CobblemonClient.INSTANCE.getStorage().shiftSelected(false);
                ci.cancel();
                PartySendBinding.INSTANCE.actioned();
            } else if (i < 0) {
                this.accumulatedScrollY -= (double)i;
                CobblemonClient.INSTANCE.getStorage().shiftSelected(true);
                ci.cancel();
                PartySendBinding.INSTANCE.actioned();
            }
        }
    }

    @Inject(method={"onScroll(JDD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;swapPaint(D)V")}, cancellable=true)
    public void cobblemon$doPokedexZoom(long window, double horizontal, double vertical, CallbackInfo ci) {
        PokedexUsageContext usageContext = CobblemonClient.INSTANCE.getPokedexUsageContext();
        if (usageContext.getScanningGuiOpen()) {
            usageContext.adjustZoom(vertical);
            ci.cancel();
        }
    }

    @WrapWithCondition(method={"turnPlayer(D)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;turn(DD)V")})
    public boolean cobblemon$modifyRotation(LocalPlayer player, double cursorDeltaX, double cursorDeltaY, @Local(argsOnly=true) double d, @Local(argsOnly=true) double movementTime) {
        OrientationControllable controllableVehicle;
        Entity vehicle;
        PokedexUsageContext usageContext = CobblemonClient.INSTANCE.getPokedexUsageContext();
        boolean returnValue = true;
        if (usageContext.getScanningGuiOpen()) {
            this.smoothTurnY.reset();
            this.smoothTurnX.reset();
            double defaultSensitivity = (Double)this.minecraft.options.sensitivity().get() * 0.6 + 0.2;
            double spyglassSensitivity = Math.pow(defaultSensitivity, 3.0);
            double lookSensitivity = spyglassSensitivity * 8.0;
            double sensitivity = Mth.lerp((double)usageContext.getFovMultiplier(), (double)spyglassSensitivity, (double)lookSensitivity);
            int yRotationFlip = (Boolean)this.minecraft.options.invertYMouse().get() != false ? -1 : 1;
            player.turn(this.accumulatedDX * sensitivity, this.accumulatedDY * sensitivity * (double)yRotationFlip);
            returnValue = false;
        }
        if (!((vehicle = player.getVehicle()) instanceof PokemonEntity)) {
            return returnValue;
        }
        if (player.isPassenger() && vehicle instanceof PokemonEntity) {
            PokemonEntity pokeVehicle = (PokemonEntity)vehicle;
            pokeVehicle.clampPassengerRotation((Entity)player);
        }
        if (!(vehicle instanceof OrientationControllable) || !(controllableVehicle = (OrientationControllable)vehicle).getOrientationController().isActive()) {
            this.xMouseSmoother.reset();
            this.yMouseSmoother.reset();
            this.pitchSmoother.reset();
            this.rollSmoother.reset();
            this.yawSmoother.reset();
            return returnValue;
        }
        OrientationController vehicleController = controllableVehicle.getOrientationController();
        boolean lookaroundButtonPressed = Minecraft.getInstance().mouseHandler.isMiddlePressed();
        Pair mouseShouldModifyDriver = ((PokemonEntity)vehicle).ifRidingAvailableSupply(new Pair((Object)false, (Object)false), (behaviour, settings, state) -> behaviour.mouseModifiesDriverRotation(settings, state, (PokemonEntity)vehicle));
        if (lookaroundButtonPressed || player.getControlledVehicle() == null) {
            this.cobblemon$setDriverRotations(player, cursorDeltaX, cursorDeltaY);
            if (player.getControlledVehicle() == null) {
                return false;
            }
            cursorDeltaX = 0.0;
            cursorDeltaY = 0.0;
        } else if (((Boolean)mouseShouldModifyDriver.getFirst()).booleanValue()) {
            this.cobblemon$setDriverRotations(player, cursorDeltaX, 0.0);
            cursorDeltaX = 0.0;
        } else if (((Boolean)mouseShouldModifyDriver.getSecond()).booleanValue()) {
            this.cobblemon$setDriverRotations(player, 0.0, cursorDeltaY);
            cursorDeltaY = 0.0;
        }
        RidePassenger playerRotater = (RidePassenger)player;
        if (!lookaroundButtonPressed && !((Boolean)mouseShouldModifyDriver.getFirst()).booleanValue()) {
            playerRotater.cobblemon$setRideYRot(Mth.lerp((float)Floats.min((float[])new float[]{5.0f * (float)movementTime, 1.0f}), (float)Mth.wrapDegrees((float)playerRotater.cobblemon$getRideYRot()), (float)0.0f));
        }
        if (!lookaroundButtonPressed && !((Boolean)mouseShouldModifyDriver.getSecond()).booleanValue()) {
            playerRotater.cobblemon$setRideXRot(Mth.lerp((float)Floats.min((float[])new float[]{5.0f * (float)movementTime, 1.0f}), (float)Mth.wrapDegrees((float)playerRotater.cobblemon$getRideXRot()), (float)0.0f));
        }
        Vec3 angVecMouse = this.cobblemon$getRideMouseRotation(cursorDeltaX, cursorDeltaY, movementTime);
        vehicleController.rotate((float)angVecMouse.x, (float)angVecMouse.y, (float)angVecMouse.z);
        Vec3 angRot = this.cobblemon$getAngularVelocity(movementTime);
        if (this.cobblemon$shouldUseAngVelSmoothing()) {
            double yaw = this.yawSmoother.getNewDeltaValue(angRot.x * 0.5, d);
            double pitch = this.pitchSmoother.getNewDeltaValue(angRot.y * 0.5, d);
            double roll = this.rollSmoother.getNewDeltaValue(angRot.z * 0.5, d);
            vehicleController.rotate((float)yaw, (float)pitch, (float)roll);
        } else {
            vehicleController.rotate((float)(angRot.x * 10.0 * d), (float)(angRot.y * 10.0 * d), (float)(angRot.z * 10.0 * d));
        }
        return returnValue;
    }

    @Inject(method={"handleAccumulatedMovement()V"}, at={@At(value="HEAD")})
    private void cobblemon$maintainMovementWhenInScreens2(CallbackInfo ci) {
        double time = Blaze3D.getTime();
        this.cobblemon$timeDelta = time - this.lastHandleMovementTime;
    }

    @Inject(method={"handleAccumulatedMovement()V"}, at={@At(value="TAIL")})
    private void cobblemon$maintainMovementWhenInScreens(CallbackInfo ci) {
        if (this.minecraft.player == null) {
            return;
        }
        Entity entity = this.minecraft.player.getVehicle();
        if (!(entity instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable vehicleControllable = (OrientationControllable)entity;
        OrientationController orientationController = vehicleControllable.getOrientationController();
        if (!(orientationController instanceof OrientationController)) {
            return;
        }
        OrientationController vehicleController = orientationController;
        if (vehicleController.getOrientation() == null) {
            return;
        }
        if (this.minecraft.isPaused()) {
            return;
        }
        if (this.isMouseGrabbed()) {
            return;
        }
        this.turnPlayer(this.cobblemon$timeDelta);
    }

    @Unique
    private Vec3 cobblemon$getAngularVelocity(double deltaTime) {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return Vec3.ZERO;
        }
        if (!(player instanceof OrientationControllable)) {
            return Vec3.ZERO;
        }
        Entity playerVehicle = player.getVehicle();
        if (playerVehicle == null) {
            return Vec3.ZERO;
        }
        if (!(playerVehicle instanceof PokemonEntity)) {
            return Vec3.ZERO;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)playerVehicle;
        return pokemonEntity.ifRidingAvailableSupply(Vec3.ZERO, (behaviour, settings, state) -> behaviour.angRollVel(settings, state, pokemonEntity, (Player)player, deltaTime));
    }

    @Unique
    private Vec3 cobblemon$getRideMouseRotation(double mouseX, double mouseY, double deltaTime) {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return Vec3.ZERO;
        }
        Entity vehicle = player.getVehicle();
        if (vehicle == null) {
            return Vec3.ZERO;
        }
        if (!(vehicle instanceof PokemonEntity)) {
            return Vec3.ZERO;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)vehicle;
        boolean invertYaw = Cobblemon.config.getInvertYaw();
        boolean invertPitch = Cobblemon.config.getInvertPitch();
        double xValue = mouseX * Cobblemon.config.getXAxisSensitivity();
        double yValue = mouseY * Cobblemon.config.getYAxisSensitivity();
        boolean swapXAndY = Cobblemon.config.getSwapXAndYAxes();
        double yaw = (swapXAndY ? yValue : xValue) * (double)(invertYaw ? -1.0f : 1.0f);
        double pitch = (swapXAndY ? xValue : yValue) * (double)(invertPitch ? -1.0f : 1.0f);
        double sensitivity = this.cobblemon$getRidingSensitivity();
        return pokemonEntity.ifRidingAvailableSupply(Vec3.ZERO, (behaviour, settings, state) -> behaviour.rotationOnMouseXY(settings, state, pokemonEntity, (Player)player, pitch, yaw, this.yMouseSmoother, this.xMouseSmoother, sensitivity, deltaTime));
    }

    @Unique
    private double cobblemon$getRidingSensitivity() {
        double sensitivity = (Double)this.minecraft.options.sensitivity().get() * (double)0.6f + (double)0.2f;
        return Math.pow(sensitivity, 3.0);
    }

    @Unique
    private void cobblemon$setDriverRotations(LocalPlayer player, double cursorDeltaX, double cursorDeltaY) {
        float f = (float)cursorDeltaY * 0.15f;
        float g = (float)cursorDeltaX * 0.15f;
        RidePassenger playerRotater = (RidePassenger)player;
        playerRotater.cobblemon$setRideXRot(playerRotater.cobblemon$getRideXRot() + f);
        playerRotater.cobblemon$setRideYRot(playerRotater.cobblemon$getRideYRot() + g);
        playerRotater.cobblemon$setRideXRot(Mth.clamp((float)playerRotater.cobblemon$getRideXRot(), (float)-90.0f, (float)90.0f));
        playerRotater.cobblemon$setRideYRot(Mth.clamp((float)playerRotater.cobblemon$getRideYRot(), (float)-105.0f, (float)105.0f));
        if (player.getVehicle() != null) {
            player.getVehicle().onPassengerTurned((Entity)player);
        }
    }

    @Unique
    private boolean cobblemon$shouldUseAngVelSmoothing() {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return true;
        }
        Entity playerVehicle = player.getVehicle();
        if (playerVehicle == null) {
            return true;
        }
        if (!(playerVehicle instanceof PokemonEntity)) {
            return true;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)playerVehicle;
        return pokemonEntity.ifRidingAvailableSupply(true, (behaviour, settings, state) -> behaviour.useAngVelSmoothing(settings, state, pokemonEntity));
    }
}

