/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.entity;

import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.duck.RidePassenger;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    @Nullable
    public abstract Entity getVehicle();

    @Inject(method={"updateInWaterStateAndDoWaterCurrentPushing()V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;wasTouchingWater:Z", ordinal=1)}, cancellable=true)
    public void cobblemon$verifyActuallyTouchingWater(CallbackInfo ci) {
        if (this.getVehicle() instanceof PokemonEntity) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;onGround()Z")})
    public boolean cobblemon$forceOnGroundForStepUp(Entity entity, Operation<Boolean> original) {
        if (entity instanceof PokemonEntity && entity.hasControllingPassenger()) {
            boolean standingOnSolid;
            BlockPos below = entity.blockPosition().below();
            Level level = entity.level();
            BlockState blockStateBelow = level.getBlockState(below);
            boolean isAirOrLiquid = blockStateBelow.isAir() || !blockStateBelow.getFluidState().isEmpty();
            boolean canSupportEntity = blockStateBelow.isFaceSturdy((BlockGetter)level, below, Direction.UP);
            boolean bl = standingOnSolid = canSupportEntity && !isAirOrLiquid;
            if (standingOnSolid) {
                return true;
            }
        }
        return (Boolean)original.call(new Object[]{entity});
    }

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon$modifyEyePosition_partial(float partialTicks, CallbackInfoReturnable<Vec3> cir) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!(player instanceof RidePassenger)) {
            return;
        }
        RidePassenger ridePassenger = (RidePassenger)player;
        Entity entity2 = player.getVehicle();
        if (!(entity2 instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable vehicle = (OrientationControllable)entity2;
        OrientationController vehicleController = vehicle.getOrientationController();
        if (vehicleController == null) {
            return;
        }
        Vec3 customEyePos = ridePassenger.cobblemon$getRideEyePos();
        cir.setReturnValue((Object)customEyePos);
    }

    @Inject(method={"getEyePosition()Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon$modifyEyePosition_noPartial(CallbackInfoReturnable<Vec3> cir) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!(player instanceof RidePassenger)) {
            return;
        }
        RidePassenger ridePassenger = (RidePassenger)player;
        Entity entity2 = player.getVehicle();
        if (!(entity2 instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable vehicle = (OrientationControllable)entity2;
        OrientationController vehicleController = vehicle.getOrientationController();
        if (vehicleController == null) {
            return;
        }
        Vec3 customEyePos = ridePassenger.cobblemon$getRideEyePos();
        cir.setReturnValue((Object)customEyePos);
    }
}

