/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.server.storage.pc;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\u00188\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/net/messages/server/storage/pc/MovePCPokemonToPartyPacket;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "Ljava/util/UUID;", "pokemonID", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "pcPosition", "Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "partyPosition", "<init>", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "Ljava/util/UUID;", "getPokemonID", "()Ljava/util/UUID;", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "getPcPosition", "()Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "getPartyPosition", "()Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Companion", "common"})
public final class MovePCPokemonToPartyPacket
implements NetworkPacket<MovePCPokemonToPartyPacket> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID pokemonID;
    @NotNull
    private final PCPosition pcPosition;
    @Nullable
    private final PartyPosition partyPosition;
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private static final ResourceLocation ID = MiscUtilsKt.cobblemonResource("move_pc_pokemon_to_party");

    public MovePCPokemonToPartyPacket(@NotNull UUID pokemonID, @NotNull PCPosition pcPosition, @Nullable PartyPosition partyPosition) {
        Intrinsics.checkNotNullParameter((Object)pokemonID, (String)"pokemonID");
        Intrinsics.checkNotNullParameter((Object)pcPosition, (String)"pcPosition");
        this.pokemonID = pokemonID;
        this.pcPosition = pcPosition;
        this.partyPosition = partyPosition;
        this.id = ID;
    }

    @NotNull
    public final UUID getPokemonID() {
        return this.pokemonID;
    }

    @NotNull
    public final PCPosition getPcPosition() {
        return this.pcPosition;
    }

    @Nullable
    public final PartyPosition getPartyPosition() {
        return this.partyPosition;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeUUID(this.pokemonID);
        BufferUtilsKt.writePCPosition((ByteBuf)buffer, this.pcPosition);
        buffer.writeNullable((Object)this.partyPosition, (arg_0, arg_1) -> MovePCPokemonToPartyPacket.encode$lambda$1(MovePCPokemonToPartyPacket::encode$lambda$0, arg_0, arg_1));
    }

    private static final Unit encode$lambda$0(FriendlyByteBuf pb, PartyPosition value) {
        Intrinsics.checkNotNull((Object)pb);
        ByteBuf byteBuf = (ByteBuf)pb;
        Intrinsics.checkNotNull((Object)value);
        BufferUtilsKt.writePartyPosition(byteBuf, value);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$1(Function2 $tmp0, Object object, PartyPosition object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/net/messages/server/storage/pc/MovePCPokemonToPartyPacket$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "Lcom/cobblemon/mod/common/net/messages/server/storage/pc/MovePCPokemonToPartyPacket;", "decode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lcom/cobblemon/mod/common/net/messages/server/storage/pc/MovePCPokemonToPartyPacket;", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        @NotNull
        public final MovePCPokemonToPartyPacket decode(@NotNull RegistryFriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            UUID uUID = buffer.readUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
            return new MovePCPokemonToPartyPacket(uUID, BufferUtilsKt.readPCPosition((ByteBuf)buffer), (PartyPosition)buffer.readNullable(arg_0 -> Companion.decode$lambda$1(Companion::decode$lambda$0, arg_0)));
        }

        private static final PartyPosition decode$lambda$0(FriendlyByteBuf it) {
            Intrinsics.checkNotNull((Object)it);
            return BufferUtilsKt.readPartyPosition((ByteBuf)it);
        }

        private static final PartyPosition decode$lambda$1(Function1 $tmp0, Object object) {
            return (PartyPosition)$tmp0.invoke(object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

