/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.serverhandling.pokemon.interact;

import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractTypePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.server.pokemon.interact.InteractPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/net/serverhandling/pokemon/interact/InteractPokemonHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/cobblemon/mod/common/net/messages/server/pokemon/interact/InteractPokemonPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "handle", "(Lcom/cobblemon/mod/common/net/messages/server/pokemon/interact/InteractPokemonPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerPlayer;)V", "common"})
@SourceDebugExtension(value={"SMAP\nInteractPokemonHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractPokemonHandler.kt\ncom/cobblemon/mod/common/net/serverhandling/pokemon/interact/InteractPokemonHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n2746#2,3:41\n*S KotlinDebug\n*F\n+ 1 InteractPokemonHandler.kt\ncom/cobblemon/mod/common/net/serverhandling/pokemon/interact/InteractPokemonHandler\n*L\n25#1:41,3\n*E\n"})
public final class InteractPokemonHandler
implements ServerNetworkPacketHandler<InteractPokemonPacket> {
    @NotNull
    public static final InteractPokemonHandler INSTANCE = new InteractPokemonHandler();

    private InteractPokemonHandler() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(@NotNull InteractPokemonPacket packet, @NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Entity pokemonEntity = player.serverLevel().getEntity(packet.getPokemonID());
        if (!(pokemonEntity instanceof PokemonEntity)) return;
        if (((PokemonEntity)pokemonEntity).isBattleClone()) return;
        switch (WhenMappings.$EnumSwitchMapping$0[packet.getInteractType().ordinal()]) {
            case 1: {
                Pokemon it;
                if (!((PokemonEntity)pokemonEntity).canSitOnShoulder()) return;
                Iterable $this$none$iv = PlayerExtensionsKt.party(player);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    return;
                }
                Iterator iterator = $this$none$iv.iterator();
                do {
                    if (!iterator.hasNext()) return;
                    Object element$iv = iterator.next();
                    it = (Pokemon)element$iv;
                    boolean bl = false;
                } while (!Intrinsics.areEqual((Object)it, (Object)((PokemonEntity)pokemonEntity).getPokemon()));
                boolean bl = false;
                if (bl) {
                    return;
                }
                boolean bl2 = ((PokemonEntity)pokemonEntity).tryMountingShoulder(player);
                return;
            }
            case 2: {
                player.setShiftKeyDown(false);
                boolean bl2 = ((PokemonEntity)pokemonEntity).tryRidingPokemon(player);
                return;
            }
            case 3: {
                PokemonEntity pokemonEntity2 = (PokemonEntity)pokemonEntity;
                Player player2 = (Player)player;
                ItemStack itemStack = player.getMainHandItem();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
                boolean bl2 = pokemonEntity2.offerHeldItem(player2, itemStack);
                return;
            }
            case 4: {
                PokemonEntity pokemonEntity3 = (PokemonEntity)pokemonEntity;
                Player player3 = (Player)player;
                ItemStack itemStack = player.getMainHandItem();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
                boolean bl2 = pokemonEntity3.offerCosmeticItem(player3, itemStack);
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InteractTypePokemon.values().length];
            try {
                nArray[InteractTypePokemon.SHOULDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InteractTypePokemon.RIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InteractTypePokemon.HELD_ITEM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InteractTypePokemon.COSMETIC_ITEM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

