/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokedex.scanner;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.pokedex.scanner.ScannableEntity;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/pokedex/scanner/PokemonScanner;", "", "<init>", "()V", "Lnet/minecraft/world/entity/Entity;", "castingEntity", "", "zoomLevel", "detectEntity", "(Lnet/minecraft/world/entity/Entity;I)Lnet/minecraft/world/entity/Entity;", "Lcom/cobblemon/mod/common/pokedex/scanner/ScannableEntity;", "findScannableEntity", "(Lnet/minecraft/world/entity/Entity;I)Lcom/cobblemon/mod/common/pokedex/scanner/ScannableEntity;", "targetEntity", "", "isEntityInRange", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;I)Z", "common"})
public final class PokemonScanner {
    @NotNull
    public static final PokemonScanner INSTANCE = new PokemonScanner();

    private PokemonScanner() {
    }

    @Nullable
    public final Entity detectEntity(@NotNull Entity castingEntity, int zoomLevel) {
        Intrinsics.checkNotNullParameter((Object)castingEntity, (String)"castingEntity");
        Vec3 eyePos = castingEntity.getEyePosition(1.0f);
        Vec3 lookVec = castingEntity.getViewVector(1.0f);
        double maxDistance = Cobblemon.INSTANCE.getConfig().getMaxPokedexScanningDetectionRange() + (double)zoomLevel;
        double boundingBoxSize = 12.0 + (double)zoomLevel;
        Entity closestEntity = null;
        double closestDistance = maxDistance;
        AABB boundingBox = new AABB(castingEntity.getX() - boundingBoxSize, castingEntity.getY() - boundingBoxSize, castingEntity.getZ() - boundingBoxSize, castingEntity.getX() + boundingBoxSize, castingEntity.getY() + boundingBoxSize, castingEntity.getZ() + boundingBoxSize);
        List entities = castingEntity.level().getEntitiesOfClass(Entity.class, boundingBox, arg_0 -> PokemonScanner.detectEntity$lambda$1(arg_0 -> PokemonScanner.detectEntity$lambda$0(castingEntity, arg_0), arg_0));
        for (Entity entity : entities) {
            boolean pathCollidesWithBlock;
            double maxSize;
            double minSize;
            double boxDepth;
            double boxHeight;
            AABB entityBox;
            Intrinsics.checkNotNullExpressionValue((Object)entity.getBoundingBox(), (String)"getBoundingBox(...)");
            double maxSizeScale = 1.0;
            double minSizeScale = 2.0;
            double steepCoefficient = 20.0;
            double boxWidth = entityBox.getXsize();
            double boxVolume = boxWidth * (boxHeight = entityBox.getYsize()) * (boxDepth = entityBox.getZsize());
            double normalizedSize = (boxVolume - (minSize = 0.2)) / RangesKt.coerceAtLeast((double)((maxSize = 3.0) - minSize), (double)0.01);
            double inflationFactor = maxSizeScale + (minSizeScale - maxSizeScale) * Math.exp(-steepCoefficient * normalizedSize);
            AABB inflatedBox = entityBox.inflate((inflationFactor - 1.0) * boxWidth / (double)2, (inflationFactor - 1.0) * boxHeight / (double)2, (inflationFactor - 1.0) * boxDepth / (double)2);
            Optional intersection = inflatedBox.clip(eyePos, eyePos.add(lookVec.scale(maxDistance)));
            if (!intersection.isPresent()) continue;
            double distanceToEntity = eyePos.distanceTo((Vec3)intersection.get());
            if (distanceToEntity < closestDistance) {
                closestEntity = entity;
                closestDistance = distanceToEntity;
            }
            if (closestEntity == null || !(pathCollidesWithBlock = castingEntity.level().clip(new ClipContext(eyePos, (Vec3)intersection.get(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, castingEntity)).getType() == HitResult.Type.BLOCK)) continue;
            closestEntity = null;
        }
        return closestEntity;
    }

    @Nullable
    public final ScannableEntity findScannableEntity(@NotNull Entity castingEntity, int zoomLevel) {
        Intrinsics.checkNotNullParameter((Object)castingEntity, (String)"castingEntity");
        Entity targetedEntity = this.detectEntity(castingEntity, zoomLevel * 2);
        return targetedEntity instanceof ScannableEntity ? (ScannableEntity)targetedEntity : null;
    }

    public final boolean isEntityInRange(@NotNull Entity castingEntity, @NotNull Entity targetEntity, int zoomLevel) {
        Intrinsics.checkNotNullParameter((Object)castingEntity, (String)"castingEntity");
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        return targetEntity.position().distanceTo(castingEntity.position()) <= Cobblemon.INSTANCE.getConfig().getMaxPokedexScanningDetectionRange() + (double)(zoomLevel * 2);
    }

    private static final boolean detectEntity$lambda$0(Entity $castingEntity, Entity it) {
        return it != $castingEntity;
    }

    private static final boolean detectEntity$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

