/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.ai;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.CobblemonActivities;
import com.cobblemon.mod.common.CobblemonBehaviours;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.CobblemonSensors;
import com.cobblemon.mod.common.api.ai.BehaviourConfigurationContext;
import com.cobblemon.mod.common.api.ai.CobblemonBehaviour;
import com.cobblemon.mod.common.api.ai.config.ApplyBehaviours;
import com.cobblemon.mod.common.entity.ai.AttackAngryAtTask;
import com.cobblemon.mod.common.entity.ai.ChooseLandWanderTargetTask;
import com.cobblemon.mod.common.entity.ai.FleeFromAttackerTask;
import com.cobblemon.mod.common.entity.ai.FollowWalkTargetTask;
import com.cobblemon.mod.common.entity.ai.GetAngryAtAttackerTask;
import com.cobblemon.mod.common.entity.ai.LookAroundTaskWrapper;
import com.cobblemon.mod.common.entity.ai.MoveToAttackTargetTask;
import com.cobblemon.mod.common.entity.ai.StayAfloatTask;
import com.cobblemon.mod.common.entity.ai.SwapActivityTask;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.sensors.DrowsySensor;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.ChooseFlightWanderTargetTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.ChooseWaterWanderTargetTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.DefendOwnerTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.FertilizerTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.FindRestingPlaceTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.GoToSleepTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.HandleBattleActivityGoal;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.IgniteTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.JumpOutOfWaterTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.LookAtTargetedBattlePokemonTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.ManageFlightInBattleTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.PokemonMeleeTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.WakeUpTask;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.WalkTowardsParentSpeciesTask;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\u000b\u0010\fJ1\u0010\u0011\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u00100\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J1\u0010\u0013\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u00100\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J1\u0010\u0014\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u00100\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0012J1\u0010\u0015\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u00100\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u0015\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u0019\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u00100\u000e0\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ)\u0010\u001b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u00100\u000e0\rH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ1\u0010\u001c\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u00100\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0012J\u001d\u0010 \u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!R\u001c\u0010$\u001a\n #*\u0004\u0018\u00010\"0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u001c\u0010&\u001a\n #*\u0004\u0018\u00010\"0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010%R-\u0010*\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00040)0(0'8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R!\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030.0\r8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u0010\u001a\u00a8\u00062"}, d2={"Lcom/cobblemon/mod/common/pokemon/ai/PokemonBrain;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lcom/mojang/serialization/Dynamic;", "dynamic", "", "applyBrain", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/mojang/serialization/Dynamic;)V", "", "Lcom/mojang/datafixers/util/Pair;", "", "Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "coreTasks", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Ljava/util/List;", "fightTasks", "avoidTasks", "idleTasks", "Lnet/minecraft/world/entity/ai/behavior/RunOne;", "makeRandomWalkTask", "()Lnet/minecraft/world/entity/ai/behavior/RunOne;", "battlingTasks", "()Ljava/util/List;", "sleepingTasks", "growingPlantTasks", "pokemonEntity", "Lnet/minecraft/world/entity/Entity;", "capturer", "onCaptureFailed", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/Entity;)V", "Lnet/minecraft/util/valueproviders/UniformInt;", "kotlin.jvm.PlatformType", "ADULT_FOLLOW_RANGE", "Lnet/minecraft/util/valueproviders/UniformInt;", "AVOID_MEMORY_DURATION", "", "Lnet/minecraft/world/entity/ai/sensing/SensorType;", "Lnet/minecraft/world/entity/ai/sensing/Sensor;", "SENSORS", "Ljava/util/Collection;", "getSENSORS", "()Ljava/util/Collection;", "Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;", "MEMORY_MODULES", "Ljava/util/List;", "getMEMORY_MODULES", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonBrain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonBrain.kt\ncom/cobblemon/mod/common/pokemon/ai/PokemonBrain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,304:1\n1374#2:305\n1460#2,5:306\n1#3:311\n*S KotlinDebug\n*F\n+ 1 PokemonBrain.kt\ncom/cobblemon/mod/common/pokemon/ai/PokemonBrain\n*L\n95#1:305\n95#1:306,5\n*E\n"})
public final class PokemonBrain {
    @NotNull
    public static final PokemonBrain INSTANCE = new PokemonBrain();
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final UniformInt AVOID_MEMORY_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)20);
    @NotNull
    private static final Collection<SensorType<? extends Sensor<? super PokemonEntity>>> SENSORS;
    @NotNull
    private static final List<MemoryModuleType<?>> MEMORY_MODULES;

    private PokemonBrain() {
    }

    @NotNull
    public final Collection<SensorType<? extends Sensor<? super PokemonEntity>>> getSENSORS() {
        return SENSORS;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyBrain(@NotNull PokemonEntity entity, @NotNull Pokemon pokemon, @NotNull Dynamic<?> dynamic) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter(dynamic, (String)"dynamic");
        List list = pokemon.getForm().getBaseAI();
        if (list == null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = CobblemonBehaviours.INSTANCE.getAutoPokemonBehaviours();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CobblemonBehaviour it = (CobblemonBehaviour)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getConfigurations();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List behaviourConfigurations = CollectionsKt.plus((Collection)list, (Iterable)pokemon.getForm().getAi());
        if (entity.getBehavioursAreCustom()) {
            ApplyBehaviours applyBehaviours;
            ApplyBehaviours $this$applyBrain_u24lambda_u241 = applyBehaviours = new ApplyBehaviours();
            boolean bl = false;
            $this$applyBrain_u24lambda_u241.getBehaviours().addAll((Collection<ResourceLocation>)entity.getBehaviours());
            behaviourConfigurations = CollectionsKt.listOf((Object)applyBehaviours);
        }
        BehaviourConfigurationContext ctx = new BehaviourConfigurationContext();
        ctx.apply((LivingEntity)entity, behaviourConfigurations, dynamic);
        entity.getBehaviours().clear();
        entity.getBehaviours().addAll((Collection<ResourceLocation>)ctx.getAppliedBehaviours());
        if (entity.getBrain().checkMemory(CobblemonMemories.POKEMON_DROWSY, MemoryStatus.REGISTERED)) {
            DrowsySensor.Companion.drowsyLogic(entity);
        }
        if (!((Collection)behaviourConfigurations).isEmpty()) {
            return;
        }
        Brain<PokemonEntity> brain = entity.getBrain();
        brain.addActivity(Activity.CORE, ImmutableList.copyOf((Collection)this.coreTasks(pokemon)));
        brain.addActivity(Activity.IDLE, ImmutableList.copyOf((Collection)this.idleTasks(pokemon)));
        brain.addActivity(CobblemonActivities.BATTLING, ImmutableList.copyOf((Collection)this.battlingTasks()));
        brain.addActivity(Activity.FIGHT, ImmutableList.copyOf((Collection)this.fightTasks(pokemon)));
        brain.addActivity(Activity.AVOID, ImmutableList.copyOf((Collection)this.avoidTasks(pokemon)));
        brain.addActivity(CobblemonActivities.POKEMON_SLEEPING_ACTIVITY, ImmutableList.copyOf((Collection)this.sleepingTasks()));
        brain.addActivityWithConditions(CobblemonActivities.POKEMON_GROW_CROP, ImmutableList.copyOf((Collection)this.growingPlantTasks(pokemon)), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_PRESENT)));
        brain.setCoreActivities(SetsKt.setOf((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
    }

    @NotNull
    public final List<MemoryModuleType<?>> getMEMORY_MODULES() {
        return MEMORY_MODULES;
    }

    private final List<Pair<Integer, BehaviorControl<? super PokemonEntity>>> coreTasks(Pokemon pokemon) {
        List list;
        List $this$coreTasks_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (!pokemon.getForm().getBehaviour().getMoving().getSwim().getCanBreatheUnderwater()) {
            $this$coreTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, new StayAfloatTask(0.8f)));
        }
        if (pokemon.getForm().getBehaviour().getCombat().getWillDefendSelf()) {
            v0 = $this$coreTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, GetAngryAtAttackerTask.INSTANCE.create()));
        } else {
            Integer n = 0;
            Expression expression = MoLangExtensionsKt.asExpression("600");
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"asExpression(...)");
            v0 = $this$coreTasks_u24lambda_u240.add(MiscUtilsKt.toDF(n, FleeFromAttackerTask.INSTANCE.create(expression)));
        }
        $this$coreTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, StopBeingAngryIfTargetDead.create()));
        $this$coreTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, HandleBattleActivityGoal.INSTANCE.create()));
        $this$coreTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, new FollowWalkTargetTask(0, 0, 3, null)));
        $this$coreTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, SwapActivityTask.INSTANCE.possessing(CobblemonMemories.POKEMON_BATTLE, CobblemonActivities.BATTLING)));
        return CollectionsKt.build((List)list);
    }

    private final List<Pair<Integer, BehaviorControl<? super PokemonEntity>>> fightTasks(Pokemon pokemon) {
        List list;
        List $this$fightTasks_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$fightTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, MoveToAttackTargetTask.create$default(MoveToAttackTargetTask.INSTANCE, null, null, 3, null)));
        $this$fightTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, PokemonMeleeTask.INSTANCE.create(20)));
        Integer n = 0;
        MemoryModuleType memoryModuleType = MemoryModuleType.ATTACK_TARGET;
        Intrinsics.checkNotNullExpressionValue((Object)memoryModuleType, (String)"ATTACK_TARGET");
        Activity activity = Activity.IDLE;
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"IDLE");
        $this$fightTasks_u24lambda_u240.add(MiscUtilsKt.toDF(n, SwapActivityTask.INSTANCE.lacking(memoryModuleType, activity)));
        return CollectionsKt.build((List)list);
    }

    private final List<Pair<Integer, BehaviorControl<? super PokemonEntity>>> avoidTasks(Pokemon pokemon) {
        List list;
        List $this$avoidTasks_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$avoidTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)0.55f, (int)15, (boolean)false)));
        $this$avoidTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, INSTANCE.makeRandomWalkTask()));
        $this$avoidTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60))));
        Integer n = 0;
        MemoryModuleType memoryModuleType = MemoryModuleType.AVOID_TARGET;
        Intrinsics.checkNotNullExpressionValue((Object)memoryModuleType, (String)"AVOID_TARGET");
        Activity activity = Activity.IDLE;
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"IDLE");
        $this$avoidTasks_u24lambda_u240.add(MiscUtilsKt.toDF(n, SwapActivityTask.INSTANCE.lacking(memoryModuleType, activity)));
        return CollectionsKt.build((List)list);
    }

    private final List<Pair<Integer, BehaviorControl<? super PokemonEntity>>> idleTasks(Pokemon pokemon) {
        List list;
        List $this$idleTasks_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, WakeUpTask.INSTANCE.create()));
        if (pokemon.getForm().getBehaviour().getMoving().getCanLook()) {
            $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, new LookAroundTaskWrapper(45, 90)));
        }
        $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, ChooseLandWanderTargetTask.INSTANCE.create(pokemon.getForm().getBehaviour().getMoving().getWanderChance(), 10, 5, 0.33f, 1)));
        $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, GoToSleepTask.INSTANCE.create(false)));
        $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, FindRestingPlaceTask.INSTANCE.create(16, 8)));
        $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, AttackAngryAtTask.INSTANCE.create()));
        Integer n = 0;
        UniformInt uniformInt = ADULT_FOLLOW_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)uniformInt, (String)"ADULT_FOLLOW_RANGE");
        $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(n, WalkTowardsParentSpeciesTask.INSTANCE.create(uniformInt, 0.4f)));
        if (pokemon.getForm().getBehaviour().getCombat().getWillDefendOwner()) {
            $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, DefendOwnerTask.INSTANCE.create()));
        }
        Integer n2 = 0;
        MemoryModuleType memoryModuleType = MemoryModuleType.ATTACK_TARGET;
        Intrinsics.checkNotNullExpressionValue((Object)memoryModuleType, (String)"ATTACK_TARGET");
        Activity activity = Activity.FIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"FIGHT");
        $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(n2, SwapActivityTask.INSTANCE.possessing(memoryModuleType, activity)));
        Integer n3 = 0;
        MemoryModuleType memoryModuleType2 = MemoryModuleType.AVOID_TARGET;
        Intrinsics.checkNotNullExpressionValue((Object)memoryModuleType2, (String)"AVOID_TARGET");
        Activity activity2 = Activity.AVOID;
        Intrinsics.checkNotNullExpressionValue((Object)activity2, (String)"AVOID");
        $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(n3, SwapActivityTask.INSTANCE.possessing(memoryModuleType2, activity2)));
        $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(1, new FertilizerTask()));
        if (StringsKt.equals((String)pokemon.getSpecies().getPrimaryType().getName(), (String)"fire", (boolean)true)) {
            $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(1, new IgniteTask()));
        }
        if (pokemon.getForm().getBehaviour().getMoving().getSwim().getCanBreatheUnderwater()) {
            $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, ChooseWaterWanderTargetTask.INSTANCE.create(pokemon.getForm().getBehaviour().getMoving().getWanderChance(), 10, 5, 0.33f, 1)));
            $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(1, new JumpOutOfWaterTask()));
        }
        if (pokemon.getForm().getBehaviour().getMoving().getFly().getCanFly()) {
            $this$idleTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, ChooseFlightWanderTargetTask.INSTANCE.create(pokemon.getForm().getBehaviour().getMoving().getWanderChance(), 10, 5, 0.33f, 1)));
        }
        return CollectionsKt.build((List)list);
    }

    private final RunOne<PokemonEntity> makeRandomWalkTask() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.4f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.4f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private final List<Pair<Integer, BehaviorControl<? super PokemonEntity>>> battlingTasks() {
        List list;
        List $this$battlingTasks_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$battlingTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, LookAtTargetedBattlePokemonTask.INSTANCE.create()));
        $this$battlingTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, new LookAtTargetSink(0x7FFFFFFE, 0x7FFFFFFE)));
        $this$battlingTasks_u24lambda_u240.add(MiscUtilsKt.toDF(0, ManageFlightInBattleTask.INSTANCE.create()));
        Integer n = 0;
        Activity activity = Activity.IDLE;
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"IDLE");
        $this$battlingTasks_u24lambda_u240.add(MiscUtilsKt.toDF(n, SwapActivityTask.INSTANCE.lacking(CobblemonMemories.POKEMON_BATTLE, activity)));
        return CollectionsKt.build((List)list);
    }

    private final List<Pair<Integer, BehaviorControl<? super PokemonEntity>>> sleepingTasks() {
        List list;
        List $this$sleepingTasks_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$sleepingTasks_u24lambda_u240.add(MiscUtilsKt.toDF(1, WakeUpTask.INSTANCE.create()));
        return CollectionsKt.build((List)list);
    }

    private final List<Pair<Integer, BehaviorControl<? super PokemonEntity>>> growingPlantTasks(Pokemon pokemon) {
        List list;
        List $this$growingPlantTasks_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (StringsKt.equals((String)pokemon.getSpecies().getPrimaryType().getName(), (String)"grass", (boolean)true)) {
            $this$growingPlantTasks_u24lambda_u240.add(MiscUtilsKt.toDF(1, new FertilizerTask()));
        }
        return CollectionsKt.build((List)list);
    }

    public final void onCaptureFailed(@NotNull PokemonEntity pokemonEntity, @NotNull Entity capturer) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Intrinsics.checkNotNullParameter((Object)capturer, (String)"capturer");
        if (pokemonEntity.getPokemon().isWild() && pokemonEntity.getBattleId() == null && capturer instanceof LivingEntity) {
            pokemonEntity.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            pokemonEntity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            pokemonEntity.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)capturer, (long)AVOID_MEMORY_DURATION.sample(pokemonEntity.getRandom()));
        }
    }

    static {
        Object[] objectArray = new SensorType[12];
        Intrinsics.checkNotNullExpressionValue((Object)SensorType.NEAREST_LIVING_ENTITIES, (String)"NEAREST_LIVING_ENTITIES");
        Intrinsics.checkNotNullExpressionValue((Object)SensorType.HURT_BY, (String)"HURT_BY");
        Intrinsics.checkNotNullExpressionValue((Object)SensorType.NEAREST_PLAYERS, (String)"NEAREST_PLAYERS");
        objectArray[3] = CobblemonSensors.POKEMON_DISTURBANCE;
        objectArray[4] = CobblemonSensors.POKEMON_DEFEND_OWNER;
        objectArray[5] = CobblemonSensors.POKEMON_DROWSY;
        objectArray[6] = CobblemonSensors.POKEMON_ADULT;
        Intrinsics.checkNotNullExpressionValue((Object)SensorType.IS_IN_WATER, (String)"IS_IN_WATER");
        objectArray[8] = CobblemonSensors.NEARBY_GROWABLE_CROPS;
        objectArray[9] = CobblemonSensors.NEARBY_BEE_HIVE;
        objectArray[10] = CobblemonSensors.NEARBY_FLOWER;
        objectArray[11] = CobblemonSensors.NEARBY_SWEET_BERRY_BUSH;
        SENSORS = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.ANGRY_AT, MemoryModuleType.ATTACK_COOLING_DOWN, CobblemonMemories.POKEMON_DROWSY, CobblemonMemories.POKEMON_BATTLE, MemoryModuleType.HOME, CobblemonMemories.PATH_COOLDOWN, CobblemonMemories.TARGETED_BATTLE_POKEMON, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.IS_IN_WATER, MemoryModuleType.DISTURBANCE_LOCATION, CobblemonMemories.NEARBY_GROWABLE_CROPS, MemoryModuleType.AVOID_TARGET, CobblemonMemories.POKEMON_SLEEPING, CobblemonMemories.RECENTLY_ATE_GRASS, CobblemonMemories.HIVE_LOCATION, CobblemonMemories.HIVE_COOLDOWN, CobblemonMemories.NEARBY_FLOWER, CobblemonMemories.HAS_NECTAR, CobblemonMemories.RECENTLY_ATE_GRASS, CobblemonMemories.HERD_LEADER, CobblemonMemories.HERD_SIZE, CobblemonMemories.ATTACK_TARGET_DATA, CobblemonMemories.NEARBY_SWEET_BERRY_BUSH};
        ImmutableList immutableList = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, CobblemonMemories.POKEMON_FLYING, CobblemonMemories.NEAREST_VISIBLE_ATTACKER, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.NEAREST_PLAYERS, (Object[])objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
        MEMORY_MODULES = (List)immutableList;
    }
}

