/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.util;

import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.PositionType;
import com.cobblemon.mod.common.util.TraceResult;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a?\u0010\u000b\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\u001aC\u0010\u0015\u001a\u00020\u0010\"\b\b\u0000\u0010\u000e*\u00020\r*\u00020\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0019\u0010\u0019\u001a\u00020\u0017*\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u0019\u0010\u001f\u001a\u00020\u001e*\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001f\u0010 \u001a#\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!*\u00020\u001c\u00a2\u0006\u0004\b#\u0010$\u001a3\u0010)\u001a\u00020\n*\u00020%2\u0006\u0010\u001d\u001a\u00020\u001c2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0&\u00a2\u0006\u0004\b)\u0010*\u001aC\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00028\u00000/0.\"\b\b\u0000\u0010\u000e*\u00020+*\u00020%2\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000,\u00a2\u0006\u0004\b0\u00101\u001a\u001f\u00103\u001a\b\u0012\u0004\u0012\u00020'02*\u00020%2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b3\u00104\u001a+\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00170/02*\u00020%2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b5\u00104\u001a\u001f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001702*\u00020%2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b6\u00104\u001a%\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0/*\u00020%2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b7\u00108\u001a\u0019\u0010:\u001a\u00020\u001e*\u0002092\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b:\u0010;\u001a\u0019\u0010:\u001a\u00020\u001e*\u0002092\u0006\u0010<\u001a\u00020\u0001\u00a2\u0006\u0004\b:\u0010=\u001a5\u0010B\u001a\u00020\u001e*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00172\b\b\u0002\u0010>\u001a\u00020\u00102\b\b\u0002\u0010?\u001a\u00020\u00102\u0006\u0010A\u001a\u00020@\u00a2\u0006\u0004\bB\u0010C\u001a/\u0010H\u001a\u0004\u0018\u00010G*\u00020\u00012\u0006\u0010D\u001a\u00020\u00002\b\b\u0002\u0010E\u001a\u00020\u00072\b\b\u0002\u0010F\u001a\u00020\u0007\u00a2\u0006\u0004\bH\u0010I\"\u001b\u0010N\u001a\b\u0012\u0004\u0012\u00020K0J*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bL\u0010M\"\u001b\u0010Q\u001a\b\u0012\u0004\u0012\u00020O0J*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bP\u0010M\"\u001b\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00000J*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bR\u0010M\"\u001b\u0010V\u001a\b\u0012\u0004\u0012\u00020T0J*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bU\u0010M\"\u001b\u0010Y\u001a\b\u0012\u0004\u0012\u00020W0J*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bX\u0010M\"\u001b\u0010\\\u001a\b\u0012\u0004\u0012\u00020Z0J*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b[\u0010M\"\u001f\u0010_\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030]0J*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b^\u0010M\"\u001b\u0010b\u001a\b\u0012\u0004\u0012\u00020`0J*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\ba\u0010M\u00a8\u0006c"}, d2={"Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/phys/Vec3;", "position", "Lnet/minecraft/sounds/SoundEvent;", "sound", "Lnet/minecraft/sounds/SoundSource;", "category", "", "volume", "pitch", "", "playSoundServer", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", "Lnet/minecraft/core/particles/ParticleOptions;", "T", "particleType", "", "particles", "offset", "", "speed", "sendParticlesServer", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/world/phys/Vec3;ILnet/minecraft/world/phys/Vec3;D)I", "Lnet/minecraft/core/BlockPos;", "pos", "squeezeWithinBounds", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/world/phys/AABB;", "box", "", "isBoxLoaded", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/AABB;)Z", "Lkotlin/Triple;", "Lkotlin/ranges/IntRange;", "getRanges", "(Lnet/minecraft/world/phys/AABB;)Lkotlin/Triple;", "Lnet/minecraft/world/level/BlockGetter;", "Lkotlin/Function2;", "Lnet/minecraft/world/level/block/state/BlockState;", "action", "doForAllBlocksIn", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/phys/AABB;Lkotlin/jvm/functions/Function2;)V", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "blockEntityType", "", "Lkotlin/Pair;", "getNearbyBlockEntities", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/block/entity/BlockEntityType;)Ljava/util/List;", "", "getBlockStates", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/phys/AABB;)Ljava/lang/Iterable;", "getBlockStatesWithPos", "getBlockPositions", "getWaterAndLavaIn", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/phys/AABB;)Lkotlin/Pair;", "Lnet/minecraft/world/entity/Entity;", "canFit", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;)Z", "vec", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;)Z", "width", "height", "Lcom/cobblemon/mod/common/util/PositionType;", "positionType", "canEntityStayAt", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;IILcom/cobblemon/mod/common/util/PositionType;)Z", "world", "maxDistance", "stepDistance", "Lcom/cobblemon/mod/common/util/TraceResult;", "traceDownwards", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;FF)Lcom/cobblemon/mod/common/util/TraceResult;", "Lnet/minecraft/core/Registry;", "Lnet/minecraft/world/item/Item;", "getItemRegistry", "(Lnet/minecraft/world/level/Level;)Lnet/minecraft/core/Registry;", "itemRegistry", "Lnet/minecraft/world/level/biome/Biome;", "getBiomeRegistry", "biomeRegistry", "getWorldRegistry", "worldRegistry", "Lnet/minecraft/world/item/enchantment/Enchantment;", "getEnchantmentRegistry", "enchantmentRegistry", "Lnet/minecraft/world/entity/schedule/Activity;", "getActivityRegistry", "activityRegistry", "Lnet/minecraft/world/level/block/Block;", "getBlockRegistry", "blockRegistry", "Lnet/minecraft/world/entity/EntityType;", "getEntityTypeRegistry", "entityTypeRegistry", "Lnet/minecraft/world/level/material/Fluid;", "getFluidRegistry", "fluidRegistry", "common"})
public final class WorldExtensionsKt {
    public static final void playSoundServer(@NotNull Level $this$playSoundServer, @NotNull Vec3 position, @NotNull SoundEvent sound, @NotNull SoundSource category, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)$this$playSoundServer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        ((ServerLevel)$this$playSoundServer).playSound(null, position.x, position.y, position.z, sound, category, volume, pitch);
    }

    public static /* synthetic */ void playSoundServer$default(Level level, Vec3 vec3, SoundEvent soundEvent, SoundSource soundSource, float f, float f2, int n, Object object) {
        if ((n & 4) != 0) {
            soundSource = SoundSource.NEUTRAL;
        }
        if ((n & 8) != 0) {
            f = 1.0f;
        }
        if ((n & 0x10) != 0) {
            f2 = 1.0f;
        }
        WorldExtensionsKt.playSoundServer(level, vec3, soundEvent, soundSource, f, f2);
    }

    public static final <T extends ParticleOptions> int sendParticlesServer(@NotNull Level $this$sendParticlesServer, @NotNull T particleType, @NotNull Vec3 position, int particles, @NotNull Vec3 offset, double speed) {
        Intrinsics.checkNotNullParameter((Object)$this$sendParticlesServer, (String)"<this>");
        Intrinsics.checkNotNullParameter(particleType, (String)"particleType");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return ((ServerLevel)$this$sendParticlesServer).sendParticles(particleType, position.x, position.y, position.z, particles, offset.x, offset.y, offset.z, speed);
    }

    @NotNull
    public static final BlockPos squeezeWithinBounds(@NotNull Level $this$squeezeWithinBounds, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)$this$squeezeWithinBounds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        WorldBorder border = $this$squeezeWithinBounds.getWorldBorder();
        return new BlockPos(RangesKt.coerceIn((int)pos.getX(), (int)((int)border.getMinX()), (int)((int)border.getMaxX())), RangesKt.coerceIn((int)pos.getY(), (int)$this$squeezeWithinBounds.getMinBuildHeight(), (int)$this$squeezeWithinBounds.getMaxBuildHeight()), RangesKt.coerceIn((int)pos.getZ(), (int)((int)border.getMinZ()), (int)((int)border.getMaxZ())));
    }

    public static final boolean isBoxLoaded(@NotNull ServerLevel $this$isBoxLoaded, @NotNull AABB box) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoxLoaded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        int startChunkX = SectionPos.posToSectionCoord((double)box.minX);
        int startChunkZ = SectionPos.posToSectionCoord((double)box.minZ);
        int endChunkX = SectionPos.posToSectionCoord((double)box.maxX);
        int endChunkZ = SectionPos.posToSectionCoord((double)box.maxZ);
        int chunkX = startChunkX;
        if (chunkX <= endChunkX) {
            while (true) {
                int chunkZ;
                if ((chunkZ = startChunkZ) <= endChunkZ) {
                    while (true) {
                        if (!$this$isBoxLoaded.areEntitiesLoaded(ChunkPos.asLong((int)chunkX, (int)chunkZ))) {
                            return false;
                        }
                        if (chunkZ == endChunkZ) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == endChunkX) break;
                ++chunkX;
            }
        }
        return true;
    }

    @NotNull
    public static final Triple<IntRange, IntRange, IntRange> getRanges(@NotNull AABB $this$getRanges) {
        Intrinsics.checkNotNullParameter((Object)$this$getRanges, (String)"<this>");
        int minX = Mth.floor((double)$this$getRanges.minX);
        int minY = Mth.floor((double)$this$getRanges.minY);
        int minZ = Mth.floor((double)$this$getRanges.minZ);
        int maxX = Mth.floor((double)$this$getRanges.maxX);
        int maxY = Mth.floor((double)$this$getRanges.maxY);
        int maxZ = Mth.floor((double)$this$getRanges.maxZ);
        return new Triple((Object)new IntRange(minX, maxX), (Object)new IntRange(minY, maxY), (Object)new IntRange(minZ, maxZ));
    }

    public static final void doForAllBlocksIn(@NotNull BlockGetter $this$doForAllBlocksIn, @NotNull AABB box, @NotNull Function2<? super BlockState, ? super BlockPos, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$doForAllBlocksIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Triple<IntRange, IntRange, IntRange> triple = WorldExtensionsKt.getRanges(box);
        IntRange xRange = (IntRange)triple.component1();
        IntRange yRange = (IntRange)triple.component2();
        IntRange zRange = (IntRange)triple.component3();
        int x = xRange.getFirst();
        int n = xRange.getLast();
        if (x <= n) {
            while (true) {
                int n2;
                int y;
                if ((y = yRange.getFirst()) <= (n2 = yRange.getLast())) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = zRange.getFirst()) <= (n3 = zRange.getLast())) {
                            while (true) {
                                BlockPos.MutableBlockPos pos = mutable.set(x, y, z);
                                BlockState state = $this$doForAllBlocksIn.getBlockState((BlockPos)pos);
                                Intrinsics.checkNotNull((Object)state);
                                Intrinsics.checkNotNull((Object)pos);
                                action.invoke((Object)state, (Object)pos);
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
    }

    @NotNull
    public static final <T extends BlockEntity> List<Pair<BlockPos, T>> getNearbyBlockEntities(@NotNull BlockGetter $this$getNearbyBlockEntities, @NotNull AABB box, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)$this$getNearbyBlockEntities, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        List entities = new ArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Triple<IntRange, IntRange, IntRange> triple = WorldExtensionsKt.getRanges(box);
        IntRange xRange = (IntRange)triple.component1();
        IntRange yRange = (IntRange)triple.component2();
        IntRange zRange = (IntRange)triple.component3();
        int x = xRange.getFirst();
        int n = xRange.getLast();
        if (x <= n) {
            while (true) {
                int n2;
                int y;
                if ((y = yRange.getFirst()) <= (n2 = yRange.getLast())) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = zRange.getFirst()) <= (n3 = zRange.getLast())) {
                            while (true) {
                                BlockPos.MutableBlockPos pos = mutable.set(x, y, z);
                                $this$getNearbyBlockEntities.getBlockEntity((BlockPos)pos, blockEntityType).ifPresent(arg_0 -> WorldExtensionsKt.getNearbyBlockEntities$lambda$1(arg_0 -> WorldExtensionsKt.getNearbyBlockEntities$lambda$0(entities, pos, arg_0), arg_0));
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        return entities;
    }

    @NotNull
    public static final Iterable<BlockState> getBlockStates(@NotNull BlockGetter $this$getBlockStates, @NotNull AABB box) {
        Intrinsics.checkNotNullParameter((Object)$this$getBlockStates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        List states = new ArrayList();
        WorldExtensionsKt.doForAllBlocksIn($this$getBlockStates, box, (Function2<? super BlockState, ? super BlockPos, Unit>)((Function2)(arg_0, arg_1) -> WorldExtensionsKt.getBlockStates$lambda$0(states, arg_0, arg_1)));
        return states;
    }

    @NotNull
    public static final Iterable<Pair<BlockState, BlockPos>> getBlockStatesWithPos(@NotNull BlockGetter $this$getBlockStatesWithPos, @NotNull AABB box) {
        Intrinsics.checkNotNullParameter((Object)$this$getBlockStatesWithPos, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        List states = new ArrayList();
        WorldExtensionsKt.doForAllBlocksIn($this$getBlockStatesWithPos, box, (Function2<? super BlockState, ? super BlockPos, Unit>)((Function2)(arg_0, arg_1) -> WorldExtensionsKt.getBlockStatesWithPos$lambda$0(states, arg_0, arg_1)));
        return states;
    }

    @NotNull
    public static final Iterable<BlockPos> getBlockPositions(@NotNull BlockGetter $this$getBlockPositions, @NotNull AABB box) {
        Intrinsics.checkNotNullParameter((Object)$this$getBlockPositions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        List positions = new ArrayList();
        Triple<IntRange, IntRange, IntRange> triple = WorldExtensionsKt.getRanges(box);
        IntRange xRange = (IntRange)triple.component1();
        IntRange yRange = (IntRange)triple.component2();
        IntRange zRange = (IntRange)triple.component3();
        int x = xRange.getFirst();
        int n = xRange.getLast();
        if (x <= n) {
            while (true) {
                int n2;
                int y;
                if ((y = yRange.getFirst()) <= (n2 = yRange.getLast())) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = zRange.getFirst()) <= (n3 = zRange.getLast())) {
                            while (true) {
                                positions.add(new BlockPos(x, y, z));
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        return positions;
    }

    @NotNull
    public static final Pair<Boolean, Boolean> getWaterAndLavaIn(@NotNull BlockGetter $this$getWaterAndLavaIn, @NotNull AABB box) {
        Intrinsics.checkNotNullParameter((Object)$this$getWaterAndLavaIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Ref.BooleanRef hasWater = new Ref.BooleanRef();
        Ref.BooleanRef hasLava = new Ref.BooleanRef();
        WorldExtensionsKt.doForAllBlocksIn($this$getWaterAndLavaIn, box, (Function2<? super BlockState, ? super BlockPos, Unit>)((Function2)(arg_0, arg_1) -> WorldExtensionsKt.getWaterAndLavaIn$lambda$0(hasWater, hasLava, arg_0, arg_1)));
        return TuplesKt.to((Object)hasWater.element, (Object)hasLava.element);
    }

    public static final boolean canFit(@NotNull Entity $this$canFit, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)$this$canFit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return WorldExtensionsKt.canFit($this$canFit, BlockPosExtensionsKt.toVec3d(pos));
    }

    public static final boolean canFit(@NotNull Entity $this$canFit, @NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)$this$canFit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        AABB box = $this$canFit.getBoundingBox().move(vec.subtract($this$canFit.position()));
        return $this$canFit.level().noCollision(box);
    }

    public static final boolean canEntityStayAt(@NotNull Level $this$canEntityStayAt, @NotNull BlockPos position, int width, int height, @NotNull PositionType positionType) {
        Intrinsics.checkNotNullParameter((Object)$this$canEntityStayAt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)((Object)positionType), (String)"positionType");
        int minX = (int)Math.floor((double)position.getX() + 0.5 - (double)((float)(width - 1) / 2.0f));
        int maxX = (int)Math.ceil((double)position.getX() + 0.5 + (double)((float)(width - 1) / 2.0f));
        int maxY = position.getY() + height;
        int minZ = (int)Math.floor((double)position.getZ() + 0.5 - (double)((float)(width - 1) / 2.0f));
        int maxZ = (int)Math.ceil((double)position.getZ() + 0.5 + (double)((float)(width - 1) / 2.0f));
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        block5: for (int x = minX; x < maxX; ++x) {
            int y = position.getY();
            if (y > maxY) continue;
            while (true) {
                block7: for (int z = minZ; z < maxZ; ++z) {
                    BlockState state = $this$canEntityStayAt.getBlockState((BlockPos)mutable.set(x, y, z));
                    if (y == position.getY()) {
                        if (positionType != PositionType.LAND || !state.isPathfindable(PathComputationType.LAND)) continue;
                        return false;
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[positionType.ordinal()]) {
                        case 1: {
                            if (state.isPathfindable(PathComputationType.LAND)) continue block7;
                            return false;
                        }
                        case 2: 
                        case 3: {
                            if (state.getFluidState().is(FluidTags.WATER)) continue block7;
                            return false;
                        }
                        case 4: {
                            if (state.getFluidState().is(FluidTags.LAVA)) continue block7;
                            return false;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (y == maxY) continue block5;
                ++y;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean canEntityStayAt$default(Level level, BlockPos blockPos, int n, int n2, PositionType positionType, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 1;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return WorldExtensionsKt.canEntityStayAt(level, blockPos, n, n2, positionType);
    }

    @NotNull
    public static final Registry<Item> getItemRegistry(@NotNull Level $this$itemRegistry) {
        Intrinsics.checkNotNullParameter((Object)$this$itemRegistry, (String)"<this>");
        Registry registry = $this$itemRegistry.registryAccess().registryOrThrow(Registries.ITEM);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @NotNull
    public static final Registry<Biome> getBiomeRegistry(@NotNull Level $this$biomeRegistry) {
        Intrinsics.checkNotNullParameter((Object)$this$biomeRegistry, (String)"<this>");
        Registry registry = $this$biomeRegistry.registryAccess().registryOrThrow(Registries.BIOME);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @NotNull
    public static final Registry<Level> getWorldRegistry(@NotNull Level $this$worldRegistry) {
        Intrinsics.checkNotNullParameter((Object)$this$worldRegistry, (String)"<this>");
        Registry registry = $this$worldRegistry.registryAccess().registryOrThrow(Registries.DIMENSION);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @NotNull
    public static final Registry<Enchantment> getEnchantmentRegistry(@NotNull Level $this$enchantmentRegistry) {
        Intrinsics.checkNotNullParameter((Object)$this$enchantmentRegistry, (String)"<this>");
        Registry registry = $this$enchantmentRegistry.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @NotNull
    public static final Registry<Activity> getActivityRegistry(@NotNull Level $this$activityRegistry) {
        Intrinsics.checkNotNullParameter((Object)$this$activityRegistry, (String)"<this>");
        Registry registry = $this$activityRegistry.registryAccess().registryOrThrow(Registries.ACTIVITY);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @NotNull
    public static final Registry<Block> getBlockRegistry(@NotNull Level $this$blockRegistry) {
        Intrinsics.checkNotNullParameter((Object)$this$blockRegistry, (String)"<this>");
        Registry registry = $this$blockRegistry.registryAccess().registryOrThrow(Registries.BLOCK);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @NotNull
    public static final Registry<EntityType<?>> getEntityTypeRegistry(@NotNull Level $this$entityTypeRegistry) {
        Intrinsics.checkNotNullParameter((Object)$this$entityTypeRegistry, (String)"<this>");
        Registry registry = $this$entityTypeRegistry.registryAccess().registryOrThrow(Registries.ENTITY_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @NotNull
    public static final Registry<Fluid> getFluidRegistry(@NotNull Level $this$fluidRegistry) {
        Intrinsics.checkNotNullParameter((Object)$this$fluidRegistry, (String)"<this>");
        Registry registry = $this$fluidRegistry.registryAccess().registryOrThrow(Registries.FLUID);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @Nullable
    public static final TraceResult traceDownwards(@NotNull Vec3 $this$traceDownwards, @NotNull Level world, float maxDistance, float stepDistance) {
        Intrinsics.checkNotNullParameter((Object)$this$traceDownwards, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Vec3 startPos = new Vec3($this$traceDownwards.x, $this$traceDownwards.y, $this$traceDownwards.z);
        Vec3 direction = new Vec3(0.0, -1.0, 0.0);
        BlockPos lastBlockPos = Vec3ExtensionsKt.toBlockPos(startPos);
        for (float step = stepDistance; step <= maxDistance; step += stepDistance) {
            Vec3 location = startPos.add(direction.scale((double)step));
            Intrinsics.checkNotNull((Object)location);
            BlockPos blockPos = Vec3ExtensionsKt.toBlockPos(location);
            if (Intrinsics.areEqual((Object)blockPos, (Object)lastBlockPos)) continue;
            lastBlockPos = blockPos;
            BlockState block = world.getBlockState(blockPos);
            if (block.isAir()) continue;
            Direction dir = PlayerExtensionsKt.findDirectionForIntercept(startPos, location, blockPos);
            return new TraceResult(location, blockPos, dir);
        }
        return null;
    }

    public static /* synthetic */ TraceResult traceDownwards$default(Vec3 vec3, Level level, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f = 10.0f;
        }
        if ((n & 4) != 0) {
            f2 = 0.5f;
        }
        return WorldExtensionsKt.traceDownwards(vec3, level, f, f2);
    }

    private static final Unit getNearbyBlockEntities$lambda$0(List $entities, BlockPos.MutableBlockPos $pos, BlockEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $entities.add(TuplesKt.to((Object)$pos.immutable(), (Object)it));
        return Unit.INSTANCE;
    }

    private static final void getNearbyBlockEntities$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit getBlockStates$lambda$0(List $states, BlockState state, BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<unused var>");
        $states.add(state);
        return Unit.INSTANCE;
    }

    private static final Unit getBlockStatesWithPos$lambda$0(List $states, BlockState state, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        $states.add(TuplesKt.to((Object)state, (Object)pos.immutable()));
        return Unit.INSTANCE;
    }

    private static final Unit getWaterAndLavaIn$lambda$0(Ref.BooleanRef $hasWater, Ref.BooleanRef $hasLava, BlockState state, BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<unused var>");
        if (!$hasWater.element && state.getFluidState().is(FluidTags.WATER)) {
            $hasWater.element = true;
        }
        if (!$hasLava.element && state.getFluidState().is(FluidTags.LAVA)) {
            $hasLava.element = true;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PositionType.values().length];
            try {
                nArray[PositionType.LAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionType.WATER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionType.SEAFLOOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionType.LAVAFLOOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

