/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.world;

import com.cobblemon.mod.common.mixin.StructurePoolAccessor;
import com.cobblemon.mod.common.world.CobblemonStructureIDs;
import com.cobblemon.mod.common.world.structureprocessors.CobblemonStructureProcessorLists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000e\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0010\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ+\u0010\u0011\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJW\u0010\u001b\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJc\u0010\u001f\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\b\b\u0002\u0010\u001e\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001f\u0010 R8\u0010\"\u001a&\u0012\f\u0012\n !*\u0004\u0018\u00010\f0\f !*\u0012\u0012\f\u0012\n !*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b&\u0010%R\u0014\u0010'\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010%R\u001f\u0010(\u001a\n !*\u0004\u0018\u00010\u00120\u00128\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u001f\u0010,\u001a\n !*\u0004\u0018\u00010\u00120\u00128\u0006\u00a2\u0006\f\n\u0004\b,\u0010)\u001a\u0004\b-\u0010+R\u001f\u0010.\u001a\n !*\u0004\u0018\u00010\u00120\u00128\u0006\u00a2\u0006\f\n\u0004\b.\u0010)\u001a\u0004\b/\u0010+R\u001f\u00100\u001a\n !*\u0004\u0018\u00010\u00120\u00128\u0006\u00a2\u0006\f\n\u0004\b0\u0010)\u001a\u0004\b1\u0010+R\u001f\u00102\u001a\n !*\u0004\u0018\u00010\u00120\u00128\u0006\u00a2\u0006\f\n\u0004\b2\u0010)\u001a\u0004\b3\u0010+\u00a8\u00064"}, d2={"Lcom/cobblemon/mod/common/world/CobblemonStructures;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "registerJigsaws", "(Lnet/minecraft/server/MinecraftServer;)V", "Lnet/minecraft/core/Registry;", "Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;", "templatePoolRegistry", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureProcessorList;", "processorListRegistry", "addBerryFarms", "(Lnet/minecraft/core/Registry;Lnet/minecraft/core/Registry;)V", "addPokecenters", "addLongPaths", "Lnet/minecraft/resources/ResourceLocation;", "poolRL", "nbtPieceRL", "", "weight", "Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool$Projection;", "projection", "Lnet/minecraft/resources/ResourceKey;", "processorListKey", "addLegacyBuildingToPool", "(Lnet/minecraft/core/Registry;Lnet/minecraft/core/Registry;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;ILnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool$Projection;Lnet/minecraft/resources/ResourceKey;)V", "", "shouldUseLegacySingePoolElement", "addBuildingToPool", "(Lnet/minecraft/core/Registry;Lnet/minecraft/core/Registry;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;ILnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool$Projection;Lnet/minecraft/resources/ResourceKey;Z)V", "kotlin.jvm.PlatformType", "EMPTY_PROCESSOR_LIST_KEY", "Lnet/minecraft/resources/ResourceKey;", "pokecenterWeight", "I", "berryFarmWeight", "longPathWeight", "plainsHousesPoolLocation", "Lnet/minecraft/resources/ResourceLocation;", "getPlainsHousesPoolLocation", "()Lnet/minecraft/resources/ResourceLocation;", "desertHousesPoolLocation", "getDesertHousesPoolLocation", "savannaHousesPoolLocation", "getSavannaHousesPoolLocation", "snowyHousesPoolLocation", "getSnowyHousesPoolLocation", "taigaHousesPoolLocation", "getTaigaHousesPoolLocation", "common"})
@SourceDebugExtension(value={"SMAP\nCobblemonStructures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonStructures.kt\ncom/cobblemon/mod/common/world/CobblemonStructures\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
public final class CobblemonStructures {
    @NotNull
    public static final CobblemonStructures INSTANCE = new CobblemonStructures();
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"));
    private static final int pokecenterWeight = 35;
    private static final int berryFarmWeight = 1;
    private static final int longPathWeight = 10;
    private static final ResourceLocation plainsHousesPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/plains/houses");
    private static final ResourceLocation desertHousesPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/desert/houses");
    private static final ResourceLocation savannaHousesPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/savanna/houses");
    private static final ResourceLocation snowyHousesPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/snowy/houses");
    private static final ResourceLocation taigaHousesPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/taiga/houses");

    private CobblemonStructures() {
    }

    public final ResourceLocation getPlainsHousesPoolLocation() {
        return plainsHousesPoolLocation;
    }

    public final ResourceLocation getDesertHousesPoolLocation() {
        return desertHousesPoolLocation;
    }

    public final ResourceLocation getSavannaHousesPoolLocation() {
        return savannaHousesPoolLocation;
    }

    public final ResourceLocation getSnowyHousesPoolLocation() {
        return snowyHousesPoolLocation;
    }

    public final ResourceLocation getTaigaHousesPoolLocation() {
        return taigaHousesPoolLocation;
    }

    public final void registerJigsaws(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Registry templatePoolRegistry = server.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
        Registry processorListRegistry = server.registryAccess().registryOrThrow(Registries.PROCESSOR_LIST);
        Intrinsics.checkNotNull((Object)templatePoolRegistry);
        Intrinsics.checkNotNull((Object)processorListRegistry);
        this.addPokecenters((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry);
        this.addBerryFarms((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry);
    }

    public final void addBerryFarms(@NotNull Registry<StructureTemplatePool> templatePoolRegistry, @NotNull Registry<StructureProcessorList> processorListRegistry) {
        Intrinsics.checkNotNullParameter(templatePoolRegistry, (String)"templatePoolRegistry");
        Intrinsics.checkNotNullParameter(processorListRegistry, (String)"processorListRegistry");
        ResourceKey<StructureProcessorList> cropToBerryProcessorList = CobblemonStructureProcessorLists.CROP_TO_BERRY;
        ResourceLocation resourceLocation = plainsHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"plainsHousesPoolLocation");
        Intrinsics.checkNotNull(cropToBerryProcessorList);
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation, CobblemonStructureIDs.PLAINS_BERRY_SMALL, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
        ResourceLocation resourceLocation2 = plainsHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"plainsHousesPoolLocation");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation2, CobblemonStructureIDs.PLAINS_BERRY_LARGE, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
        ResourceLocation resourceLocation3 = desertHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"desertHousesPoolLocation");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation3, CobblemonStructureIDs.DESERT_BERRY_SMALL, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
        ResourceLocation resourceLocation4 = desertHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"desertHousesPoolLocation");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation4, CobblemonStructureIDs.DESERT_BERRY_LARGE, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
        ResourceLocation resourceLocation5 = savannaHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"savannaHousesPoolLocation");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation5, CobblemonStructureIDs.SAVANNA_BERRY_SMALL, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
        ResourceLocation resourceLocation6 = savannaHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"savannaHousesPoolLocation");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation6, CobblemonStructureIDs.SAVANNA_BERRY_LARGE, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
        ResourceLocation resourceLocation7 = taigaHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation7, (String)"taigaHousesPoolLocation");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation7, CobblemonStructureIDs.TAIGA_BERRY_SMALL, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
        ResourceLocation resourceLocation8 = taigaHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation8, (String)"taigaHousesPoolLocation");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation8, CobblemonStructureIDs.TAIGA_BERRY_LARGE, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
        ResourceLocation resourceLocation9 = snowyHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation9, (String)"snowyHousesPoolLocation");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation9, CobblemonStructureIDs.SNOWY_BERRY_SMALL, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
        ResourceLocation resourceLocation10 = snowyHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation10, (String)"snowyHousesPoolLocation");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation10, CobblemonStructureIDs.SNOWY_BERRY_LARGE, 1, StructureTemplatePool.Projection.RIGID, cropToBerryProcessorList, false, 128, null);
    }

    private final void addPokecenters(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry) {
        ResourceLocation resourceLocation = plainsHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"plainsHousesPoolLocation");
        ResourceKey<StructureProcessorList> resourceKey = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey, (String)"EMPTY_PROCESSOR_LIST_KEY");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation, CobblemonStructureIDs.VILLAGE_PLAINS_POKECENTER, 35, StructureTemplatePool.Projection.RIGID, resourceKey, false, 128, null);
        ResourceLocation resourceLocation2 = desertHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"desertHousesPoolLocation");
        ResourceKey<StructureProcessorList> resourceKey2 = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey2, (String)"EMPTY_PROCESSOR_LIST_KEY");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation2, CobblemonStructureIDs.VILLAGE_DESERT_POKECENTER, 35, StructureTemplatePool.Projection.RIGID, resourceKey2, false, 128, null);
        ResourceLocation resourceLocation3 = savannaHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"savannaHousesPoolLocation");
        ResourceKey<StructureProcessorList> resourceKey3 = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey3, (String)"EMPTY_PROCESSOR_LIST_KEY");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation3, CobblemonStructureIDs.VILLAGE_SAVANNA_POKECENTER, 35, StructureTemplatePool.Projection.RIGID, resourceKey3, false, 128, null);
        ResourceLocation resourceLocation4 = snowyHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"snowyHousesPoolLocation");
        ResourceKey<StructureProcessorList> resourceKey4 = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey4, (String)"EMPTY_PROCESSOR_LIST_KEY");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation4, CobblemonStructureIDs.VILLAGE_SNOWY_POKECENTER, 35, StructureTemplatePool.Projection.RIGID, resourceKey4, false, 128, null);
        ResourceLocation resourceLocation5 = taigaHousesPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"taigaHousesPoolLocation");
        ResourceKey resourceKey5 = ProcessorLists.MOSSIFY_10_PERCENT;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey5, (String)"MOSSIFY_10_PERCENT");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, resourceLocation5, CobblemonStructureIDs.VILLAGE_TAIGA_POKECENTER, 35, StructureTemplatePool.Projection.RIGID, resourceKey5, false, 128, null);
    }

    private final void addLongPaths(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry) {
        ResourceLocation plainsStreetsPoolLocation = ResourceLocation.parse((String)"minecraft:village/plains/streets");
        ResourceLocation desertStreetsPoolLocation = ResourceLocation.parse((String)"minecraft:village/desert/streets");
        ResourceLocation savannaStreetsPoolLocation = ResourceLocation.parse((String)"minecraft:village/savanna/streets");
        ResourceLocation snowyStreetsPoolLocation = ResourceLocation.parse((String)"minecraft:village/snowy/streets");
        ResourceLocation taigaStreetsPoolLocation = ResourceLocation.parse((String)"minecraft:village/taiga/streets");
        Intrinsics.checkNotNull((Object)plainsStreetsPoolLocation);
        ResourceKey resourceKey = ProcessorLists.STREET_PLAINS;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"STREET_PLAINS");
        this.addLegacyBuildingToPool(templatePoolRegistry, processorListRegistry, plainsStreetsPoolLocation, CobblemonStructureIDs.PLAINS_LONG_PATH, 10, StructureTemplatePool.Projection.TERRAIN_MATCHING, (ResourceKey<StructureProcessorList>)resourceKey);
        Intrinsics.checkNotNull((Object)desertStreetsPoolLocation);
        ResourceKey<StructureProcessorList> resourceKey2 = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey2, (String)"EMPTY_PROCESSOR_LIST_KEY");
        this.addLegacyBuildingToPool(templatePoolRegistry, processorListRegistry, desertStreetsPoolLocation, CobblemonStructureIDs.DESERT_LONG_PATH, 10, StructureTemplatePool.Projection.TERRAIN_MATCHING, resourceKey2);
        Intrinsics.checkNotNull((Object)savannaStreetsPoolLocation);
        ResourceKey resourceKey3 = ProcessorLists.STREET_SAVANNA;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey3, (String)"STREET_SAVANNA");
        this.addLegacyBuildingToPool(templatePoolRegistry, processorListRegistry, savannaStreetsPoolLocation, CobblemonStructureIDs.SAVANNA_LONG_PATH, 10, StructureTemplatePool.Projection.TERRAIN_MATCHING, (ResourceKey<StructureProcessorList>)resourceKey3);
        Intrinsics.checkNotNull((Object)snowyStreetsPoolLocation);
        ResourceKey resourceKey4 = ProcessorLists.STREET_SNOWY_OR_TAIGA;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey4, (String)"STREET_SNOWY_OR_TAIGA");
        this.addLegacyBuildingToPool(templatePoolRegistry, processorListRegistry, snowyStreetsPoolLocation, CobblemonStructureIDs.SNOWY_LONG_PATH, 10, StructureTemplatePool.Projection.TERRAIN_MATCHING, (ResourceKey<StructureProcessorList>)resourceKey4);
        Intrinsics.checkNotNull((Object)taigaStreetsPoolLocation);
        ResourceKey resourceKey5 = ProcessorLists.STREET_SNOWY_OR_TAIGA;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey5, (String)"STREET_SNOWY_OR_TAIGA");
        this.addLegacyBuildingToPool(templatePoolRegistry, processorListRegistry, taigaStreetsPoolLocation, CobblemonStructureIDs.TAIGA_LONG_PATH, 10, StructureTemplatePool.Projection.TERRAIN_MATCHING, (ResourceKey<StructureProcessorList>)resourceKey5);
    }

    public final void addLegacyBuildingToPool(@NotNull Registry<StructureTemplatePool> templatePoolRegistry, @NotNull Registry<StructureProcessorList> processorListRegistry, @NotNull ResourceLocation poolRL, @NotNull ResourceLocation nbtPieceRL, int weight, @NotNull StructureTemplatePool.Projection projection, @NotNull ResourceKey<StructureProcessorList> processorListKey) {
        Intrinsics.checkNotNullParameter(templatePoolRegistry, (String)"templatePoolRegistry");
        Intrinsics.checkNotNullParameter(processorListRegistry, (String)"processorListRegistry");
        Intrinsics.checkNotNullParameter((Object)poolRL, (String)"poolRL");
        Intrinsics.checkNotNullParameter((Object)nbtPieceRL, (String)"nbtPieceRL");
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        Intrinsics.checkNotNullParameter(processorListKey, (String)"processorListKey");
        this.addBuildingToPool(templatePoolRegistry, processorListRegistry, poolRL, nbtPieceRL, weight, projection, processorListKey, true);
    }

    @JvmOverloads
    public final void addBuildingToPool(@NotNull Registry<StructureTemplatePool> templatePoolRegistry, @NotNull Registry<StructureProcessorList> processorListRegistry, @NotNull ResourceLocation poolRL, @NotNull ResourceLocation nbtPieceRL, int weight, @NotNull StructureTemplatePool.Projection projection, @NotNull ResourceKey<StructureProcessorList> processorListKey, boolean shouldUseLegacySingePoolElement) {
        Intrinsics.checkNotNullParameter(templatePoolRegistry, (String)"templatePoolRegistry");
        Intrinsics.checkNotNullParameter(processorListRegistry, (String)"processorListRegistry");
        Intrinsics.checkNotNullParameter((Object)poolRL, (String)"poolRL");
        Intrinsics.checkNotNullParameter((Object)nbtPieceRL, (String)"nbtPieceRL");
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        Intrinsics.checkNotNullParameter(processorListKey, (String)"processorListKey");
        if (processorListRegistry.getHolder(processorListKey).isEmpty()) {
            return;
        }
        Object t = processorListRegistry.getHolder(processorListKey).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        Holder.Reference processorList = (Holder.Reference)t;
        Object object = templatePoolRegistry.get(poolRL);
        StructurePoolAccessor structurePoolAccessor = object instanceof StructurePoolAccessor ? (StructurePoolAccessor)object : null;
        if (structurePoolAccessor == null) {
            return;
        }
        StructurePoolAccessor pool = structurePoolAccessor;
        SinglePoolElement piece = shouldUseLegacySingePoolElement ? (SinglePoolElement)LegacySinglePoolElement.single((String)nbtPieceRL.toString(), (Holder)((Holder)processorList)).apply(projection) : (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL.toString(), (Holder)((Holder)processorList)).apply(projection);
        int n = 0;
        while (n < weight) {
            int it = n++;
            boolean bl = false;
            pool.getElements().add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>((Collection)pool.getElementCounts());
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.getElements().add((Object)piece);
        pool.setElementCounts((List<Pair<StructurePoolElement, Integer>>)listOfPieceEntries);
    }

    public static /* synthetic */ void addBuildingToPool$default(CobblemonStructures cobblemonStructures, Registry registry, Registry registry2, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, int n, StructureTemplatePool.Projection projection, ResourceKey resourceKey, boolean bl, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        cobblemonStructures.addBuildingToPool((Registry<StructureTemplatePool>)registry, (Registry<StructureProcessorList>)registry2, resourceLocation, resourceLocation2, n, projection, (ResourceKey<StructureProcessorList>)resourceKey, bl);
    }

    @JvmOverloads
    public final void addBuildingToPool(@NotNull Registry<StructureTemplatePool> templatePoolRegistry, @NotNull Registry<StructureProcessorList> processorListRegistry, @NotNull ResourceLocation poolRL, @NotNull ResourceLocation nbtPieceRL, int weight, @NotNull StructureTemplatePool.Projection projection, @NotNull ResourceKey<StructureProcessorList> processorListKey) {
        Intrinsics.checkNotNullParameter(templatePoolRegistry, (String)"templatePoolRegistry");
        Intrinsics.checkNotNullParameter(processorListRegistry, (String)"processorListRegistry");
        Intrinsics.checkNotNullParameter((Object)poolRL, (String)"poolRL");
        Intrinsics.checkNotNullParameter((Object)nbtPieceRL, (String)"nbtPieceRL");
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        Intrinsics.checkNotNullParameter(processorListKey, (String)"processorListKey");
        CobblemonStructures.addBuildingToPool$default(this, templatePoolRegistry, processorListRegistry, poolRL, nbtPieceRL, weight, projection, processorListKey, false, 128, null);
    }
}

