/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.world.feature;

import com.cobblemon.mod.common.api.berry.Berry;
import com.cobblemon.mod.common.api.berry.BerryHelper;
import com.cobblemon.mod.common.api.berry.spawncondition.BerrySpawnCondition;
import com.cobblemon.mod.common.api.tags.CobblemonBlockTags;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.util.CollectionUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/world/feature/BerryGroveFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Lnet/minecraft/world/level/levelgen/feature/configurations/NoneFeatureConfiguration;", "<init>", "()V", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "context", "", "place", "(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z", "common"})
@SourceDebugExtension(value={"SMAP\nBerryGroveFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BerryGroveFeature.kt\ncom/cobblemon/mod/common/world/feature/BerryGroveFeature\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class BerryGroveFeature
extends Feature<NoneFeatureConfiguration> {
    public BerryGroveFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    /*
     * WARNING - void declaration
     */
    public boolean place(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int numTreesToGen;
        int n;
        boolean isGenerating;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        WorldGenLevel worldGenLevel = context.level();
        Intrinsics.checkNotNullExpressionValue((Object)worldGenLevel, (String)"level(...)");
        WorldGenLevel worldGenLevel2 = worldGenLevel;
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        boolean bl = isGenerating = !Intrinsics.areEqual((Object)worldGenLevel2.getChunk(origin).getPersistedStatus(), (Object)ChunkStatus.FULL);
        if (!isGenerating) {
            return false;
        }
        Holder biome = worldGenLevel2.getBiome(origin);
        Intrinsics.checkNotNull((Object)biome);
        List<BerryBlock> validTrees = BerryHelper.INSTANCE.getBerriesForBiome((Holder<Biome>)biome);
        if (validTrees.isEmpty()) {
            return false;
        }
        Object object = CollectionUtilsKt.weightedSelection$default(validTrees, null, BerryGroveFeature::place$lambda$0, 1, null);
        Intrinsics.checkNotNull((Object)object);
        BerryBlock pickedTree = (BerryBlock)object;
        Berry berry = pickedTree.berry();
        Intrinsics.checkNotNull((Object)berry);
        Berry berry2 = berry;
        Object object2 = pickedTree.berry();
        if (object2 != null && (object2 = ((Berry)object2).getSpawnConditions()) != null) {
            Iterable iterable = (Iterable)object2;
            int n2 = 0;
            for (Object t : iterable) {
                void cond;
                BerrySpawnCondition berrySpawnCondition = (BerrySpawnCondition)t;
                int n3 = n2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)random);
                Integer n4 = cond.getGroveSize(random);
                int it = ((Number)n4).intValue();
                boolean bl3 = false;
                Integer n5 = cond.canSpawn(berry2, (Holder<Biome>)biome) ? n4 : null;
                int n6 = n5 != null ? n5 : 0;
                n2 = n3 + n6;
            }
            n = n2;
        } else {
            n = 0;
        }
        int numTreesLeftToGen = numTreesToGen = n;
        SimpleStateProvider defTreeState = BlockStateProvider.simple((BlockState)((BlockState)pickedTree.defaultBlockState().setValue((Property)BerryBlock.Companion.getWAS_GENERATED(), (Comparable)Boolean.valueOf(true))));
        RandomizedIntStateProvider randomTreeStateProvider = new RandomizedIntStateProvider((BlockStateProvider)defTreeState, BerryBlock.Companion.getAGE(), (IntProvider)ClampedNormalInt.of((float)4.0f, (float)1.0f, (int)3, (int)5));
        PlacementModifier[] placementModifierArray = new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag(CobblemonBlockTags.BERRY_REPLACEABLE)), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new Vec3i(0, -1, 0), CobblemonBlockTags.BERRY_WILD_SOIL))};
        PlacedFeature blockPlaceFeature = (PlacedFeature)PlacementUtils.inlinePlaced((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)((FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)randomTreeStateProvider)), (PlacementModifier[])placementModifierArray).value();
        BlockPos[] blockPosArray = new BlockPos[]{origin.north(), origin.north().east(), origin.east(), origin.south().east(), origin.south(), origin.south().west(), origin.west(), origin.north().west(), origin.above().north(), origin.above().north().east(), origin.above().east(), origin.above().south().east(), origin.above().south(), origin.above().south().west(), origin.above().west(), origin.above().north().west(), origin.below().north(), origin.below().north().east(), origin.below().east(), origin.below().south().east(), origin.below().south(), origin.below().south().west(), origin.below().west(), origin.below().north().west()};
        List possiblePositions = CollectionsKt.shuffled((Iterable)CollectionsKt.listOf((Object[])blockPosArray));
        for (BlockPos dir : possiblePositions) {
            if (numTreesLeftToGen <= 0) continue;
            PlacedFeature placedFeature = blockPlaceFeature;
            boolean bl4 = placedFeature != null ? placedFeature.place(worldGenLevel2, context.chunkGenerator(), random, dir) : false;
            if (!bl4) continue;
            worldGenLevel2.blockUpdated(dir, worldGenLevel2.getBlockState(dir).getBlock());
            --numTreesLeftToGen;
            BlockState below = worldGenLevel2.getBlockState(dir.below());
            if (below.is(Blocks.GRASS_BLOCK) && ((Boolean)below.getValue((Property)GrassBlock.SNOWY)).booleanValue()) {
                worldGenLevel2.setBlock(dir.below(), (BlockState)below.setValue((Property)GrassBlock.SNOWY, (Comparable)Boolean.valueOf(false)), 2);
            }
            worldGenLevel2.setBlock(dir.above(), Blocks.AIR.defaultBlockState(), 2);
        }
        return numTreesToGen != numTreesLeftToGen;
    }

    private static final Number place$lambda$0(BerryBlock it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Berry berry = it.berry();
        Intrinsics.checkNotNull((Object)berry);
        return Float.valueOf(berry.getWeight());
    }
}

