/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.regex.runtime.nodes;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.GenerateUncached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.InteropLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.UnsupportedMessageException;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.UnsupportedTypeException;
import com.cobblemon.mod.relocations.oracle.truffle.api.library.CachedLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.regex.runtime.nodes.ExpectStringOrTruffleObjectNodeGen;

@GenerateUncached
public abstract class ExpectStringOrTruffleObjectNode
extends Node {
    public abstract Object execute(Object var1) throws UnsupportedTypeException;

    @Specialization
    static String doString(String input) {
        return input;
    }

    @Specialization
    static TruffleString doTString(TruffleString input) {
        return input;
    }

    @Specialization(guards={"inputs.isString(input)"}, limit="2")
    static String doBoxedString(Object input, @CachedLibrary(value="input") InteropLibrary inputs) throws UnsupportedTypeException {
        try {
            return inputs.asString(input);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedTypeException.create(new Object[]{input});
        }
    }

    @Specialization(guards={"inputs.hasArrayElements(input)"}, limit="2")
    static Object doBoxedCharArray(Object input, @CachedLibrary(value="input") InteropLibrary inputs) throws UnsupportedTypeException {
        try {
            long inputLength = inputs.getArraySize(input);
            if (inputLength > Integer.MAX_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedTypeException.create(new Object[]{input});
            }
            return input;
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedTypeException.create(new Object[]{input});
        }
    }

    public static ExpectStringOrTruffleObjectNode create() {
        return ExpectStringOrTruffleObjectNodeGen.create();
    }
}

