/*
 * Decompiled with CFR 0.152.
 */
package page.codeberg.cubicfloof.compost_bin.world.level.block.entity;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3708;
import net.minecraft.class_3913;
import net.minecraft.class_3962;
import net.minecraft.class_5561;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import page.codeberg.cubicfloof.compost_bin.CompostBin;
import page.codeberg.cubicfloof.compost_bin.world.inventory.CompostBinMenu;

public class CompostBinBlockEntity
extends class_2624
implements class_1278 {
    public static final int SLOT_COUNT = 10;
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 world, class_2338 pos, class_2680 state) {
            CompostBinBlockEntity.this.playSound(CompostBin.COMPOST_BIN_SOUND_EVENT_OPEN);
            CompostBinBlockEntity.this.updateBlockState(state, true);
        }

        protected void method_31683(class_1937 world, class_2338 pos, class_2680 state) {
            CompostBinBlockEntity.this.playSound(CompostBin.COMPOST_BIN_SOUND_EVENT_CLOSE);
            CompostBinBlockEntity.this.updateBlockState(state, false);
        }

        protected void method_31682(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
            CompostBinBlockEntity.this.signalOpenCount(world, pos, state, newViewerCount);
        }

        protected boolean method_31679(class_1657 player) {
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof CompostBinMenu) {
                CompostBinMenu compostBinMenu = (CompostBinMenu)class_17032;
                return compostBinMenu.getContainer() == CompostBinBlockEntity.this;
            }
            return false;
        }
    };
    private byte fillLevel = 0;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            if (index != 0) {
                return 0;
            }
            return CompostBinBlockEntity.this.fillLevel;
        }

        public void method_17391(int index, int value) {
            if (index != 0) {
                return;
            }
            assert (value > 127);
            CompostBinBlockEntity.this.fillLevel = (byte)value;
        }

        public int method_17389() {
            return 1;
        }
    };
    private byte tickCount = 0;
    private class_2371<class_1799> items = class_2371.method_10213((int)10, (Object)class_1799.field_8037);

    public CompostBinBlockEntity(class_2338 pos, class_2680 state) {
        this(CompostBin.COMPOST_BIN_BLOCK_ENTITY, pos, state);
    }

    protected CompostBinBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    public static void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState, CompostBinBlockEntity blockEntity) {
        if (!blockEntity.advanceCooldown()) {
            return;
        }
        class_1799 outputSlot = (class_1799)blockEntity.items.get(9);
        if (outputSlot.method_7909().method_7882() <= outputSlot.method_7947()) {
            return;
        }
        boolean doesCompost = blockEntity.compost();
        if (doesCompost) {
            return;
        }
        boolean doesFill = blockEntity.consumeCompostable(world);
        world.method_45446(blockPos, doesFill ? class_3417.field_17608 : class_3417.field_17607, class_3419.field_15245, 1.0f, 1.0f, false);
        double y = blockState.method_26218((class_1922)world, blockPos).method_1102(class_2350.class_2351.field_11052, 0.5, 0.5) + 0.03125;
        if (doesFill) {
            blockEntity.fill();
        }
        class_5819 randomSource = world.method_8409();
        for (int i = 0; i < 10; ++i) {
            world.method_8406((class_2394)class_2398.field_17741, (double)((float)blockPos.method_10263() + 0.13125f) + (double)0.7375f * (double)randomSource.method_43057(), (double)blockPos.method_10264() + y + (double)randomSource.method_43057() * (1.0 - y), (double)((float)blockPos.method_10260() + 0.13125f) + (double)0.7375f * (double)randomSource.method_43057(), randomSource.method_43059() * 0.02, randomSource.method_43059() * 0.02, randomSource.method_43059() * 0.02);
        }
    }

    private boolean advanceCooldown() {
        this.tickCount = (byte)(this.tickCount + 1);
        if (this.tickCount >= 8) {
            this.tickCount = 0;
            return true;
        }
        return false;
    }

    public boolean compost() {
        if (this.fillLevel < 8) {
            return false;
        }
        this.fillLevel = 0;
        class_1799 outputSlot = (class_1799)this.items.get(9);
        if (outputSlot.method_7960()) {
            this.items.set(9, (Object)new class_1799((class_1935)class_1802.field_8324));
        } else {
            outputSlot.method_7933(1);
        }
        this.method_5431();
        return true;
    }

    public boolean consumeCompostable(class_1937 level) {
        List inputSlots = this.items.subList(0, 9);
        List<class_1799> stacks = inputSlots.stream().filter(stack -> !stack.method_7960()).toList();
        if (stacks.isEmpty()) {
            return false;
        }
        Optional<class_1799> smallestStack = stacks.stream().min(Comparator.comparingInt(class_1799::method_7947));
        class_1799 stack2 = smallestStack.get();
        if (!class_3962.field_17566.containsKey((Object)stack2.method_7909())) {
            return false;
        }
        float compostChance = class_3962.field_17566.getFloat((Object)stack2.method_7909());
        stack2.method_7934(1);
        return this.fillLevel == 0 && !(compostChance <= 0.0f) || !(level.method_8409().method_43058() >= (double)compostChance);
    }

    public void fill() {
        if (this.fillLevel != 8) {
            this.fillLevel = (byte)(this.fillLevel + 1);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 lookupProvider) {
        super.method_11014(nbt, lookupProvider);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)lookupProvider);
        this.fillLevel = nbt.method_10571("Level");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookupProvider) {
        super.method_11007(nbt, lookupProvider);
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)lookupProvider);
        nbt.method_10567("Level", this.fillLevel);
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.compost_bin");
    }

    @NotNull
    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.items = stacks;
    }

    @NotNull
    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new CompostBinMenu(syncId, playerInventory, (class_1263)this, this.dataAccess);
    }

    public int method_5439() {
        return 10;
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.method_31684(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.method_31685(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    void updateBlockState(class_2680 state, boolean open) {
        assert (this.field_11863 != null);
        this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)class_3708.field_18006, (Comparable)Boolean.valueOf(open)), 3);
    }

    void playSound(class_3414 soundEvent) {
        double d = (double)this.field_11867.method_10263() + 0.5;
        double e = (double)this.field_11867.method_10264() + 0.5;
        double f = (double)this.field_11867.method_10260() + 0.5;
        assert (this.field_11863 != null);
        this.field_11863.method_43128(null, d, e, f, soundEvent, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public void recheckOpen() {
        if (this.field_11865) {
            return;
        }
        this.openersCounter.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
    }

    protected void signalOpenCount(class_1937 world, class_2338 pos, class_2680 state, int newViewerCount) {
        class_2248 block = state.method_26204();
        world.method_8427(pos, block, 1, newViewerCount);
    }

    public int @NotNull [] method_5494(class_2350 side) {
        int[] nArray;
        switch (side) {
            default: {
                throw new MatchException(null, null);
            }
            case field_11036: 
            case field_11043: 
            case field_11035: 
            case field_11039: 
            case field_11034: {
                int[] nArray2 = new int[9];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray2[4] = 4;
                nArray2[5] = 5;
                nArray2[6] = 6;
                nArray2[7] = 7;
                nArray = nArray2;
                nArray2[8] = 8;
                break;
            }
            case field_11033: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 9;
            }
        }
        return nArray;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return class_3962.field_17566.containsKey((Object)stack.method_7909());
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return stack.method_7909() == class_1802.field_8324;
    }
}

