/*
 * Decompiled with CFR 0.152.
 */
package net.sixunderscore.mendingfix.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.sixunderscore.mendingfix.MendingFix;

public class Config {
    private static final Path configFile = FabricLoader.getInstance().getConfigDir().resolve("enchantmentcost.conf");
    public static final Map<String, Integer> enchantmentToCostMap = new HashMap<String, Integer>();

    public static void loadConfig() {
        try {
            if (Files.notExists(configFile, new LinkOption[0])) {
                MendingFix.LOGGER.info("Creating and initializing new config file");
                Config.initNewFileWithDefaultValues();
            }
            Config.loadFile();
        }
        catch (IOException e) {
            MendingFix.LOGGER.error("Exception creating or loading config file, cause: {}\nMessage: {}", (Object)e.getCause(), (Object)e.getMessage());
        }
    }

    private static void initNewFileWithDefaultValues() throws IOException {
        String defaultFileContents = "minecraft:mending=12\nminecraft:protection=8\nminecraft:fire_protection=8\nminecraft:blast_protection=8\nminecraft:projectile_protection=8\nminecraft:breach=8\nminecraft:impaling=6\nminecraft:sharpness=6\nminecraft:bane_of_arthropods=6\nminecraft:smite=6\nminecraft:density=6\nminecraft:power=6\nminecraft:quick_charge=6\nminecraft:efficiency=6\nminecraft:infinity=4\nminecraft:multi_shot=4\nminecraft:channelling=4\nminecraft:silk_touch=3\nminecraft:loyalty=3\nminecraft:riptide=3\nminecraft:unbreaking=3\nminecraft:swift_sneak=3\nminecraft:fortune=3\nminecraft:flame=3\nminecraft:lure=3\nminecraft:luck_of_the_sea=3\nminecraft:piercing=2\nminecraft:respiration=2\nminecraft:depth_strider=2\nminecraft:frost_walker=2\nminecraft:feather_falling=2\nminecraft:soul_speed=2\nminecraft:aqua_affinity=2\nminecraft:fire_aspect=2\nminecraft:sweeping_edge=2\nminecraft:punch=2\nminecraft:knockback=1\nminecraft:thorns=1\nminecraft:binding_curse=-4\nminecraft:vanishing_curse=-4\n";
        Files.createFile(configFile, new FileAttribute[0]);
        Files.writeString(configFile, (CharSequence)defaultFileContents, new OpenOption[0]);
    }

    private static void loadFile() throws IOException {
        List<String> lines = Files.readAllLines(configFile);
        for (String line : lines) {
            if (line.startsWith("#") || line.startsWith("//") || !line.contains("=")) continue;
            String[] keyValue = line.split("=", 2);
            try {
                enchantmentToCostMap.put(keyValue[0], Integer.parseInt(keyValue[1]));
            }
            catch (NumberFormatException e) {
                MendingFix.LOGGER.error("Invalid value for key {} in config file", (Object)keyValue[0]);
            }
        }
    }
}

