/*
 * Decompiled with CFR 0.152.
 */
package net.sixunderscore.mendingfixclient.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class Utils {
    public static Map<String, Integer> enchantmentToCostMap = new HashMap<String, Integer>();

    public static int calculateBookCombiningCost(class_1799 book) {
        class_9304 bookEnchantmentsComponent = (class_9304)book.method_57353().method_58695(class_9334.field_49643, (Object)class_9304.field_49385);
        Set bookEnchantments = bookEnchantmentsComponent.method_57534();
        int cost = 0;
        for (class_6880 bookEnchantment : bookEnchantments) {
            cost += enchantmentToCostMap.getOrDefault(bookEnchantment.method_55840(), 0) * bookEnchantmentsComponent.method_57536(bookEnchantment);
        }
        return Math.max(cost, 1);
    }

    public static int calculateItemCombiningCost(class_1799 stack) {
        class_9304 stackEnchantmentsComponent = stack.method_58657();
        Set stackEnchantments = stackEnchantmentsComponent.method_57534();
        int cost = 0;
        for (class_6880 stackEnchantment : stackEnchantments) {
            cost += enchantmentToCostMap.getOrDefault(stackEnchantment.method_55840(), 0) * stackEnchantmentsComponent.method_57536(stackEnchantment);
        }
        return Math.max(cost, 1);
    }

    public static String calculateItemRepairCostMessage(class_1799 stack) {
        int repairCost = (Integer)stack.method_58695(class_9334.field_49639, (Object)0) + 1;
        return switch (Utils.getMendingLevel(stack)) {
            case 0 -> repairCost + " / 64";
            case 1 -> Math.min(repairCost, 32) + " / 32 \u221e";
            default -> Math.min(repairCost, 16) + " / 16 \u221e";
        };
    }

    private static int getMendingLevel(class_1799 stack) {
        class_9304 stackEnchantmentsComponent = stack.method_58657();
        Set enchantments = stack.method_58657().method_57534();
        if (!enchantments.isEmpty()) {
            for (class_6880 enchantment : enchantments) {
                if (!enchantment.method_40224(class_1893.field_9101::equals)) continue;
                return stackEnchantmentsComponent.method_57536(enchantment);
            }
        }
        return 0;
    }
}

