/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.unlocked_typing.mixin.client;

import common.com.cursee.unlocked_typing.api.client.BookEditScreenAccessor;
import common.com.cursee.unlocked_typing.api.client.DisplayCacheAccessor;
import common.com.cursee.unlocked_typing.api.client.LineInfoAccessor;
import common.com.cursee.unlocked_typing.api.client.ScreenAccessor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookEditScreen.class})
public abstract class BookEditScreenMixin {
    @Shadow
    @Nullable
    private BookEditScreen.DisplayCache displayCache;
    @Shadow
    private boolean isSigning;
    @Shadow
    private Component pageMsg;
    @Shadow
    private int frameTick;
    @Shadow
    private String title;
    @Unique
    private static final int UNLOCKED_TYPING$OFFSET = 140;

    @Shadow
    protected abstract BookEditScreen.DisplayCache getDisplayCache();

    @Inject(at={@At(value="TAIL")}, method={"render"})
    private void unlocked_typing$render$renderPreformattedText(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.isSigning) {
            this.unlocked_typing$renderBookSigningDisplay(guiGraphics);
        } else {
            this.unlocked_typing$renderBookWritingDisplay(guiGraphics);
        }
    }

    @Unique
    private void unlocked_typing$renderBookSigningDisplay(GuiGraphics guiGraphics) {
        BookEditScreen screen = (BookEditScreen)this;
        ScreenAccessor screenAccessor = (ScreenAccessor)screen;
        int i = (screenAccessor.unlocked_typing$getWidth() - 192) / 2;
        FormattedCharSequence formattedCharSequence = FormattedCharSequence.forward((String)this.title, (Style)Style.EMPTY);
        int l = screenAccessor.unlocked_typing$getFont().width(formattedCharSequence);
        String helperRawText = Component.translatable((String)"unlocked_typing.preformattedTextTitle").getString();
        guiGraphics.drawString(screenAccessor.unlocked_typing$getFont(), FormattedCharSequence.forward((String)helperRawText, (Style)Style.EMPTY.withUnderlined(Boolean.valueOf(true))), i + 36 + 12 + 140, 39, DyeColor.LIGHT_GRAY.getTextColor(), false);
        guiGraphics.drawString(screenAccessor.unlocked_typing$getFont(), formattedCharSequence, i + 36 + 12 + 140, 50, DyeColor.LIGHT_GRAY.getTextColor(), false);
        MutableComponent renderedTextComponent = Component.literal((String)this.title);
        guiGraphics.drawString(screenAccessor.unlocked_typing$getFont(), (Component)renderedTextComponent, i + 36 + 12 + 140, 68, -1, false);
    }

    @Unique
    private void unlocked_typing$renderBookWritingDisplay(GuiGraphics guiGraphics) {
        BookEditScreen screen = (BookEditScreen)this;
        ScreenAccessor screenAccessor = (ScreenAccessor)screen;
        BookEditScreenAccessor bookEditScreenAccessor = (BookEditScreenAccessor)screen;
        DisplayCacheAccessor displayCacheAccessor = (DisplayCacheAccessor)bookEditScreenAccessor.unlocked_typing$getDisplayCache();
        int i = (screenAccessor.unlocked_typing$getWidth() - 192) / 2;
        int n = screenAccessor.unlocked_typing$getFont().width((FormattedText)this.pageMsg);
        String helperRawText = Component.translatable((String)"unlocked_typing.preformattedTextTitle").getString();
        guiGraphics.drawString(screenAccessor.unlocked_typing$getFont(), FormattedCharSequence.forward((String)helperRawText, (Style)Style.EMPTY.withUnderlined(Boolean.valueOf(true))), i + 192 - 44 + 27, 18, DyeColor.LIGHT_GRAY.getTextColor(), false);
        guiGraphics.drawString(screenAccessor.unlocked_typing$getFont(), this.pageMsg, i - n + 192 - 44, 18, 0, false);
        for (BookEditScreen.LineInfo lineInfo : displayCacheAccessor.unlocked_typing$getLines()) {
            LineInfoAccessor lineInfoAccessor = (LineInfoAccessor)lineInfo;
            Component originalComponent = lineInfoAccessor.unlocked_typing$getAsComponent();
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.forward((String)originalComponent.getString(), (Style)Style.EMPTY);
            guiGraphics.drawString(screenAccessor.unlocked_typing$getFont(), formattedCharSequence, lineInfoAccessor.unlocked_typing$getX() + 140, lineInfoAccessor.unlocked_typing$getY(), DyeColor.LIGHT_GRAY.getTextColor(), false);
        }
    }
}

