/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class VanishConfig {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Config CONFIG;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Config)specPair.getLeft();
    }

    public static class Config {
        public ForgeConfigSpec.BooleanValue hidePlayersFromWorld;
        public ForgeConfigSpec.BooleanValue hidePlayersFromPlayerLists;
        public ForgeConfigSpec.BooleanValue disableCommandTargeting;
        public ForgeConfigSpec.BooleanValue hideChatMessages;
        public ForgeConfigSpec.BooleanValue hidePlayerNameInChat;
        public ForgeConfigSpec.BooleanValue sendFakeJoinLeaveMessages;
        public ForgeConfigSpec.BooleanValue fixPlayerDetectionModCompatibility;
        public ForgeConfigSpec.BooleanValue removeModdedSystemMessageReferences;
        public ForgeConfigSpec.BooleanValue vanishedPlayersSeeEachOther;
        public ForgeConfigSpec.BooleanValue seeVanishedTeamPlayers;
        public ForgeConfigSpec.BooleanValue indirectSoundSuppression;
        public ForgeConfigSpec.BooleanValue indirectParticleSuppression;
        public ForgeConfigSpec.BooleanValue spoofVanishedPlayerInvisibility;
        public ForgeConfigSpec.BooleanValue forceSyncHiddenList;
        public ForgeConfigSpec.IntValue vanishCommandPermissionLevel;
        public ForgeConfigSpec.IntValue seeVanishedPermissionLevel;
        public ForgeConfigSpec.ConfigValue<String> onVanishMessage;
        public ForgeConfigSpec.ConfigValue<String> onUnvanishMessage;
        public ForgeConfigSpec.ConfigValue<String> onVanishQuery;
        public ForgeConfigSpec.ConfigValue<String> onUnvanishQuery;

        Config(ForgeConfigSpec.Builder builder) {
            this.hidePlayersFromWorld = builder.comment(new String[]{" --- Vanishmod Config File --- ", "Should vanished players be physically hidden from the world? This includes sound and particle suppression"}).define("hidePlayersFromWorld", true);
            this.hidePlayersFromPlayerLists = builder.comment("Should vanished players be hidden from player lists such as the /list command and the list in the Multiplayer screen?").define("hidePlayersFromPlayerLists", true);
            this.disableCommandTargeting = builder.comment("Should vanished players not be targetable by other players via command selectors (so players that cannot see vanished players cannot target them with e.g. /msg or /give)?").define("disableCommandTargeting", true);
            this.hideChatMessages = builder.comment("Should chat and /teammsg messages from vanished players be hidden for unvanished players?").define("hideChatMessages", true);
            this.hidePlayerNameInChat = builder.comment("When unvanished players receive a message from a vanished player (e.g. a chat or /msg message), should the name of the player that sent the message be replaced with \"vanished\" (in gray color)?").define("hidePlayerNameInChat", false);
            this.sendFakeJoinLeaveMessages = builder.comment("Should players see a fake join/leave message in their chat when another player (un-)vanishes?").define("sendFakeJoinLeaveMessages", true);
            this.fixPlayerDetectionModCompatibility = builder.comment("Should there be a (potential) fix for other mods uncovering the presence of vanished players? This may severely increase CPU usage and is thus not recommended").define("fixPlayerDetectionModCompatibility", false);
            this.removeModdedSystemMessageReferences = builder.comment("Should this mod unconditionally and strictly remove (mostly) all references of names of vanished players by system messages added by mods? This is experimental, disable the config if too many modded messages get removed. Vanilla messages mentioning vanished players, such as death and advancement messages, will be removed regardless of this config's state.").define("removeModdedSystemMessageReferences", true);
            this.vanishedPlayersSeeEachOther = builder.comment("Should vanished players be able to see each other?").define("vanishedPlayersSeeEachOther", false);
            this.seeVanishedTeamPlayers = builder.comment("Should players be able to see vanished players in the same vanilla team, if the \"seeFriendlyInvisibles\" option is enabled for that team?").define("seeVanishedTeamPlayers", false);
            this.indirectSoundSuppression = builder.comment("Should this mod try to detect and suppress sounds that are indirectly caused by vanished players (e.g. pressing a button or hitting an entity)? This detection might accidentally suppress a few sounds unrelated to vanished players, disable this detection if too many sound bugs occur").define("indirectSoundSuppression", true);
            this.indirectParticleSuppression = builder.comment("Should this mod try to detect and suppress particles that are indirectly caused by vanished players (e.g. eating or block breaking particles)? This detection might accidentally suppress particles unrelated to vanished players, disable this detection if too many visual bugs occur").define("indirectParticleSuppression", true);
            this.spoofVanishedPlayerInvisibility = builder.comment("Should vanished players be regarded as having the Invisibility status effect on the server side? This does not actually affect if the player is rendered or not, but it may allow vanished players to hide from certain serverside map tools like Dynmap.").define("spoofVanishedPlayerInvisibility", true);
            this.forceSyncHiddenList = builder.comment("Should the \"Hidden Players\" list from mc2discord be constantly synched with a player's vanished status? (This might lead to worse performance)").define("forceSyncHiddenList", false);
            this.vanishCommandPermissionLevel = builder.comment("What op permission level should be the requirement for being able to execute /vanish? (A value of 2 or lower allows command blocks to execute /vanish)").defineInRange("vanishCommandPermissionLevel", 2, 0, 4);
            this.seeVanishedPermissionLevel = builder.comment("What op permission level should be the requirement for being able to see vanished players, no matter if the player with that permission level is vanished or not? A value of -1 disables this feature.").defineInRange("seeVanishedPermissionLevel", -1, -1, 4);
            this.onVanishMessage = builder.comment("What message should a player receive when they vanish? (%s will get replaced with the name of the vanishing player)").define("onVanishMessage", (Object)"%s vanished");
            this.onUnvanishMessage = builder.comment("What message should a player receive when they unvanish? (%s will get replaced with the name of the unvanishing player)").define("onUnvanishMessage", (Object)"%s unvanished");
            this.onVanishQuery = builder.comment("What message should a player receive if they query the vanished status of a vanished player? (%s will get replaced with the name of the player that the status is queried of)").define("onVanishQuery", (Object)"%s is currently vanished.");
            this.onUnvanishQuery = builder.comment("What message should a player receive if they query the vanished status of a visible player? (%s will get replaced with the name of the player that the status is queried of)").define("onUnvanishQuery", (Object)"%s is currently not vanished.");
        }
    }
}

