/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.misc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;

public class SoundSuppressionHelper {
    private static final Map<UUID, Pair<BlockPos, UUID>> vanishedPlayersAndHitResults = new HashMap<UUID, Pair<BlockPos, UUID>>();
    private static Pair<Packet<?>, UUID> packetOrigin = null;

    public static boolean shouldCapturePlayers() {
        return (Boolean)VanishConfig.CONFIG.indirectSoundSuppression.get() != false || (Boolean)VanishConfig.CONFIG.indirectParticleSuppression.get() != false;
    }

    public static void updateVanishedPlayerMap(ServerPlayer player, boolean vanished) {
        UUID uuid = player.m_20148_();
        if (vanished) {
            vanishedPlayersAndHitResults.put(uuid, null);
        } else {
            vanishedPlayersAndHitResults.remove(uuid);
        }
        new HashSet<UUID>(vanishedPlayersAndHitResults.keySet()).stream().filter(loopUuid -> player.f_8924_.m_6846_().m_11259_(loopUuid) == null).forEach(vanishedPlayersAndHitResults::remove);
    }

    public static void updateBlockHitResult(ServerPlayer player, BlockHitResult hitResult) {
        if (VanishUtil.isVanished((Player)player)) {
            UUID uuid;
            Pair<BlockPos, UUID> oldHitResults = vanishedPlayersAndHitResults.get(uuid = player.m_20148_());
            vanishedPlayersAndHitResults.put(uuid, (Pair<BlockPos, UUID>)(oldHitResults == null ? Pair.of((Object)hitResult.m_82425_(), null) : Pair.of((Object)hitResult.m_82425_(), (Object)((UUID)oldHitResults.getRight()))));
        }
    }

    public static void updateEntityHitResult(ServerPlayer player, Entity hitEntity) {
        if (VanishUtil.isVanished((Player)player)) {
            vanishedPlayersAndHitResults.put(player.m_20148_(), (Pair<BlockPos, UUID>)Pair.of((Object)hitEntity.m_20183_(), (Object)hitEntity.m_20148_()));
        }
    }

    public static void invalidateHitResults(ServerPlayer player) {
        if (VanishUtil.isVanished((Player)player)) {
            vanishedPlayersAndHitResults.put(player.m_20148_(), null);
        }
    }

    public static void putSoundPacket(Packet<?> packet, Player player) {
        packetOrigin = Pair.of(packet, (Object)player.m_20148_());
    }

    public static Player getPlayerForPacket(Packet<?> packet, PlayerList list) {
        return packetOrigin != null && ((Packet)packetOrigin.getLeft()).equals(packet) ? list.m_11259_((UUID)packetOrigin.getRight()) : null;
    }

    public static Player getIndirectVanishedSoundCause(Player player, Level level, double x, double y, double z, ServerPlayer forPlayer) {
        return SoundSuppressionHelper.getIndirectVanishedSoundCause(player, level, new Vec3(x, y, z), forPlayer);
    }

    public static Player getIndirectVanishedSoundCause(Player player, Level level, Vec3 soundOrigin, ServerPlayer forPlayer) {
        if (player != null) {
            return VanishUtil.isVanished(player, (Entity)forPlayer) ? player : null;
        }
        if (!((Boolean)VanishConfig.CONFIG.indirectSoundSuppression.get()).booleanValue()) {
            return null;
        }
        Player vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerInteractedWith(level, soundOrigin, forPlayer);
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerAt(level, soundOrigin, forPlayer);
        }
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedProjectileOwnerAt(level, soundOrigin, forPlayer);
        }
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerWithVehicleAt(level, soundOrigin, forPlayer);
        }
        return vanishedSoundCause;
    }

    public static Player getIndirectVanishedSoundCause(Player player, Level level, Entity soundOrigin, ServerPlayer forPlayer) {
        if (player != null) {
            return VanishUtil.isVanished(player, (Entity)forPlayer) ? player : null;
        }
        if (!((Boolean)VanishConfig.CONFIG.indirectSoundSuppression.get()).booleanValue() || soundOrigin == null) {
            return null;
        }
        Player vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerInteractedWith(level, soundOrigin, forPlayer);
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerAt(level, soundOrigin.m_20182_(), forPlayer);
        }
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedProjectileOwner(soundOrigin, forPlayer);
        }
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerInVehicle(soundOrigin, forPlayer);
        }
        return vanishedSoundCause;
    }

    public static Player getIndirectVanishedParticleCause(Player player, Level level, double x, double y, double z, ServerPlayer forPlayer) {
        Vec3 particleOrigin = new Vec3(x, y, z);
        if (player != null) {
            return VanishUtil.isVanished(player, (Entity)forPlayer) ? player : null;
        }
        if (!((Boolean)VanishConfig.CONFIG.indirectParticleSuppression.get()).booleanValue()) {
            return null;
        }
        Player vanishedParticleCause = SoundSuppressionHelper.getVanishedPlayerInteractedWith(level, particleOrigin, forPlayer);
        if (vanishedParticleCause == null) {
            vanishedParticleCause = SoundSuppressionHelper.getVanishedPlayerAt(level, particleOrigin, forPlayer);
        }
        if (vanishedParticleCause == null) {
            vanishedParticleCause = SoundSuppressionHelper.getVanishedProjectileOwnerAt(level, particleOrigin, forPlayer);
        }
        if (vanishedParticleCause == null) {
            vanishedParticleCause = SoundSuppressionHelper.getVanishedPlayerWithVehicleAt(level, particleOrigin, forPlayer);
        }
        return vanishedParticleCause;
    }

    public static Player getVanishedPlayerAt(Level level, Vec3 pos, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.f_8924_.m_6846_();
        VoxelShape shape = Shapes.m_83144_().m_83216_(pos.f_82479_ - 0.5, pos.f_82480_ - 0.5, pos.f_82481_ - 0.5);
        return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).m_11259_(arg_0)).filter(p -> p != null && p.m_9236_().equals(level) && p.f_8941_.m_9290_() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer) && Shapes.m_83157_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)p.m_20191_()), (BooleanOp)BooleanOp.f_82689_)).findFirst().orElse(null);
    }

    public static Player getVanishedProjectileOwnerAt(Level level, Vec3 pos, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.f_8924_.m_6846_();
        AABB soundArea = AABB.m_165882_((Vec3)pos, (double)1.0, (double)1.0, (double)1.0);
        List projectiles = level.m_6249_((Entity)null, soundArea, e -> e instanceof Projectile);
        if (!projectiles.isEmpty()) {
            return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).m_11259_(arg_0)).filter(p -> p != null && p.m_9236_().equals(level) && p.f_8941_.m_9290_() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer) && projectiles.stream().anyMatch(proj -> p.equals((Object)((Projectile)proj).m_19749_()))).findFirst().orElse(null);
        }
        return null;
    }

    public static Player getVanishedProjectileOwner(Entity entity, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.f_8924_.m_6846_();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).m_11259_(arg_0)).filter(p -> p != null && p.f_8941_.m_9290_() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer) && p.equals((Object)projectile.m_19749_())).findFirst().orElse(null);
        }
        return null;
    }

    public static Player getVanishedPlayerWithVehicleAt(Level level, Vec3 pos, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.f_8924_.m_6846_();
        VoxelShape shape = Shapes.m_83144_().m_83216_(pos.f_82479_ - 0.5, pos.f_82480_ - 0.5, pos.f_82481_ - 0.5);
        return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).m_11259_(arg_0)).filter(p -> p != null && p.m_9236_().equals(level) && p.f_8941_.m_9290_() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer)).map(p -> Pair.of((Object)p, (Object)p.m_20202_())).filter(pv -> pv.getRight() != null && Shapes.m_83157_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)((Entity)pv.getRight()).m_20191_()), (BooleanOp)BooleanOp.f_82689_)).findFirst().map(Pair::getLeft).orElse(null);
    }

    public static Player getVanishedPlayerInVehicle(Entity entity, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.f_8924_.m_6846_();
        return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).m_11259_(arg_0)).filter(p -> p != null && p.f_8941_.m_9290_() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer) && entity.equals((Object)p.m_20202_())).findFirst().orElse(null);
    }

    public static Player getVanishedPlayerInteractedWith(Level level, Vec3 pos, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.f_8924_.m_6846_();
        return vanishedPlayersAndHitResults.entrySet().stream().map(e -> Pair.of((Object)list.m_11259_((UUID)e.getKey()), (Object)((Pair)e.getValue()))).filter(p -> p.getKey() != null && ((ServerPlayer)p.getKey()).m_9236_().equals(level) && VanishUtil.isVanished((Player)p.getKey(), (Entity)forPlayer) && p.getValue() != null && SoundSuppressionHelper.equalsThisOrConnected(pos, level, (BlockPos)((Pair)p.getValue()).getLeft())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public static Player getVanishedPlayerInteractedWith(Level level, Entity entity, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.f_8924_.m_6846_();
        return vanishedPlayersAndHitResults.entrySet().stream().map(e -> Pair.of((Object)list.m_11259_((UUID)e.getKey()), (Object)((Pair)e.getValue()))).filter(p -> p.getKey() != null && ((ServerPlayer)p.getKey()).m_9236_().equals(level) && VanishUtil.isVanished((Player)p.getKey(), (Entity)forPlayer) && p.getValue() != null && entity.m_20148_().equals(((Pair)p.getValue()).getRight())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public static boolean equalsThisOrConnected(Vec3 soundPos, Level level, BlockPos interactPos) {
        if (interactPos != null) {
            BlockState state = level.m_8055_(interactPos);
            if (new AABB(interactPos).m_82400_(0.01).m_82390_(soundPos)) {
                return true;
            }
            if (state.m_60734_() instanceof ChestBlock) {
                return new AABB(interactPos.m_121945_(ChestBlock.m_51584_((BlockState)state))).m_82400_(0.01).m_82390_(soundPos);
            }
        }
        return false;
    }
}

