/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.mixin.world;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private LivingEntityMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"canBeSeenByAnyone"}, at={@At(value="HEAD")}, cancellable=true)
    public void vanishmod$onCanBeSeen(CallbackInfoReturnable<Boolean> callbackInfo) {
        if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue() && VanishUtil.isVanished(this)) {
            callbackInfo.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hasEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanishmod$hasInvisibility(MobEffect effect, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (effect == MobEffects.f_19609_ && ((Boolean)VanishConfig.CONFIG.spoofVanishedPlayerInvisibility.get()).booleanValue() && VanishUtil.isVanished(this)) {
            callbackInfo.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanishmod$getInvisibilityEffect(MobEffect effect, CallbackInfoReturnable<MobEffectInstance> callbackInfo) {
        if (effect == MobEffects.f_19609_ && ((Boolean)VanishConfig.CONFIG.spoofVanishedPlayerInvisibility.get()).booleanValue() && VanishUtil.isVanished(this)) {
            callbackInfo.setReturnValue((Object)new MobEffectInstance(MobEffects.f_19609_, 10));
        }
    }

    @Redirect(method={"updateInvisibilityStatus"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z"))
    private boolean vanishmod$correctInvisibilityStatus(LivingEntity entity, MobEffect effect) {
        if (effect == MobEffects.f_19609_ && ((Boolean)VanishConfig.CONFIG.spoofVanishedPlayerInvisibility.get()).booleanValue() && VanishUtil.isVanished((Entity)entity)) {
            return entity.m_21221_().containsKey(MobEffects.f_19609_);
        }
        return entity.m_21023_(effect);
    }
}

