/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.misc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;

public class SoundSuppressionHelper {
    private static final Map<UUID, Pair<BlockPos, UUID>> vanishedPlayersAndHitResults = new HashMap<UUID, Pair<BlockPos, UUID>>();
    private static Pair<Packet<?>, UUID> packetOrigin = null;

    public static boolean shouldCapturePlayers() {
        return (Boolean)VanishConfig.CONFIG.indirectSoundSuppression.get() != false || (Boolean)VanishConfig.CONFIG.indirectParticleSuppression.get() != false;
    }

    public static void updateVanishedPlayerMap(ServerPlayer player, boolean vanished) {
        UUID uuid = player.getUUID();
        if (vanished) {
            vanishedPlayersAndHitResults.put(uuid, null);
        } else {
            vanishedPlayersAndHitResults.remove(uuid);
        }
        new HashSet<UUID>(vanishedPlayersAndHitResults.keySet()).stream().filter(loopUuid -> player.getServer().getPlayerList().getPlayer(loopUuid) == null).forEach(vanishedPlayersAndHitResults::remove);
    }

    public static void updateBlockHitResult(ServerPlayer player, BlockHitResult hitResult) {
        if (VanishUtil.isVanished((Player)player)) {
            UUID uuid;
            Pair<BlockPos, UUID> oldHitResults = vanishedPlayersAndHitResults.get(uuid = player.getUUID());
            vanishedPlayersAndHitResults.put(uuid, (Pair<BlockPos, UUID>)(oldHitResults == null ? Pair.of((Object)hitResult.getBlockPos(), null) : Pair.of((Object)hitResult.getBlockPos(), (Object)((UUID)oldHitResults.getRight()))));
        }
    }

    public static void updateEntityHitResult(ServerPlayer player, Entity hitEntity) {
        if (VanishUtil.isVanished((Player)player)) {
            vanishedPlayersAndHitResults.put(player.getUUID(), (Pair<BlockPos, UUID>)Pair.of((Object)hitEntity.blockPosition(), (Object)hitEntity.getUUID()));
        }
    }

    public static void invalidateHitResults(ServerPlayer player) {
        if (VanishUtil.isVanished((Player)player)) {
            vanishedPlayersAndHitResults.put(player.getUUID(), null);
        }
    }

    public static void putSoundPacket(Packet<?> packet, Player player) {
        packetOrigin = Pair.of(packet, (Object)player.getUUID());
    }

    public static Player getPlayerForPacket(Packet<?> packet, PlayerList list) {
        return packetOrigin != null && ((Packet)packetOrigin.getLeft()).equals(packet) ? list.getPlayer((UUID)packetOrigin.getRight()) : null;
    }

    public static Player getIndirectVanishedSoundCause(Player player, Level level, double x, double y, double z, ServerPlayer forPlayer) {
        return SoundSuppressionHelper.getIndirectVanishedSoundCause(player, level, new Vec3(x, y, z), forPlayer);
    }

    public static Player getIndirectVanishedSoundCause(Player player, Level level, Vec3 soundOrigin, ServerPlayer forPlayer) {
        if (player != null) {
            return VanishUtil.isVanished(player, (Entity)forPlayer) ? player : null;
        }
        if (!((Boolean)VanishConfig.CONFIG.indirectSoundSuppression.get()).booleanValue()) {
            return null;
        }
        Player vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerInteractedWith(level, soundOrigin, forPlayer);
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerAt(level, soundOrigin, forPlayer);
        }
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedProjectileOwnerAt(level, soundOrigin, forPlayer);
        }
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerWithVehicleAt(level, soundOrigin, forPlayer);
        }
        return vanishedSoundCause;
    }

    public static Player getIndirectVanishedSoundCause(Player player, Level level, Entity soundOrigin, ServerPlayer forPlayer) {
        if (player != null) {
            return VanishUtil.isVanished(player, (Entity)forPlayer) ? player : null;
        }
        if (!((Boolean)VanishConfig.CONFIG.indirectSoundSuppression.get()).booleanValue() || soundOrigin == null) {
            return null;
        }
        Player vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerInteractedWith(level, soundOrigin, forPlayer);
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerAt(level, soundOrigin.position(), forPlayer);
        }
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedProjectileOwner(soundOrigin, forPlayer);
        }
        if (vanishedSoundCause == null) {
            vanishedSoundCause = SoundSuppressionHelper.getVanishedPlayerInVehicle(soundOrigin, forPlayer);
        }
        return vanishedSoundCause;
    }

    public static Player getIndirectVanishedParticleCause(Player player, Level level, double x, double y, double z, ServerPlayer forPlayer) {
        Vec3 particleOrigin = new Vec3(x, y, z);
        if (player != null) {
            return VanishUtil.isVanished(player, (Entity)forPlayer) ? player : null;
        }
        if (!((Boolean)VanishConfig.CONFIG.indirectParticleSuppression.get()).booleanValue()) {
            return null;
        }
        Player vanishedParticleCause = SoundSuppressionHelper.getVanishedPlayerInteractedWith(level, particleOrigin, forPlayer);
        if (vanishedParticleCause == null) {
            vanishedParticleCause = SoundSuppressionHelper.getVanishedPlayerAt(level, particleOrigin, forPlayer);
        }
        if (vanishedParticleCause == null) {
            vanishedParticleCause = SoundSuppressionHelper.getVanishedProjectileOwnerAt(level, particleOrigin, forPlayer);
        }
        if (vanishedParticleCause == null) {
            vanishedParticleCause = SoundSuppressionHelper.getVanishedPlayerWithVehicleAt(level, particleOrigin, forPlayer);
        }
        return vanishedParticleCause;
    }

    public static Player getVanishedPlayerAt(Level level, Vec3 pos, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.getServer().getPlayerList();
        VoxelShape shape = Shapes.block().move(pos.x - 0.5, pos.y - 0.5, pos.z - 0.5);
        return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).getPlayer(arg_0)).filter(p -> p != null && p.level().equals(level) && p.gameMode.getGameModeForPlayer() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer) && Shapes.joinIsNotEmpty((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)p.getBoundingBox()), (BooleanOp)BooleanOp.AND)).findFirst().orElse(null);
    }

    public static Player getVanishedProjectileOwnerAt(Level level, Vec3 pos, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.getServer().getPlayerList();
        AABB soundArea = AABB.ofSize((Vec3)pos, (double)1.0, (double)1.0, (double)1.0);
        List projectiles = level.getEntities((Entity)null, soundArea, e -> e instanceof Projectile);
        if (!projectiles.isEmpty()) {
            return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).getPlayer(arg_0)).filter(p -> p != null && p.level().equals(level) && p.gameMode.getGameModeForPlayer() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer) && projectiles.stream().anyMatch(proj -> p.equals((Object)((Projectile)proj).getOwner()))).findFirst().orElse(null);
        }
        return null;
    }

    public static Player getVanishedProjectileOwner(Entity entity, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.getServer().getPlayerList();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).getPlayer(arg_0)).filter(p -> p != null && p.gameMode.getGameModeForPlayer() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer) && p.equals((Object)projectile.getOwner())).findFirst().orElse(null);
        }
        return null;
    }

    public static Player getVanishedPlayerWithVehicleAt(Level level, Vec3 pos, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.getServer().getPlayerList();
        VoxelShape shape = Shapes.block().move(pos.x - 0.5, pos.y - 0.5, pos.z - 0.5);
        return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).getPlayer(arg_0)).filter(p -> p != null && p.level().equals(level) && p.gameMode.getGameModeForPlayer() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer)).map(p -> Pair.of((Object)p, (Object)p.getVehicle())).filter(pv -> pv.getRight() != null && Shapes.joinIsNotEmpty((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)((Entity)pv.getRight()).getBoundingBox()), (BooleanOp)BooleanOp.AND)).findFirst().map(Pair::getLeft).orElse(null);
    }

    public static Player getVanishedPlayerInVehicle(Entity entity, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.getServer().getPlayerList();
        return vanishedPlayersAndHitResults.keySet().stream().map(arg_0 -> ((PlayerList)list).getPlayer(arg_0)).filter(p -> p != null && p.gameMode.getGameModeForPlayer() != GameType.SPECTATOR && VanishUtil.isVanished((Player)p, (Entity)forPlayer) && entity.equals((Object)p.getVehicle())).findFirst().orElse(null);
    }

    public static Player getVanishedPlayerInteractedWith(Level level, Vec3 pos, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.getServer().getPlayerList();
        return vanishedPlayersAndHitResults.entrySet().stream().map(e -> Pair.of((Object)list.getPlayer((UUID)e.getKey()), (Object)((Pair)e.getValue()))).filter(p -> p.getKey() != null && ((ServerPlayer)p.getKey()).level().equals(level) && VanishUtil.isVanished((Player)p.getKey(), (Entity)forPlayer) && p.getValue() != null && SoundSuppressionHelper.equalsThisOrConnected(pos, level, (BlockPos)((Pair)p.getValue()).getLeft())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public static Player getVanishedPlayerInteractedWith(Level level, Entity entity, ServerPlayer forPlayer) {
        PlayerList list = forPlayer.getServer().getPlayerList();
        return vanishedPlayersAndHitResults.entrySet().stream().map(e -> Pair.of((Object)list.getPlayer((UUID)e.getKey()), (Object)((Pair)e.getValue()))).filter(p -> p.getKey() != null && ((ServerPlayer)p.getKey()).level().equals(level) && VanishUtil.isVanished((Player)p.getKey(), (Entity)forPlayer) && p.getValue() != null && entity.getUUID().equals(((Pair)p.getValue()).getRight())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public static boolean equalsThisOrConnected(Vec3 soundPos, Level level, BlockPos interactPos) {
        if (interactPos != null) {
            BlockState state = level.getBlockState(interactPos);
            if (new AABB(interactPos).inflate(0.01).contains(soundPos)) {
                return true;
            }
            if (state.getBlock() instanceof ChestBlock) {
                return new AABB(interactPos.relative(ChestBlock.getConnectedDirection((BlockState)state))).inflate(0.01).contains(soundPos);
            }
        }
        return false;
    }
}

