/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.mixin.chat;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;

@Mixin(value={CommandSourceStack.class})
public abstract class CommandSourceStackMixin {
    @Shadow
    @Final
    private MinecraftServer server;

    @Shadow
    public abstract ServerPlayer getPlayer();

    @Shadow
    public abstract boolean isPlayer();

    @Inject(method={"getOnlinePlayerNames"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanishmod$filterCommandSuggestionPlayerList(CallbackInfoReturnable<Collection<String>> callbackInfo) {
        if (((Boolean)VanishConfig.CONFIG.hidePlayersFromPlayerLists.get()).booleanValue() && this.isPlayer()) {
            ArrayList<String> filteredOnlinePlayerNames = new ArrayList<String>();
            for (String name : this.server.getPlayerNames()) {
                if (VanishUtil.isVanished((Player)this.server.getPlayerList().getPlayerByName(name), (Entity)this.getPlayer())) continue;
                filteredOnlinePlayerNames.add(name);
            }
            callbackInfo.setReturnValue(filteredOnlinePlayerNames);
        }
    }
}

