/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.mixin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.misc.FieldHolder;
import redstonedubstep.mods.vanishmod.misc.SoundSuppressionHelper;
import redstonedubstep.mods.vanishmod.misc.TraceHandler;

@Mixin(value={ServerCommonPacketListenerImpl.class})
public class ServerCommonPacketListenerImplMixin {
    @Shadow
    @Final
    protected MinecraftServer server;

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanishmod$onSendPacket(Packet<?> packet, CallbackInfo callbackInfo) {
        ServerCommonPacketListenerImplMixin serverCommonPacketListenerImplMixin = this;
        if (serverCommonPacketListenerImplMixin instanceof ServerGamePacketListenerImpl) {
            ServerPlayer pickUppingPlayer;
            ClientboundTakeItemEntityPacket pickupPacket;
            Entity filteredPacketEntries2;
            ServerGamePacketListenerImpl listener = (ServerGamePacketListenerImpl)serverCommonPacketListenerImplMixin;
            ServerPlayer receivingPlayer = listener.player;
            Level level = receivingPlayer.level();
            if (packet instanceof ClientboundPlayerInfoUpdatePacket) {
                ClientboundPlayerInfoUpdatePacket infoPacket = (ClientboundPlayerInfoUpdatePacket)packet;
                List<ClientboundPlayerInfoUpdatePacket.Entry> filteredPacketEntries2 = infoPacket.entries().stream().filter(e -> !VanishUtil.isVanished((Player)this.server.getPlayerList().getPlayer(e.profileId()), (Entity)receivingPlayer)).toList();
                if (filteredPacketEntries2.isEmpty()) {
                    callbackInfo.cancel();
                } else if (!filteredPacketEntries2.equals(infoPacket.entries())) {
                    infoPacket.entries = filteredPacketEntries2;
                }
            } else if (packet instanceof ClientboundTakeItemEntityPacket && (filteredPacketEntries2 = level.getEntity((pickupPacket = (ClientboundTakeItemEntityPacket)packet).getPlayerId())) instanceof ServerPlayer && VanishUtil.isVanished((Player)(pickUppingPlayer = (ServerPlayer)filteredPacketEntries2), (Entity)receivingPlayer)) {
                TraceHandler.trace((Player)pickUppingPlayer, "Pickup Animation", pickupPacket.getItemId() + "x" + pickupPacket.getAmount());
                callbackInfo.cancel();
            } else if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue()) {
                ClientboundLevelParticlesPacket particlesPacket;
                PlayerList playerList = receivingPlayer.server.getPlayerList();
                Holder suppressedSound = null;
                Player vanishedIndirectCause = null;
                if (packet instanceof ClientboundSoundPacket) {
                    ClientboundSoundPacket soundPacket = (ClientboundSoundPacket)packet;
                    vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedSoundCause(SoundSuppressionHelper.getPlayerForPacket(soundPacket, playerList), level, soundPacket.getX(), soundPacket.getY(), soundPacket.getZ(), receivingPlayer);
                    if (vanishedIndirectCause != null) {
                        suppressedSound = soundPacket.getSound();
                    }
                } else if (packet instanceof ClientboundSoundEntityPacket) {
                    ClientboundSoundEntityPacket soundPacket = (ClientboundSoundEntityPacket)packet;
                    vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedSoundCause(SoundSuppressionHelper.getPlayerForPacket(soundPacket, playerList), level, level.getEntity(soundPacket.getId()), receivingPlayer);
                    if (vanishedIndirectCause != null) {
                        suppressedSound = soundPacket.getSound();
                    }
                } else if (packet instanceof ClientboundLevelEventPacket) {
                    ClientboundLevelEventPacket soundPacket = (ClientboundLevelEventPacket)packet;
                    vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedSoundCause(SoundSuppressionHelper.getPlayerForPacket(soundPacket, playerList), level, Vec3.atCenterOf((Vec3i)soundPacket.getPos()), receivingPlayer);
                    if (vanishedIndirectCause != null) {
                        TraceHandler.trace(vanishedIndirectCause, "Level Event", soundPacket.getType() + "/" + soundPacket.getData());
                        callbackInfo.cancel();
                    }
                } else if (packet instanceof ClientboundBlockEventPacket) {
                    ClientboundBlockEventPacket eventPacket = (ClientboundBlockEventPacket)packet;
                    vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedSoundCause(null, level, Vec3.atCenterOf((Vec3i)eventPacket.getPos()), receivingPlayer);
                    if (vanishedIndirectCause != null) {
                        TraceHandler.trace(vanishedIndirectCause, "Block Event", eventPacket.getBlock().getName().getString() + "/" + eventPacket.getB0() + "/" + eventPacket.getB1());
                        callbackInfo.cancel();
                    }
                } else if (packet instanceof ClientboundLevelParticlesPacket && (vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedParticleCause(null, level, (particlesPacket = (ClientboundLevelParticlesPacket)packet).getX(), particlesPacket.getY(), particlesPacket.getZ(), receivingPlayer)) != null) {
                    TraceHandler.trace(vanishedIndirectCause, "Particle", particlesPacket.getParticle().getClass().getSimpleName());
                    callbackInfo.cancel();
                }
                if (suppressedSound != null) {
                    TraceHandler.trace(vanishedIndirectCause, "Sound", ((SoundEvent)suppressedSound.value()).getLocation().toString());
                    callbackInfo.cancel();
                }
            }
        }
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanishmod$onSendPacket(Packet<?> packet, PacketSendListener sendListener, CallbackInfo callbackInfo) {
        block6: {
            String key;
            ArrayList<ServerPlayer> vanishedPlayers;
            TranslatableContents content;
            MutableComponent component;
            block8: {
                block7: {
                    ClientboundSystemChatPacket chatPacket;
                    ServerCommonPacketListenerImplMixin serverCommonPacketListenerImplMixin = this;
                    if (!(serverCommonPacketListenerImplMixin instanceof ServerGamePacketListenerImpl)) break block6;
                    ServerGamePacketListenerImpl listener = (ServerGamePacketListenerImpl)serverCommonPacketListenerImplMixin;
                    if (!(packet instanceof ClientboundSystemChatPacket) || !((serverCommonPacketListenerImplMixin = (chatPacket = (ClientboundSystemChatPacket)packet).content()) instanceof MutableComponent) || !((serverCommonPacketListenerImplMixin = (component = (MutableComponent)serverCommonPacketListenerImplMixin).getContents()) instanceof TranslatableContents)) break block6;
                    content = (TranslatableContents)serverCommonPacketListenerImplMixin;
                    ServerPlayer player = listener.player;
                    vanishedPlayers = new ArrayList<ServerPlayer>(ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers().stream().filter(p -> VanishUtil.isVanished((Player)p, (Entity)player)).toList());
                    key = content.getKey();
                    boolean joiningPlayerVanished = VanishUtil.isVanished((Player)FieldHolder.joiningPlayer, (Entity)player);
                    if (joiningPlayerVanished) {
                        vanishedPlayers.add(FieldHolder.joiningPlayer);
                    }
                    if (VanishUtil.isVanished((Player)FieldHolder.leavingPlayer, (Entity)player)) {
                        vanishedPlayers.add(FieldHolder.leavingPlayer);
                    }
                    if (!key.startsWith("multiplayer.player.joined") || !joiningPlayerVanished) break block7;
                    callbackInfo.cancel();
                    break block6;
                }
                if (!key.startsWith("multiplayer.player.left") && !key.startsWith("death.") && !key.startsWith("chat.type.advancement.") && !key.startsWith("chat.type.admin")) break block8;
                Iterator iterator = content.getArgs()[0];
                if (!(iterator instanceof Component)) break block6;
                Component playerName = (Component)iterator;
                for (ServerPlayer sender : vanishedPlayers) {
                    if (!sender.getDisplayName().getString().equals(playerName.getString())) continue;
                    TraceHandler.trace((Player)sender, "Announcement", component.getString());
                    callbackInfo.cancel();
                    return;
                }
                break block6;
            }
            if (((Boolean)VanishConfig.CONFIG.removeModdedSystemMessageReferences.get()).booleanValue() && !key.startsWith("commands.message.display.incoming") && !key.startsWith("chat.type.")) {
                for (Object arg : content.getArgs()) {
                    if (!(arg instanceof Component)) continue;
                    Component componentArg = (Component)arg;
                    String potentialPlayerName = componentArg.getString();
                    for (ServerPlayer vanishedPlayer : vanishedPlayers) {
                        if (!vanishedPlayer.getDisplayName().getString().equals(potentialPlayerName)) continue;
                        TraceHandler.trace((Player)vanishedPlayer, "Mentioning Message", component.getString());
                        callbackInfo.cancel();
                        return;
                    }
                }
            }
        }
    }
}

