/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.VanillaGameEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.Vanishmod;
import redstonedubstep.mods.vanishmod.compat.Mc2DiscordCompat;
import redstonedubstep.mods.vanishmod.misc.FieldHolder;
import redstonedubstep.mods.vanishmod.misc.SoundSuppressionHelper;
import redstonedubstep.mods.vanishmod.misc.TraceHandler;

@EventBusSubscriber(modid="vmod")
public class VanishEventListener {
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (ModList.get().isLoaded("mc2discord")) {
            Vanishmod.mc2discordDetected = true;
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        VanishUtil.VANISHED_PLAYERS.clear();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerList list = player2.getServer().getPlayerList();
            if (VanishUtil.isVanished((Player)player2)) {
                player2.sendSystemMessage((Component)VanishUtil.VANISHMOD_PREFIX.copy().append("Note: You are currently vanished"));
                for (ServerPlayer otherPlayer : list.getPlayers()) {
                    if (otherPlayer.equals((Object)player2) || VanishUtil.isVanished((Player)player2, (Entity)otherPlayer)) continue;
                    otherPlayer.sendSystemMessage((Component)VanishUtil.VANISHMOD_PREFIX.copy().append("Note: ").append(player2.getDisplayName()).append(" is currently vanished"));
                }
            } else {
                for (ServerPlayer otherPlayer : list.getPlayers()) {
                    if (otherPlayer.equals((Object)player2) || !VanishUtil.isVanished((Player)otherPlayer) || VanishUtil.isVanished((Player)otherPlayer, (Entity)player2)) continue;
                    player2.sendSystemMessage((Component)VanishUtil.VANISHMOD_PREFIX.copy().append("Note: At least one player visible for you is vanished for other players, be careful to not accidentally reveal them"));
                    break;
                }
            }
        }
        if (event.getEntity().equals((Object)FieldHolder.joiningPlayer)) {
            FieldHolder.joiningPlayer = null;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            boolean isVanished;
            ServerPlayer player2 = (ServerPlayer)player;
            if (Vanishmod.mc2discordDetected && ((Boolean)VanishConfig.CONFIG.forceSyncHiddenList.get()).booleanValue() && (isVanished = VanishUtil.isVanished((Player)player2)) != Mc2DiscordCompat.isHidden(player2)) {
                Mc2DiscordCompat.hidePlayer(player2, isVanished);
            }
            if (player2.level().getGameTime() % 20L == 0L) {
                TraceHandler.sendTraceEntries(player2);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onTabListName(PlayerEvent.TabListNameFormat event) {
        if (VanishUtil.isVanished(event.getEntity())) {
            MutableComponent vanishedName = Component.literal((String)"").withStyle(ChatFormatting.ITALIC);
            vanishedName.append((Component)Component.literal((String)"[").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"Vanished").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)(event.getDisplayName() == null ? PlayerTeam.formatNameForTeam((Team)event.getEntity().getTeam(), (Component)event.getEntity().getName()) : event.getDisplayName()));
            event.setDisplayName((Component)vanishedName);
        }
    }

    @SubscribeEvent
    public static void onInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        if (SoundSuppressionHelper.shouldCapturePlayers() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.gameMode.getGameModeForPlayer() != GameType.SPECTATOR) {
                SoundSuppressionHelper.updateBlockHitResult(player2, event.getHitVec());
            }
        }
    }

    @SubscribeEvent
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Player player;
        if (SoundSuppressionHelper.shouldCapturePlayers() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.gameMode.getGameModeForPlayer() != GameType.SPECTATOR) {
                SoundSuppressionHelper.updateEntityHitResult(player2, event.getTarget());
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player;
        if (SoundSuppressionHelper.shouldCapturePlayers() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.gameMode.getGameModeForPlayer() != GameType.SPECTATOR) {
                SoundSuppressionHelper.updateEntityHitResult(player2, event.getTarget());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onChangeTarget(LivingChangeTargetEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity;
        if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue() && (livingEntity = event.getNewAboutToBeSetTarget()) instanceof ServerPlayer && VanishUtil.isVanished((Player)(player = (ServerPlayer)livingEntity))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult hitResult;
        HitResult hitResult2;
        if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue() && (hitResult2 = event.getRayTraceResult()) instanceof EntityHitResult && VanishUtil.isVanished((hitResult = (EntityHitResult)hitResult2).getEntity(), event.getProjectile().getOwner())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onVanillaGameEvent(VanillaGameEvent event) {
        Entity entity = event.getCause();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue() && VanishUtil.isVanished((Player)player)) {
                event.setCanceled(true);
            }
        }
    }
}

