/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.misc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;

public class TraceHandler {
    public static final MutableComponent TRACE_PREFIX = Component.literal((String)"").append((Component)Component.literal((String)"[").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"\u00a77Trace\u00a7r").withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to disable"))).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/vanish trace disable")))).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.WHITE));
    private static final Map<UUID, Map<String, Set<String>>> traceEntries = new HashMap<UUID, Map<String, Set<String>>>();

    public static boolean isTracing(Player player) {
        return traceEntries.containsKey(player.getUUID());
    }

    public static void setTracing(ServerPlayer player, boolean shouldTrace) {
        UUID uuid = player.getUUID();
        if (shouldTrace) {
            traceEntries.put(uuid, new HashMap());
        } else {
            traceEntries.remove(uuid);
        }
    }

    public static void sendTraceStatus(ServerPlayer player) {
        int seeVanishedOpLevel = (Integer)VanishConfig.CONFIG.seeVanishedPermissionLevel.get();
        ArrayList<Object> permissionText = new ArrayList<Object>();
        if (((Boolean)VanishConfig.CONFIG.vanishedPlayersSeeEachOther.get()).booleanValue()) {
            permissionText.add("Other vanished players");
        }
        if (((Boolean)VanishConfig.CONFIG.seeVanishedTeamPlayers.get()).booleanValue()) {
            permissionText.add("Members of your team");
        }
        if (seeVanishedOpLevel >= 0) {
            permissionText.add("All players with an operator level of " + seeVanishedOpLevel + " or higher");
        }
        String permissionString = !permissionText.isEmpty() ? String.join((CharSequence)" + ", permissionText) : "Only yourself";
        MutableComponent visibleForComponent = Component.literal((String)("# \u00a7nPlayers permitted to see you\u00a7r: " + permissionString + " "));
        List<Component> visibleForPlayerNames = player.getServer().getPlayerList().getPlayers().stream().filter(p -> p != player && !VanishUtil.isVanished((Player)player, (Entity)p)).map(Player::getDisplayName).toList();
        if (!visibleForPlayerNames.isEmpty()) {
            visibleForComponent.append((Component)Component.literal((String)"\u00a77(...)").withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Currently: ").append(ComponentUtils.formatList((Collection)visibleForPlayerNames, (Component)ComponentUtils.DEFAULT_SEPARATOR))))));
        }
        player.sendSystemMessage((Component)Component.literal((String)"# \u00a7nTrace Status\u00a7r:"));
        player.sendSystemMessage((Component)Component.literal((String)"# \u00a7bAlways enabled\u00a7r: ").append((Component)Component.literal((String)"\u00a77(...)").withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Hiding from the tab list, hiding your skin, hiding join/leave/death/advancement/command feedback messages"))))));
        player.sendSystemMessage((Component)TraceHandler.getTracePrefix((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).append("Hiding from the world, like through suppressing sounds and particles"));
        player.sendSystemMessage((Component)TraceHandler.getTracePrefix((Boolean)VanishConfig.CONFIG.hidePlayersFromPlayerLists.get()).append("Hiding from other player lists, like the server player list in the multiplayer screen"));
        player.sendSystemMessage((Component)TraceHandler.getTracePrefix((Boolean)VanishConfig.CONFIG.disableCommandTargeting.get()).append("Hiding from player selectors in commands, like the /give command"));
        player.sendSystemMessage((Component)TraceHandler.getTracePrefix((Boolean)VanishConfig.CONFIG.hideChatMessages.get()).append("Hiding chat and /teammsg messages"));
        player.sendSystemMessage((Component)TraceHandler.getTracePrefix((Boolean)VanishConfig.CONFIG.hidePlayerNameInChat.get()).append("Hiding your player name in /say, /me and /msg messages, replacing it with \"\u00a77vanished\u00a7r\""));
        player.sendSystemMessage((Component)visibleForComponent);
    }

    private static MutableComponent getTracePrefix(boolean enabled) {
        return Component.empty().append(enabled ? "# \u00a7aEnabled\u00a7r: " : "# \u00a77Disabled\u00a7r: ");
    }

    public static void trace(Player player, String group, String identifier) {
        if (TraceHandler.isTracing(player)) {
            Map<String, Set<String>> playerTraceEntries = traceEntries.get(player.getUUID());
            if (playerTraceEntries.containsKey(group)) {
                playerTraceEntries.get(group).add(identifier);
            } else {
                playerTraceEntries.put(group, Sets.newHashSet((Object[])new String[]{identifier}));
            }
        }
    }

    public static void sendTraceEntries(ServerPlayer player) {
        if (TraceHandler.isTracing((Player)player)) {
            Map<String, Set<String>> playerTraceEntries = traceEntries.get(player.getUUID());
            if (playerTraceEntries.isEmpty()) {
                return;
            }
            player.sendSystemMessage((Component)VanishUtil.VANISHMOD_PREFIX.copy().append((Component)TRACE_PREFIX).append("Concealed the following events:"));
            for (Map.Entry<String, Set<String>> traceEntry : playerTraceEntries.entrySet()) {
                player.sendSystemMessage((Component)Component.literal((String)("# \u00a75" + traceEntry.getKey() + "\u00a7r: " + traceEntry.getValue().size() + " ")).append((Component)Component.literal((String)"\u00a77(...)").withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText(ComponentUtils.formatList((Collection)((Collection)traceEntry.getValue())))))));
            }
            playerTraceEntries.clear();
        }
    }
}

