/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.VanishingHandler;
import redstonedubstep.mods.vanishmod.misc.TraceHandler;

public class VanishCommand {
    private static final Component HELP_TEXT = VanishUtil.VANISHMOD_PREFIX.m_6881_().m_7220_((Component)Component.m_237113_((String)"\u00a77\u00a7nVanishmod\u00a7r is a mod that allows you to become completely undetectable for other players. Most features can be accessed using the \u00a77/vanish\u00a7r (or \u00a77/v\u00a7r) command.\n\u00a7nCommand Usage\u00a7r:\n\u00a77/v get [<player>]\u00a7r: Queries the current vanished status of the given player.\n\u00a77/v help\u00a7r: Shows this message.\n\u00a77/v queue [<player>]\u00a7r: Adds the given player name to the vanishing queue. If the player is online, they are immediately vanished. If not, they are vanished as soon as they join the server.\n\u00a77/v toggle [<player>]\u00a7r (or \u00a77/v\u00a7r): Vanishes or unvanishes the given player, depending on their prior vanished status.\n\u00a77/v trace\u00a7r: Enables and disables tracing, which is a debug functionality that reports any event caused by you that has been concealed for other players.\n\nA lot of the features of this mod are customizable via the configuration file, which is located in the \"config\" folder of your server, so check that out if you're interested!\nIf you have a suggestion or found a bug, feel free to open an issue in")).m_7220_((Component)Component.m_237113_((String)" \u00a77\u00a7nthe mod's GitHub repository\u00a7r.").m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/RedstoneDubstep/Vanishmod"))));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(VanishCommand.alias("v"));
        dispatcher.register(VanishCommand.alias("vanish"));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> alias(String prefix) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)prefix).requires(player -> player.m_6761_(((Integer)VanishConfig.CONFIG.vanishCommandPermissionLevel.get()).intValue()))).executes(ctx -> VanishCommand.vanish((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(ctx -> VanishCommand.getVanishedStatus((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> VanishCommand.getVanishedStatus((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(Commands.m_82127_((String)"help").executes(VanishCommand::sendHelpText))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"queue").executes(ctx -> VanishCommand.queue((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_().m_36316_().getName()))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> VanishCommand.queue((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle").executes(ctx -> VanishCommand.vanish((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> VanishCommand.vanish((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"trace").then(Commands.m_82127_((String)"enable").executes(ctx -> VanishCommand.setTrace((CommandContext<CommandSourceStack>)ctx, null, true)))).then(Commands.m_82127_((String)"disable").executes(ctx -> VanishCommand.setTrace((CommandContext<CommandSourceStack>)ctx, null, false))));
    }

    private static int getVanishedStatus(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        MutableComponent vanishedStatus = VanishUtil.getVanishedStatusText(player, VanishUtil.isVanished((Player)player));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> VanishUtil.VANISHMOD_PREFIX.m_6881_().m_7220_((Component)vanishedStatus), false);
        Entity entity = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer currentPlayer = (ServerPlayer)entity;
            currentPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)vanishedStatus));
        }
        return 1;
    }

    private static int sendHelpText(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).m_243053_(HELP_TEXT);
        return 1;
    }

    private static int queue(CommandContext<CommandSourceStack> ctx, String playerName) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11255_(playerName);
        if (player != null) {
            if (VanishUtil.isVanished((Player)player)) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_130946_(String.format("Could not add already vanished player %s to the vanishing queue", playerName)));
                return 0;
            }
            VanishCommand.vanish(ctx, player);
        } else if (VanishingHandler.removeFromQueue(playerName)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> VanishUtil.VANISHMOD_PREFIX.m_6881_().m_130946_(String.format("Removed %s from the vanishing queue", playerName)), true);
        } else if (VanishingHandler.addToQueue(playerName)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> VanishUtil.VANISHMOD_PREFIX.m_6881_().m_130946_(String.format("Added %s to the vanishing queue", playerName)), true);
        }
        return 1;
    }

    private static int vanish(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        boolean isVanishing;
        boolean bl = isVanishing = !VanishUtil.isVanished((Player)player);
        if (!isVanishing) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> VanishUtil.VANISHMOD_PREFIX.m_6881_().m_7220_((Component)Component.m_237110_((String)((String)VanishConfig.CONFIG.onUnvanishMessage.get()), (Object[])new Object[]{player.m_5446_()})), true);
            if (TraceHandler.isTracing((Player)player)) {
                VanishCommand.setTrace(ctx, player, false);
            }
        }
        VanishingHandler.toggleVanish(player);
        if (isVanishing) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> VanishUtil.VANISHMOD_PREFIX.m_6881_().m_7220_((Component)Component.m_237110_((String)((String)VanishConfig.CONFIG.onVanishMessage.get()), (Object[])new Object[]{player.m_5446_()})), true);
        }
        return 1;
    }

    private static int setTrace(CommandContext<CommandSourceStack> ctx, ServerPlayer playerOverride, boolean shouldTrace) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = playerOverride != null ? playerOverride : source.m_81375_();
        boolean isTracing = TraceHandler.isTracing((Player)player);
        if (!VanishUtil.isVanished((Player)player)) {
            source.m_81352_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_130946_("You need to be vanished to configure tracing!"));
            return 0;
        }
        if (isTracing == shouldTrace) {
            source.m_81352_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_130946_("Tracing is already " + (isTracing ? "enabled!" : "disabled!")));
            return 0;
        }
        TraceHandler.setTracing(player, shouldTrace);
        if (shouldTrace) {
            source.m_243053_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_130946_("Tracing is now enabled."));
            TraceHandler.sendTraceStatus(player);
        } else {
            source.m_243053_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_130946_("Tracing is now disabled."));
        }
        return 1;
    }
}

