/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.Vanishmod;
import redstonedubstep.mods.vanishmod.api.PlayerVanishEvent;
import redstonedubstep.mods.vanishmod.compat.Mc2DiscordCompat;
import redstonedubstep.mods.vanishmod.misc.SoundSuppressionHelper;

public class VanishingHandler {
    private static final Set<String> vanishingQueue = new HashSet<String>();

    public static void toggleVanish(ServerPlayer player) {
        boolean vanishes = !VanishUtil.isVanished((Player)player);
        String note = "Note: You can still see yourself in the tab list for technical reasons, but you are vanished for other players. \nNote: Be careful when producing noise near other players, because while most sounds will get suppressed, some won't due to technical limitations. \nNote: While vanished, only players that are able to see you will receive your chat messages. If you want to chat with everyone, use the /say command.";
        if (vanishes) {
            player.m_213846_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_130946_("Note: ").m_7220_((Component)Component.m_237113_((String)"(...)").m_130938_(s -> s.m_131157_(ChatFormatting.GRAY).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)note))))));
        }
        VanishingHandler.sendJoinOrLeaveMessageToPlayers(player.f_8924_.m_6846_().m_11314_(), player, vanishes, false);
        VanishingHandler.updateVanishedStatus(player, vanishes);
        VanishingHandler.sendJoinOrLeaveMessageToPlayers(player.f_8924_.m_6846_().m_11314_(), player, vanishes, true);
        VanishingHandler.sendPacketsOnVanish(player, player.m_284548_(), vanishes);
    }

    public static void sendPacketsOnVanish(ServerPlayer changingPlayer, ServerLevel world, boolean vanishes) {
        List list = world.m_7654_().m_6846_().m_11314_();
        ServerChunkCache chunkProvider = changingPlayer.m_284548_().m_7726_();
        for (ServerPlayer otherPlayer : list) {
            boolean otherPlayerVanished = VanishUtil.isVanished((Player)otherPlayer);
            boolean otherAllowedToSeeChanging = VanishUtil.playerAllowedToSeeOther((Entity)otherPlayer, (Entity)changingPlayer, otherPlayerVanished, vanishes);
            boolean changingAllowedToSeeOther = VanishUtil.playerAllowedToSeeOther((Entity)changingPlayer, (Entity)otherPlayer, vanishes, otherPlayerVanished);
            if (otherPlayer.equals((Object)changingPlayer)) continue;
            otherPlayer.f_8906_.m_9829_((Packet)(otherAllowedToSeeChanging ? ClientboundPlayerInfoUpdatePacket.m_247122_(List.of(changingPlayer)) : new ClientboundPlayerInfoRemovePacket(List.of(changingPlayer.m_20148_()))));
            if (otherPlayerVanished) {
                changingPlayer.f_8906_.m_9829_((Packet)(changingAllowedToSeeOther ? ClientboundPlayerInfoUpdatePacket.m_247122_(List.of(otherPlayer)) : new ClientboundPlayerInfoRemovePacket(List.of(otherPlayer.m_20148_()))));
            }
            if (!((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue()) continue;
            if (vanishes && !otherAllowedToSeeChanging) {
                otherPlayer.f_8906_.m_9829_((Packet)new ClientboundRemoveEntitiesPacket(new int[]{changingPlayer.m_19879_()}));
                continue;
            }
            if (vanishes || changingAllowedToSeeOther) continue;
            changingPlayer.f_8906_.m_9829_((Packet)new ClientboundRemoveEntitiesPacket(new int[]{otherPlayer.m_19879_()}));
        }
        if (chunkProvider.f_8325_.f_140150_.containsKey(changingPlayer.m_19879_())) {
            chunkProvider.f_8325_.f_140150_.remove(changingPlayer.m_19879_());
            chunkProvider.m_8463_((Entity)changingPlayer);
        }
        changingPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)VanishUtil.getVanishedStatusText(changingPlayer, vanishes)));
        changingPlayer.refreshTabListName();
    }

    public static void sendJoinOrLeaveMessageToPlayers(List<ServerPlayer> playerList, ServerPlayer sender, boolean leaveMessage, boolean beforeStatusChange) {
        if (((Boolean)VanishConfig.CONFIG.sendFakeJoinLeaveMessages.get()).booleanValue() && leaveMessage != beforeStatusChange && sender.f_8924_.m_6846_().m_11314_().contains(sender)) {
            MutableComponent message = Component.m_237110_((String)(leaveMessage ? "multiplayer.player.left" : "multiplayer.player.joined"), (Object[])new Object[]{sender.m_5446_()}).m_130940_(ChatFormatting.YELLOW);
            for (ServerPlayer receiver : playerList) {
                receiver.m_213846_((Component)message);
            }
            if (Vanishmod.mc2discordDetected) {
                Mc2DiscordCompat.sendFakeJoinLeaveMessage(sender, leaveMessage);
            }
        }
    }

    public static void updateVanishedStatus(ServerPlayer player, boolean vanished) {
        CompoundTag persistentData = player.getPersistentData();
        CompoundTag deathPersistentData = persistentData.m_128469_("PlayerPersisted");
        deathPersistentData.m_128379_("Vanished", vanished);
        persistentData.m_128365_("PlayerPersisted", (Tag)deathPersistentData);
        VanishingHandler.updateVanishedPlayerList(player, vanished);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerVanishEvent((Player)player, vanished));
    }

    public static void updateVanishedPlayerList(ServerPlayer player, boolean vanished) {
        if (vanished) {
            VanishUtil.VANISHED_PLAYERS.add(player.m_20148_());
        } else {
            VanishUtil.VANISHED_PLAYERS.remove(player.m_20148_());
        }
        if (Vanishmod.mc2discordDetected) {
            Mc2DiscordCompat.hidePlayer(player, vanished);
        }
        SoundSuppressionHelper.updateVanishedPlayerMap(player, vanished);
    }

    public static boolean addToQueue(String playerName) {
        return vanishingQueue.add(playerName);
    }

    public static boolean removeFromQueue(String playerName) {
        return vanishingQueue.remove(playerName);
    }
}

