/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.mixin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.misc.FieldHolder;
import redstonedubstep.mods.vanishmod.misc.SoundSuppressionHelper;
import redstonedubstep.mods.vanishmod.misc.TraceHandler;

@Mixin(value={ServerGamePacketListenerImpl.class}, priority=1200)
public class ServerGamePacketListenerImplMixin {
    @Shadow
    public ServerPlayer f_9743_;
    @Shadow
    @Final
    private MinecraftServer f_9745_;

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanishmod$onSendPacket(Packet<?> packet, CallbackInfo callbackInfo) {
        ServerPlayer pickUppingPlayer;
        ClientboundTakeItemEntityPacket pickupPacket;
        Entity filteredPacketEntries2;
        ServerPlayer receivingPlayer = this.f_9743_;
        Level level = receivingPlayer.m_9236_();
        if (packet instanceof ClientboundPlayerInfoUpdatePacket) {
            ClientboundPlayerInfoUpdatePacket infoPacket = (ClientboundPlayerInfoUpdatePacket)packet;
            List<ClientboundPlayerInfoUpdatePacket.Entry> filteredPacketEntries2 = infoPacket.m_246778_().stream().filter(e -> !VanishUtil.isVanished((Player)this.f_9745_.m_6846_().m_11259_(e.f_244142_()), (Entity)receivingPlayer)).toList();
            if (filteredPacketEntries2.isEmpty()) {
                callbackInfo.cancel();
            } else if (!filteredPacketEntries2.equals(infoPacket.m_246778_())) {
                infoPacket.f_244436_ = filteredPacketEntries2;
            }
        } else if (packet instanceof ClientboundTakeItemEntityPacket && (filteredPacketEntries2 = level.m_6815_((pickupPacket = (ClientboundTakeItemEntityPacket)packet).m_133527_())) instanceof ServerPlayer && VanishUtil.isVanished((Player)(pickUppingPlayer = (ServerPlayer)filteredPacketEntries2), (Entity)receivingPlayer)) {
            TraceHandler.trace((Player)pickUppingPlayer, "Pickup Animation", pickupPacket.m_133524_() + "x" + pickupPacket.m_133528_());
            callbackInfo.cancel();
        } else if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue()) {
            ClientboundLevelParticlesPacket particlesPacket;
            PlayerList playerList = receivingPlayer.f_8924_.m_6846_();
            Holder suppressedSound = null;
            Player vanishedIndirectCause = null;
            if (packet instanceof ClientboundSoundPacket) {
                ClientboundSoundPacket soundPacket = (ClientboundSoundPacket)packet;
                vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedSoundCause(SoundSuppressionHelper.getPlayerForPacket(soundPacket, playerList), level, soundPacket.m_133459_(), soundPacket.m_133460_(), soundPacket.m_133461_(), receivingPlayer);
                if (vanishedIndirectCause != null) {
                    suppressedSound = soundPacket.m_263229_();
                }
            } else if (packet instanceof ClientboundSoundEntityPacket) {
                ClientboundSoundEntityPacket soundPacket = (ClientboundSoundEntityPacket)packet;
                vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedSoundCause(SoundSuppressionHelper.getPlayerForPacket(soundPacket, playerList), level, level.m_6815_(soundPacket.m_133430_()), receivingPlayer);
                if (vanishedIndirectCause != null) {
                    suppressedSound = soundPacket.m_263456_();
                }
            } else if (packet instanceof ClientboundLevelEventPacket) {
                ClientboundLevelEventPacket soundPacket = (ClientboundLevelEventPacket)packet;
                vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedSoundCause(SoundSuppressionHelper.getPlayerForPacket(soundPacket, playerList), level, Vec3.m_82512_((Vec3i)soundPacket.m_132279_()), receivingPlayer);
                if (vanishedIndirectCause != null) {
                    TraceHandler.trace(vanishedIndirectCause, "Level Event", soundPacket.m_132277_() + "/" + soundPacket.m_132278_());
                    callbackInfo.cancel();
                }
            } else if (packet instanceof ClientboundBlockEventPacket) {
                ClientboundBlockEventPacket eventPacket = (ClientboundBlockEventPacket)packet;
                vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedSoundCause(null, level, Vec3.m_82512_((Vec3i)eventPacket.m_131725_()), receivingPlayer);
                if (vanishedIndirectCause != null) {
                    TraceHandler.trace(vanishedIndirectCause, "Block Event", eventPacket.m_131730_().m_49954_().getString() + "/" + eventPacket.m_131728_() + "/" + eventPacket.m_131729_());
                    callbackInfo.cancel();
                }
            } else if (packet instanceof ClientboundLevelParticlesPacket && (vanishedIndirectCause = SoundSuppressionHelper.getIndirectVanishedParticleCause(null, level, (particlesPacket = (ClientboundLevelParticlesPacket)packet).m_132314_(), particlesPacket.m_132315_(), particlesPacket.m_132316_(), receivingPlayer)) != null) {
                TraceHandler.trace(vanishedIndirectCause, "Particle", particlesPacket.m_132322_().getClass().getSimpleName());
                callbackInfo.cancel();
            }
            if (suppressedSound != null) {
                TraceHandler.trace(vanishedIndirectCause, "Sound", ((SoundEvent)suppressedSound.m_203334_()).m_11660_().toString());
                callbackInfo.cancel();
            }
        }
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanishmod$onSendPacket(Packet<?> packet, PacketSendListener listener, CallbackInfo callbackInfo) {
        MutableComponent component;
        ClientboundSystemChatPacket chatPacket;
        Component component2;
        if (packet instanceof ClientboundSystemChatPacket && (component2 = (chatPacket = (ClientboundSystemChatPacket)packet).f_237849_()) instanceof MutableComponent && (component2 = (component = (MutableComponent)component2).m_214077_()) instanceof TranslatableContents) {
            TranslatableContents content = (TranslatableContents)component2;
            ArrayList<ServerPlayer> vanishedPlayers = new ArrayList<ServerPlayer>(ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().stream().filter(p -> VanishUtil.isVanished((Player)p, (Entity)this.f_9743_)).toList());
            String key = content.m_237508_();
            boolean joiningPlayerVanished = VanishUtil.isVanished((Player)FieldHolder.joiningPlayer, (Entity)this.f_9743_);
            if (joiningPlayerVanished) {
                vanishedPlayers.add(FieldHolder.joiningPlayer);
            }
            if (VanishUtil.isVanished((Player)FieldHolder.leavingPlayer, (Entity)this.f_9743_)) {
                vanishedPlayers.add(FieldHolder.leavingPlayer);
            }
            if (key.startsWith("multiplayer.player.joined") && joiningPlayerVanished) {
                callbackInfo.cancel();
            } else if (key.startsWith("multiplayer.player.left") || key.startsWith("death.") || key.startsWith("chat.type.advancement.") || key.startsWith("chat.type.admin")) {
                Iterator iterator = content.m_237523_()[0];
                if (iterator instanceof Component) {
                    Component playerName = (Component)iterator;
                    iterator = vanishedPlayers.iterator();
                    if (iterator.hasNext()) {
                        ServerPlayer sender = (ServerPlayer)iterator.next();
                        TraceHandler.trace((Player)sender, "Announcement", component.getString());
                        callbackInfo.cancel();
                        return;
                    }
                }
            } else if (((Boolean)VanishConfig.CONFIG.removeModdedSystemMessageReferences.get()).booleanValue() && !key.startsWith("commands.message.display.incoming") && !key.startsWith("chat.type.")) {
                for (Object arg : content.m_237523_()) {
                    if (!(arg instanceof Component)) continue;
                    Component componentArg = (Component)arg;
                    String potentialPlayerName = componentArg.getString();
                    for (ServerPlayer vanishedPlayer : vanishedPlayers) {
                        if (!vanishedPlayer.m_5446_().getString().equals(potentialPlayerName)) continue;
                        TraceHandler.trace((Player)vanishedPlayer, "Mentioning Message", component.getString());
                        callbackInfo.cancel();
                        return;
                    }
                }
            }
        }
    }

    @Inject(method={"onDisconnect"}, at={@At(value="HEAD")})
    private void vanishmod$onStartDisconnect(Component reason, CallbackInfo callbackInfo) {
        FieldHolder.leavingPlayer = this.f_9743_;
    }

    @Inject(method={"onDisconnect"}, at={@At(value="TAIL")})
    private void vanishmod$onFinishDisconnect(Component reason, CallbackInfo callbackInfo) {
        FieldHolder.leavingPlayer = null;
        TraceHandler.setTracing(this.f_9743_, false);
    }
}

