/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.misc.TraceHandler;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Shadow
    @Final
    public MinecraftServer f_8924_;

    public ServerPlayerMixin(Level world, BlockPos pos, float angle, GameProfile gameProfile) {
        super(world, pos, angle, gameProfile);
    }

    @Inject(method={"sendChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    public void vanishmod$onSendChatMessage(OutgoingChatMessage message, boolean filter, ChatType.Bound chatType, CallbackInfo callback) {
        if (message instanceof OutgoingChatMessage.Player) {
            OutgoingChatMessage.Player playerChatMessage = (OutgoingChatMessage.Player)message;
            ServerPlayer sender = this.f_8924_.m_6846_().m_11259_(playerChatMessage.f_243697_().f_243882_().f_244443_());
            ResourceKey<ChatType> chatTypeKey = VanishUtil.getChatTypeRegistryKey(chatType, this);
            if (VanishUtil.isVanished((Player)sender, (Entity)this)) {
                if (!((Boolean)VanishConfig.CONFIG.hideChatMessages.get()).booleanValue() || chatTypeKey != ChatType.f_130598_ && chatTypeKey != ChatType.f_241694_) {
                    if (((Boolean)VanishConfig.CONFIG.hidePlayerNameInChat.get()).booleanValue()) {
                        TraceHandler.trace((Player)sender, "Chat Message Sender (now \"vanished\")", message.m_245730_().getString());
                        chatType = ChatType.m_240968_(chatTypeKey, (RegistryAccess)this.m_9236_().m_9598_(), (Component)Component.m_237113_((String)"vanished").m_130940_(ChatFormatting.GRAY));
                    }
                    this.m_213846_(chatType.m_240977_(playerChatMessage.m_245730_()));
                    callback.cancel();
                    return;
                }
                TraceHandler.trace((Player)sender, "Chat Message", message.m_245730_().getString());
                callback.cancel();
            }
        }
    }

    @Inject(method={"isSpectator"}, at={@At(value="HEAD")}, cancellable=true)
    public void vanishmod$onIsSpectator(CallbackInfoReturnable<Boolean> callback) {
        String callerClassName;
        if (((Boolean)VanishConfig.CONFIG.fixPlayerDetectionModCompatibility.get()).booleanValue() && VanishUtil.isVanished(this) && !(callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(frames -> frames.skip(2L).findFirst().map(f -> f.getDeclaringClass().getPackageName()).orElse(""))).isEmpty() && !callerClassName.startsWith("net.minecraft.")) {
            callback.setReturnValue((Object)true);
        }
    }
}

