/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishingHandler;

public class VanishUtil {
    public static final Set<UUID> VANISHED_PLAYERS = new HashSet<UUID>();
    public static final MutableComponent VANISHMOD_PREFIX = Component.literal((String)"").append((Component)Component.literal((String)"[").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"Vanishmod").withStyle(s -> s.applyFormat(ChatFormatting.GRAY).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/vanishmod")))).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.WHITE));

    public static boolean isVanished(Entity player) {
        return VanishUtil.isVanished(player, null);
    }

    public static boolean isVanished(Player player) {
        return VanishUtil.isVanished(player, null);
    }

    public static boolean isVanished(Entity potentialPlayer, Entity forPlayer) {
        if (potentialPlayer instanceof Player) {
            Player player = (Player)potentialPlayer;
            return VanishUtil.isVanished(player, forPlayer);
        }
        return false;
    }

    public static boolean isVanished(Player player, Entity forPlayer) {
        if (VANISHED_PLAYERS.isEmpty()) {
            return false;
        }
        if (player != null && !player.level().isClientSide) {
            boolean isVanished = VANISHED_PLAYERS.contains(player.getUUID());
            if (forPlayer != null) {
                return !VanishUtil.playerAllowedToSeeOther(forPlayer, (Entity)player, VanishUtil.isVanished(forPlayer), isVanished);
            }
            return isVanished;
        }
        return false;
    }

    public static boolean playerAllowedToSeeOther(Entity subject, Entity otherPlayer, boolean isSubjectVanished, boolean isOtherVanished) {
        if (subject.equals((Object)otherPlayer)) {
            return true;
        }
        return !isOtherVanished || VanishUtil.canSeeAllVanishedPlayers(subject, isSubjectVanished) || VanishUtil.checkTeamVisibility(subject, otherPlayer);
    }

    public static boolean canSeeAllVanishedPlayers(Entity entity, boolean isVanished) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return (Boolean)VanishConfig.CONFIG.vanishedPlayersSeeEachOther.get() != false && isVanished || (Integer)VanishConfig.CONFIG.seeVanishedPermissionLevel.get() >= 0 && player.hasPermissions(((Integer)VanishConfig.CONFIG.seeVanishedPermissionLevel.get()).intValue());
        }
        return false;
    }

    public static boolean checkTeamVisibility(Entity player, Entity otherPlayer) {
        if (!((Boolean)VanishConfig.CONFIG.seeVanishedTeamPlayers.get()).booleanValue()) {
            return false;
        }
        PlayerTeam team = player.getTeam();
        return team != null && team.canSeeFriendlyInvisibles() && team.getPlayers().contains(otherPlayer.getScoreboardName());
    }

    public static void recheckVanished(ServerPlayer player) {
        boolean isMarkedVanished = player.getPersistentData().getCompound("PlayerPersisted").getBoolean("Vanished");
        if (isMarkedVanished != VanishUtil.isVanished((Player)player)) {
            VanishingHandler.updateVanishedStatus(player, isMarkedVanished);
        }
    }

    public static List<? extends Entity> removeVanishedFromEntityList(List<? extends Entity> rawList, Entity forPlayer) {
        if (VANISHED_PLAYERS.isEmpty()) {
            return rawList;
        }
        return rawList.stream().filter(entity -> {
            Player player;
            return !(entity instanceof Player) || !VanishUtil.isVanished(player = (Player)entity, forPlayer);
        }).collect(Collectors.toList());
    }

    public static <T extends Player> List<T> removeVanishedFromPlayerList(List<T> rawList, Entity forPlayer) {
        if (VANISHED_PLAYERS.isEmpty()) {
            return rawList;
        }
        return rawList.stream().filter(player -> !VanishUtil.isVanished(player, forPlayer)).collect(Collectors.toList());
    }

    public static MutableComponent getVanishedStatusText(ServerPlayer player, boolean isVanished) {
        return Component.translatable((String)(isVanished ? (String)VanishConfig.CONFIG.onVanishQuery.get() : (String)VanishConfig.CONFIG.onUnvanishQuery.get()), (Object[])new Object[]{player.getDisplayName()});
    }

    public static ResourceKey<ChatType> getChatTypeRegistryKey(ChatType.Bound chatType, Player player) {
        return player.level().registryAccess().registryOrThrow(Registries.CHAT_TYPE).getResourceKey((Object)((ChatType)chatType.chatType().value())).orElse(ChatType.CHAT);
    }
}

