/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.Vanishmod;
import redstonedubstep.mods.vanishmod.api.PlayerVanishEvent;
import redstonedubstep.mods.vanishmod.compat.Mc2DiscordCompat;
import redstonedubstep.mods.vanishmod.misc.SoundSuppressionHelper;

public class VanishingHandler {
    private static final Set<String> vanishingQueue = new HashSet<String>();

    public static void toggleVanish(ServerPlayer player) {
        boolean vanishes = !VanishUtil.isVanished((Player)player);
        String note = "Note: You can still see yourself in the tab list for technical reasons, but you are vanished for other players. \nNote: Be careful when producing noise near other players, because while most sounds will get suppressed, some won't due to technical limitations. \nNote: While vanished, only players that are able to see you will receive your chat messages. If you want to chat with everyone, use the /say command.";
        if (vanishes) {
            player.sendSystemMessage((Component)VanishUtil.VANISHMOD_PREFIX.copy().append("Note: ").append((Component)Component.literal((String)"(...)").withStyle(s -> s.applyFormat(ChatFormatting.GRAY).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)note))))));
        }
        VanishingHandler.sendJoinOrLeaveMessageToPlayers(player.server.getPlayerList().getPlayers(), player, vanishes, false);
        VanishingHandler.updateVanishedStatus(player, vanishes);
        VanishingHandler.sendJoinOrLeaveMessageToPlayers(player.server.getPlayerList().getPlayers(), player, vanishes, true);
        VanishingHandler.sendPacketsOnVanish(player, player.serverLevel(), vanishes);
    }

    public static void sendPacketsOnVanish(ServerPlayer changingPlayer, ServerLevel world, boolean vanishes) {
        List list = world.getServer().getPlayerList().getPlayers();
        ServerChunkCache chunkProvider = changingPlayer.serverLevel().getChunkSource();
        for (ServerPlayer otherPlayer : list) {
            boolean otherPlayerVanished = VanishUtil.isVanished((Player)otherPlayer);
            boolean otherAllowedToSeeChanging = VanishUtil.playerAllowedToSeeOther((Entity)otherPlayer, (Entity)changingPlayer, otherPlayerVanished, vanishes);
            boolean changingAllowedToSeeOther = VanishUtil.playerAllowedToSeeOther((Entity)changingPlayer, (Entity)otherPlayer, vanishes, otherPlayerVanished);
            if (otherPlayer.equals((Object)changingPlayer)) continue;
            otherPlayer.connection.send((Packet)(otherAllowedToSeeChanging ? ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(changingPlayer)) : new ClientboundPlayerInfoRemovePacket(List.of(changingPlayer.getUUID()))));
            if (otherPlayerVanished) {
                changingPlayer.connection.send((Packet)(changingAllowedToSeeOther ? ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(otherPlayer)) : new ClientboundPlayerInfoRemovePacket(List.of(otherPlayer.getUUID()))));
            }
            if (!((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue()) continue;
            if (vanishes && !otherAllowedToSeeChanging) {
                otherPlayer.connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{changingPlayer.getId()}));
                continue;
            }
            if (vanishes || changingAllowedToSeeOther) continue;
            changingPlayer.connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{otherPlayer.getId()}));
        }
        if (chunkProvider.chunkMap.entityMap.containsKey(changingPlayer.getId())) {
            chunkProvider.chunkMap.entityMap.remove(changingPlayer.getId());
            chunkProvider.addEntity((Entity)changingPlayer);
        }
        changingPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)VanishUtil.getVanishedStatusText(changingPlayer, vanishes)));
        changingPlayer.refreshTabListName();
    }

    public static void sendJoinOrLeaveMessageToPlayers(List<ServerPlayer> playerList, ServerPlayer sender, boolean leaveMessage, boolean beforeStatusChange) {
        if (((Boolean)VanishConfig.CONFIG.sendFakeJoinLeaveMessages.get()).booleanValue() && leaveMessage != beforeStatusChange && sender.server.getPlayerList().getPlayers().contains(sender)) {
            MutableComponent message = Component.translatable((String)(leaveMessage ? "multiplayer.player.left" : "multiplayer.player.joined"), (Object[])new Object[]{sender.getDisplayName()}).withStyle(ChatFormatting.YELLOW);
            for (ServerPlayer receiver : playerList) {
                receiver.sendSystemMessage((Component)message);
            }
            if (Vanishmod.mc2discordDetected) {
                Mc2DiscordCompat.sendFakeJoinLeaveMessage(sender, leaveMessage);
            }
        }
    }

    public static void updateVanishedStatus(ServerPlayer player, boolean vanished) {
        CompoundTag persistentData = player.getPersistentData();
        CompoundTag deathPersistentData = persistentData.getCompound("PlayerPersisted");
        deathPersistentData.putBoolean("Vanished", vanished);
        persistentData.put("PlayerPersisted", (Tag)deathPersistentData);
        if (Vanishmod.mc2discordDetected) {
            Mc2DiscordCompat.hidePlayer(player, vanished);
        }
        VanishingHandler.updateVanishedPlayerList(player, vanished);
        NeoForge.EVENT_BUS.post((Event)new PlayerVanishEvent((Player)player, vanished));
    }

    public static void updateVanishedPlayerList(ServerPlayer player, boolean vanished) {
        if (vanished) {
            VanishUtil.VANISHED_PLAYERS.add(player.getUUID());
        } else {
            VanishUtil.VANISHED_PLAYERS.remove(player.getUUID());
        }
        SoundSuppressionHelper.updateVanishedPlayerMap(player, vanished);
    }

    public static boolean addToQueue(String playerName) {
        return vanishingQueue.add(playerName);
    }

    public static boolean removeFromQueue(String playerName) {
        return vanishingQueue.remove(playerName);
    }
}

