/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.misc.TraceHandler;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Shadow
    @Final
    public MinecraftServer server;

    public ServerPlayerMixin(Level world, BlockPos pos, float angle, GameProfile gameProfile) {
        super(world, pos, angle, gameProfile);
    }

    @Inject(method={"sendChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    public void vanishmod$onSendChatMessage(OutgoingChatMessage message, boolean filter, ChatType.Bound chatType, CallbackInfo callback) {
        if (message instanceof OutgoingChatMessage.Player) {
            OutgoingChatMessage.Player playerChatMessage = (OutgoingChatMessage.Player)message;
            ServerPlayer sender = this.server.getPlayerList().getPlayer(playerChatMessage.message().link().sender());
            ResourceKey<ChatType> chatTypeKey = VanishUtil.getChatTypeRegistryKey(chatType, this);
            if (VanishUtil.isVanished((Player)sender, (Entity)this)) {
                if (!((Boolean)VanishConfig.CONFIG.hideChatMessages.get()).booleanValue() || chatTypeKey != ChatType.CHAT && chatTypeKey != ChatType.TEAM_MSG_COMMAND_INCOMING) {
                    if (((Boolean)VanishConfig.CONFIG.hidePlayerNameInChat.get()).booleanValue()) {
                        MutableComponent replacement = Component.literal((String)((String)VanishConfig.CONFIG.vanishedPlayerNameReplacement.get()));
                        TraceHandler.trace((Player)sender, Component.literal((String)"Chat Message Sender (now \"").append((Component)replacement).append("\")"), message.content().getString());
                        chatType = ChatType.bind(chatTypeKey, (RegistryAccess)this.level().registryAccess(), (Component)replacement);
                    }
                    this.sendSystemMessage(chatType.decorate(playerChatMessage.content()));
                    callback.cancel();
                    return;
                }
                TraceHandler.trace((Player)sender, "Chat Message", message.content().getString());
                callback.cancel();
            }
        }
    }

    @Inject(method={"isSpectator"}, at={@At(value="HEAD")}, cancellable=true)
    public void vanishmod$onIsSpectator(CallbackInfoReturnable<Boolean> callback) {
        String callerClassName;
        if (((Boolean)VanishConfig.CONFIG.fixPlayerDetectionModCompatibility.get()).booleanValue() && VanishUtil.isVanished(this) && !(callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(frames -> frames.skip(2L).findFirst().map(f -> f.getDeclaringClass().getPackageName()).orElse(""))).isEmpty() && !callerClassName.startsWith("net.minecraft.")) {
            callback.setReturnValue((Object)true);
        }
    }
}

