/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.mixin.gui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.misc.FieldHolder;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    private ServerStatus status;

    @Shadow
    public abstract PlayerList getPlayerList();

    @Shadow
    public abstract boolean hidesOnlinePlayers();

    @Inject(method={"runServer", "tickServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;resetStatusCache(Lnet/minecraft/network/protocol/status/ServerStatus;)V")})
    private void vanishmod$onBuildServerStatus(CallbackInfo callbackInfo) {
        if (((Boolean)VanishConfig.CONFIG.hidePlayersFromPlayerLists.get()).booleanValue()) {
            ServerStatus.Players vanishedPlayerStatus;
            PlayerList list = this.getPlayerList();
            List unvanishedPlayers = VanishUtil.removeVanishedFromPlayerList(list.getPlayers(), null);
            int unvanishedPlayerCount = unvanishedPlayers.size();
            int maxPlayers = list.getMaxPlayers();
            ServerStatus mainServerStatus = this.status;
            if (this.hidesOnlinePlayers()) {
                vanishedPlayerStatus = new ServerStatus.Players(maxPlayers, unvanishedPlayerCount, List.of());
            } else {
                int playerSampleSize = Math.min(unvanishedPlayers.size(), 12);
                ObjectArrayList displayedPlayers = new ObjectArrayList(playerSampleSize);
                int offset = Mth.nextInt((RandomSource)this.random, (int)0, (int)(unvanishedPlayerCount - playerSampleSize));
                for (int l = 0; l < playerSampleSize; ++l) {
                    ServerPlayer player = (ServerPlayer)unvanishedPlayers.get(offset + l);
                    displayedPlayers.add((Object)(player.allowsListing() ? player.getGameProfile() : MinecraftServer.ANONYMOUS_PLAYER_PROFILE));
                }
                Util.shuffle((List)displayedPlayers, (RandomSource)this.random);
                vanishedPlayerStatus = new ServerStatus.Players(maxPlayers, unvanishedPlayerCount, (List)displayedPlayers);
            }
            if (mainServerStatus != null) {
                FieldHolder.vanishedServerStatus = new ServerStatus(mainServerStatus.description(), Optional.of(vanishedPlayerStatus), mainServerStatus.version(), mainServerStatus.favicon(), mainServerStatus.enforcesSecureChat(), mainServerStatus.isModded());
            }
        } else {
            FieldHolder.vanishedServerStatus = null;
        }
    }
}

