/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.collection;

import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.block.collection.BlockCollectionData;
import eu.pb4.polyfactory.block.collection.BlockCollectionView;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.AbstractElement;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_10182;
import net.minecraft.class_10264;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1313;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2716;
import net.minecraft.class_2739;
import net.minecraft.class_2784;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_8042;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockCollection
extends AbstractElement
implements class_1941 {
    public static boolean ignoreCollisions = false;
    private final DisplayElement main = ItemDisplayElementUtil.createSimple((class_1799)class_1799.field_8037, (int)2);
    private final int[] blockId;
    private final int[] collisionBlockId;
    private final int[] collisionBlockId2;
    private final IntList blockIdList = new IntArrayList();
    private final IntList allIdList = new IntArrayList();
    private final BlockCollectionData data;
    private final Quaternionf newQuaternion = class_2350.field_11036.method_23224();
    private final Quaternionf quaternion = class_2350.field_11036.method_23224();
    private float centerX;
    private float centerY;
    private float centerZ;
    @Nullable
    private class_3218 world;
    private boolean quaternionDirty = false;
    private boolean disableCollision;
    private Int2ObjectMap<class_243> previousShift = new Int2ObjectOpenHashMap();

    public BlockCollection(int sizeX, int sizeY, int sizeZ) {
        this(new BlockCollectionData(sizeX, sizeY, sizeZ));
    }

    public BlockCollection(BlockCollectionData data) {
        int size = data.size();
        this.blockId = new int[size];
        this.collisionBlockId = new int[size];
        this.collisionBlockId2 = new int[size];
        Arrays.fill(this.blockId, -1);
        Arrays.fill(this.collisionBlockId, -1);
        Arrays.fill(this.collisionBlockId2, -1);
        this.allIdList.add(this.main.getEntityId());
        this.data = data;
        for (int x = 0; x < data.sizeX(); ++x) {
            for (int y = 0; y < data.sizeY(); ++y) {
                for (int z = 0; z < data.sizeZ(); ++z) {
                    this.updateBlockVisualsAt(x, y, z, this.data.getBlockState(x, y, z));
                }
            }
        }
    }

    public void setCenter(float x, float y, float z) {
        this.centerX = x;
        this.centerY = y;
        this.centerZ = z;
    }

    public void startWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        this.main.startWatching(player, packetConsumer);
        class_243 pos = this.main.getLastSyncedPos();
        Vector3f vec = new Vector3f();
        Quaternionf quaternion = new Quaternionf((Quaternionfc)this.quaternion);
        for (int x = 0; x < this.data.sizeX(); ++x) {
            for (int y = 0; y < this.data.sizeY(); ++y) {
                for (int z = 0; z < this.data.sizeZ(); ++z) {
                    this.sendInitialBlockVisual(packetConsumer, x, y, z, pos, vec, quaternion);
                    this.sendInitialBlockCollision(packetConsumer, x, y, z, pos, vec, quaternion);
                }
            }
        }
        packetConsumer.accept((class_2596<class_2602>)VirtualEntityUtils.createRidePacket((int)this.main.getEntityId(), (IntList)this.blockIdList));
    }

    public void sendInitialBlockVisual(Consumer<class_2596<class_2602>> packetConsumer, int x, int y, int z, class_243 pos, Vector3f vec, Quaternionf quaternion) {
        int i = this.index(x, y, z);
        int id = this.blockId[i];
        if (id != -1) {
            packetConsumer.accept((class_2596<class_2602>)new class_2604(id, UUID.randomUUID(), pos.field_1352, pos.field_1351, pos.field_1350, 0.0f, 0.0f, class_1299.field_42460, 0, class_243.field_1353, 0.0));
            packetConsumer.accept((class_2596<class_2602>)new class_2739(id, List.of(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.INTERPOLATION_DURATION, (Object)1), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.Block.BLOCK_STATE, (Object)this.data.states()[i]), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.TRANSLATION, (Object)new Vector3f((float)x - 0.5f - this.centerX, (float)y - 0.5f - this.centerY, (float)z - 0.5f - this.centerZ).rotate((Quaternionfc)quaternion)), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.LEFT_ROTATION, (Object)quaternion), class_2945.class_7834.method_46360((class_2940)EntityTrackedData.FLAGS, (Object)((byte)(1 << EntityTrackedData.INVISIBLE_FLAG_INDEX))))));
        }
    }

    public void sendInitialBlockCollision(Consumer<class_2596<class_2602>> packetConsumer, int x, int y, int z, class_243 pos, Vector3f vec, Quaternionf quaternion) {
        int i = this.index(x, y, z);
        int id = this.collisionBlockId[i];
        if (id != -1) {
            vec.set((float)x - this.centerX, (float)y - this.centerY, (float)z - this.centerZ).rotate((Quaternionfc)quaternion);
            packetConsumer.accept((class_2596<class_2602>)new class_2604(id, UUID.randomUUID(), pos.field_1352 + (double)vec.x, pos.field_1351 + (double)vec.y - 0.5, pos.field_1350 + (double)vec.z, 0.0f, 0.0f, class_1299.field_6109, 0, class_243.field_1353, 0.0));
            packetConsumer.accept((class_2596<class_2602>)new class_2739(id, List.of(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.FLAGS, (Object)((byte)(1 << EntityTrackedData.INVISIBLE_FLAG_INDEX))))));
            packetConsumer.accept((class_2596<class_2602>)new class_2604(this.collisionBlockId2[i], UUID.randomUUID(), pos.field_1352 + (double)vec.x, pos.field_1351 + (double)vec.y - 0.5, pos.field_1350 + (double)vec.z, 0.0f, 0.0f, class_1299.field_42460, 0, class_243.field_1353, 0.0));
            packetConsumer.accept((class_2596<class_2602>)new class_2739(this.collisionBlockId2[i], List.of(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.FLAGS, (Object)((byte)(1 << EntityTrackedData.INVISIBLE_FLAG_INDEX))))));
            packetConsumer.accept((class_2596<class_2602>)VirtualEntityUtils.createRidePacket((int)this.collisionBlockId2[i], (IntList)IntList.of((int)id)));
        }
    }

    public void setQuaternion(Quaternionf quaternion) {
        if (!this.newQuaternion.equals((Object)quaternion)) {
            this.newQuaternion.set((Quaternionfc)quaternion);
            this.quaternionDirty = true;
        }
    }

    public class_243 getLastSyncedPos() {
        if (this.lastSyncedPos == null) {
            this.updateLastSyncedPos();
        }
        return this.lastSyncedPos;
    }

    public void setBlockState(int x, int y, int z, class_2680 state, @Nullable class_2586 blockEntity) {
        if (!this.data.setBlockState(x, y, z, state, blockEntity)) {
            return;
        }
        this.updateBlockVisualsAt(x, y, z, state);
    }

    public void updateBlockVisualsAt(int x, int y, int z, class_2680 state) {
        int i = this.index(x, y, z);
        if (this.blockId[i] == -1 && !state.method_26215()) {
            int e;
            this.blockId[i] = e = VirtualEntityUtils.requestEntityId();
            this.blockIdList.add(e);
            this.allIdList.add(e);
            class_243 pos = this.main.getLastSyncedPos();
            Vector3f vec = new Vector3f();
            Quaternionf quaternion = new Quaternionf((Quaternionfc)this.quaternion);
            if (this.getHolder() != null) {
                this.sendInitialBlockVisual(arg_0 -> ((ElementHolder)this.getHolder()).sendPacket(arg_0), x, y, z, pos, vec, quaternion);
            }
            if (!state.method_26220((class_1922)this, new class_2338(x, y, z)).method_1110()) {
                int e2 = VirtualEntityUtils.requestEntityId();
                int e3 = VirtualEntityUtils.requestEntityId();
                this.collisionBlockId[i] = e2;
                this.collisionBlockId2[i] = e3;
                this.allIdList.add(e2);
                this.allIdList.add(e3);
                if (this.getHolder() != null) {
                    this.sendInitialBlockCollision(arg_0 -> ((ElementHolder)this.getHolder()).sendPacket(arg_0), x, y, z, pos, vec, quaternion);
                }
            }
        } else if (state.method_26215()) {
            if (this.blockId[i] != -1) {
                this.blockIdList.removeInt(this.blockId[i]);
                this.allIdList.removeInt(this.blockId[i]);
            }
            if (this.collisionBlockId[i] != -1) {
                this.allIdList.removeInt(this.collisionBlockId[i]);
                this.allIdList.removeInt(this.collisionBlockId2[i]);
                if (this.getHolder() != null) {
                    this.getHolder().sendPacket((class_2596)new class_2716(IntList.of((int)this.blockId[i], (int)this.collisionBlockId[i], (int)this.collisionBlockId2[i])));
                }
            } else if (this.getHolder() != null && this.blockId[i] != -1) {
                this.getHolder().sendPacket((class_2596)new class_2716(IntList.of((int)this.blockId[i])));
            }
            this.collisionBlockId2[i] = -1;
            this.collisionBlockId[i] = -1;
            this.blockId[i] = -1;
        } else {
            boolean noCollision = state.method_26220((class_1922)this, new class_2338(x, y, z)).method_1110();
            if (this.getHolder() != null) {
                this.getHolder().sendPacket((class_2596)new class_2739(this.blockId[i], List.of(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.Block.BLOCK_STATE, (Object)this.data.states()[i]))));
            }
            if (this.collisionBlockId[i] != -1 && noCollision) {
                this.allIdList.removeInt(this.collisionBlockId[i]);
                this.allIdList.removeInt(this.collisionBlockId2[i]);
                if (this.getHolder() != null) {
                    this.getHolder().sendPacket((class_2596)new class_2716(IntList.of((int)this.collisionBlockId[i], (int)this.collisionBlockId2[i])));
                }
                this.collisionBlockId2[i] = 0;
                this.collisionBlockId[i] = 0;
            } else if (this.collisionBlockId[i] == -1 && !noCollision) {
                int e2 = VirtualEntityUtils.requestEntityId();
                int e3 = VirtualEntityUtils.requestEntityId();
                this.collisionBlockId[i] = e2;
                this.collisionBlockId2[i] = e3;
                this.allIdList.add(e2);
                this.allIdList.add(e3);
                if (this.getHolder() != null) {
                    class_243 pos = this.main.getLastSyncedPos();
                    Vector3f vec = new Vector3f();
                    Quaternionf quaternion = new Quaternionf((Quaternionfc)this.quaternion);
                    this.sendInitialBlockCollision(arg_0 -> ((ElementHolder)this.getHolder()).sendPacket(arg_0), x, y, z, pos, vec, quaternion);
                }
            }
        }
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        int i = this.index(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return i != -1 ? this.data.blockEntities()[i] : null;
    }

    public class_2680 method_8320(class_2338 pos) {
        return this.getBlockState(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2680 getBlockState(int x, int y, int z) {
        int i = this.index(x, y, z);
        return i != -1 ? this.data.states()[i] : class_2246.field_10243.method_9564();
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    private int index(int x, int y, int z) {
        return this.data.index(x, y, z);
    }

    public int method_31605() {
        return this.data.sizeY();
    }

    public int method_31607() {
        return 0;
    }

    public IntList getEntityIds() {
        return this.allIdList;
    }

    public void stopWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        this.main.stopWatching(player, packetConsumer);
    }

    public void notifyMove(class_243 oldPos, class_243 currentPos, class_243 delta) {
        this.main.notifyMove(oldPos, currentPos, delta);
    }

    public void tick() {
        Int2ObjectOpenHashMap newPreviousShift = new Int2ObjectOpenHashMap();
        if (this.quaternionDirty || !this.getCurrentPos().equals((Object)this.getLastSyncedPos())) {
            class_243 pos = this.getCurrentPos();
            class_243 previous = this.getLastSyncedPos();
            if (previous == null) {
                previous = pos;
            }
            Vector3f vec = new Vector3f();
            Vector3f vec2 = new Vector3f();
            ArrayList<Object> b = new ArrayList<Object>();
            class_238 box = new class_238(pos.field_1352 - (double)this.centerX - 2.0, pos.field_1351 - (double)this.centerY - 2.0, pos.field_1350 - (double)this.centerZ - 2.0, pos.field_1352 - (double)this.centerX + (double)this.data.sizeX() + 2.0, pos.field_1351 - (double)this.centerY + (double)this.data.sizeY() + 2.0, pos.field_1350 - (double)this.centerZ + (double)this.data.sizeZ() + 2.0);
            List ents = this.world != null ? this.world.method_8333(null, box, class_1301.field_6155) : List.of();
            Quaternionf quaternion = new Quaternionf((Quaternionfc)this.newQuaternion);
            Quaternionf quaternionOldInverted = new Quaternionf((Quaternionfc)this.quaternion).invert();
            class_243 diff = pos.method_1020(previous);
            this.disableCollision = true;
            IdentityHashMap<class_1297, Vector3f> idMap = new IdentityHashMap<class_1297, Vector3f>();
            for (int x = 0; x < this.data.sizeX(); ++x) {
                for (int y = 0; y < this.data.sizeY(); ++y) {
                    for (int z = 0; z < this.data.sizeZ(); ++z) {
                        int i = this.index(x, y, z);
                        int id = this.blockId[i];
                        if (id != -1) {
                            b.add(new class_2739(id, List.of(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.TRANSLATION, (Object)new Vector3f((float)x - 0.5f - this.centerX, (float)y - 0.5f - this.centerY, (float)z - 0.5f - this.centerZ).rotate((Quaternionfc)quaternion)), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.LEFT_ROTATION, (Object)quaternion), class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.START_INTERPOLATION, (Object)0))));
                        }
                        if ((id = this.collisionBlockId2[i]) == -1) continue;
                        vec.set((float)x - this.centerX, (float)y - this.centerY, (float)z - this.centerZ);
                        vec.rotate((Quaternionfc)this.newQuaternion);
                        b.add(new class_10264(id, new class_10182(new class_243(pos.field_1352 + (double)vec.x, pos.field_1351 + (double)vec.y - 0.5, pos.field_1350 + (double)vec.z), class_243.field_1353, 0.0f, 0.0f), false));
                        vec2.set((float)x - this.centerX, (float)y - this.centerY, (float)z - this.centerZ);
                        vec2.rotate((Quaternionfc)this.quaternion);
                        for (class_1297 entity2 : ents) {
                            if (!entity2.method_5829().method_1003(previous.field_1352 + (double)vec2.x - 0.5 - 0.05, previous.field_1351 + (double)vec2.y - 0.5 - 0.05, previous.field_1350 + (double)vec2.z - 0.5 - 0.05, previous.field_1352 + (double)vec2.x + 0.5 + 0.05, previous.field_1351 + (double)vec2.y + 0.5 + 0.25, previous.field_1350 + (double)vec2.z + 0.5 + 0.05)) continue;
                            Vector3f evec = idMap.computeIfAbsent(entity2, a -> new Vector3f());
                            vec.sub((Vector3fc)vec2);
                            evec.y = Math.max(evec.y, vec.y);
                            vec.set(entity2.method_23317() - previous.method_10216(), entity2.method_23318() - previous.method_10214(), entity2.method_23321() - previous.method_10215());
                            vec.rotate((Quaternionfc)quaternionOldInverted);
                            vec.rotate((Quaternionfc)quaternion);
                            evec.x = (float)((double)vec.x - entity2.method_23317() + previous.method_10216());
                            evec.z = (float)((double)vec.z - entity2.method_23321() + previous.method_10215());
                        }
                    }
                }
            }
            idMap.forEach((entity, val) -> {
                class_243 move = diff.method_1031((double)val.x, (double)val.y, (double)val.z);
                if (!(class_3532.method_20390((double)move.field_1352, (double)0.0) && class_3532.method_20390((double)move.field_1351, (double)0.0) && class_3532.method_20390((double)move.field_1350, (double)0.0))) {
                    entity.method_5784(class_1313.field_6309, move);
                    if (entity instanceof class_3222) {
                        class_3222 player = (class_3222)entity;
                        FactoryUtil.runNextTick(() -> player.field_13987.method_14360(new class_10182(move.method_1031(0.0, player.method_56989(), 0.0), class_243.field_1353, 0.0f, 0.0f), EnumSet.of(class_2709.field_12400, new class_2709[]{class_2709.field_12398, class_2709.field_12403, class_2709.field_54090, class_2709.field_54091, class_2709.field_54092, class_2709.field_12401, class_2709.field_12397})));
                    }
                }
            });
            this.disableCollision = false;
            if (this.getHolder() != null) {
                this.getHolder().sendPacket((class_2596)new class_8042(b));
            }
            this.quaternion.set((Quaternionfc)this.newQuaternion);
            this.updateLastSyncedPos();
        }
        if (this.world != null) {
            this.previousShift.forEach((entity, val) -> {
                class_1297 patt0$temp = this.world.method_8469(entity.intValue());
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    class_243 class_2432 = (class_243)this.previousShift.getOrDefault(player.method_5628(), (Object)class_243.field_1353);
                }
            });
        }
        this.previousShift = newPreviousShift;
        this.main.tick();
    }

    public void setHolder(ElementHolder holder) {
        super.setHolder(holder);
        this.main.setHolder(holder);
    }

    public void setWorld(class_3218 world) {
        if (this.world == world) {
            return;
        }
        if (this.world != null) {
            ((BlockCollectionView)this.world).polyfactory$removeCollision(this);
        }
        if (world != null) {
            ((BlockCollectionView)world).polyfactory$addCollision(this);
        }
        this.world = world;
    }

    public void setInitialPosition(class_243 newPos) {
        super.setInitialPosition(newPos);
        this.main.setInitialPosition(newPos);
    }

    public void setOffset(class_243 offset) {
        super.setOffset(offset);
        this.main.setOffset(offset);
    }

    @Nullable
    public void setOverridePos(class_243 vec3d) {
        super.setOverridePos(vec3d);
        this.main.setOverridePos(vec3d);
    }

    public class_2784 method_8621() {
        return new class_2784();
    }

    @Nullable
    public class_1922 method_22338(int chunkX, int chunkZ) {
        return this;
    }

    public void provideCollisions(class_238 box, Consumer<class_265> consumer) {
        if (this.disableCollision || ignoreCollisions) {
            return;
        }
        class_243 pos = this.main.getLastSyncedPos();
        if (!box.method_1003(pos.field_1352 - (double)this.centerX - 2.0, pos.field_1351 - (double)this.centerY - 2.0, pos.field_1350 - (double)this.centerZ - 2.0, pos.field_1352 - (double)this.centerX + (double)this.data.sizeX() + 2.0, pos.field_1351 - (double)this.centerY + (double)this.data.sizeY() + 2.0, pos.field_1350 - (double)this.centerZ + (double)this.data.sizeZ() + 2.0)) {
            return;
        }
        Vector3f vec = new Vector3f();
        for (int x = 0; x < this.data.sizeX(); ++x) {
            for (int y = 0; y < this.data.sizeY(); ++y) {
                for (int z = 0; z < this.data.sizeZ(); ++z) {
                    vec.set((float)x - this.centerX, (float)y - this.centerY, (float)z - this.centerZ).rotate((Quaternionfc)this.quaternion);
                    if (this.collisionBlockId2[this.index(x, y, z)] == -1 || !box.method_1003(pos.field_1352 + (double)vec.x - 0.5, pos.field_1351 + (double)vec.y - 0.5, pos.field_1350 + (double)vec.z - 0.5, pos.field_1352 + (double)vec.x + 0.5, pos.field_1351 + (double)vec.y + 0.5, pos.field_1350 + (double)vec.z + 0.5)) continue;
                    consumer.accept(class_259.method_1081((double)(pos.field_1352 + (double)vec.x - 0.5), (double)(pos.field_1351 + (double)vec.y - 0.5), (double)(pos.field_1350 + (double)vec.z - 0.5), (double)(pos.field_1352 + (double)vec.x + 0.5), (double)(pos.field_1351 + (double)vec.y + 0.5), (double)(pos.field_1350 + (double)vec.z + 0.5)));
                }
            }
        }
    }

    public List<class_265> method_20743(@Nullable class_1297 entity, class_238 box) {
        ArrayList<class_265> arr = new ArrayList<class_265>();
        this.provideCollisions(box, arr::add);
        return arr;
    }
}

