/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.collection;

import net.minecraft.class_2246;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public record BlockCollectionData(int sizeX, int sizeY, int sizeZ, class_2680[] states, class_2586[] blockEntities) {
    public BlockCollectionData(int x, int y, int z) {
        this(x, y, z, new class_2680[x * y * z], new class_2586[x * y * z]);
    }

    public int size() {
        return this.sizeX * this.sizeY * this.sizeZ;
    }

    public int index(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.sizeX && y < this.sizeY && z < this.sizeZ ? (x + y * this.sizeX) * this.sizeZ + z : -1;
    }

    public boolean setBlockState(int x, int y, int z, class_2680 state) {
        return this.setBlockState(x, y, z, state, null);
    }

    public boolean setBlockState(int x, int y, int z, class_2680 state, @Nullable class_2586 blockEntity) {
        int i = this.index(x, y, z);
        if (i == -1) {
            return false;
        }
        if (this.states[i] == state) {
            this.blockEntities[i] = blockEntity;
            return false;
        }
        this.states[i] = state;
        this.blockEntities[i] = blockEntity;
        return true;
    }

    public class_2680 getBlockState(int x, int y, int z) {
        int index = this.index(x, y, z);
        if (index == -1) {
            return class_2246.field_10124.method_9564();
        }
        class_2680 state = this.states[index];
        if (state == null) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public static BlockCollectionData createDebug() {
        int x;
        BlockCollectionData data = new BlockCollectionData(9, 9, 9);
        for (int y = 0; y < 4; ++y) {
            data.setBlockState(4, y, 4, class_2246.field_10340.method_9564(), null);
        }
        for (x = 0; x <= 8; ++x) {
            data.setBlockState(x, 3, 4, class_2246.field_10375.method_9564(), null);
            data.setBlockState(4, 3, x, class_2246.field_10375.method_9564(), null);
        }
        for (x = 2; x <= 6; ++x) {
            for (int z = 2; z <= 6; ++z) {
                data.setBlockState(x, 3, z, class_2246.field_10033.method_9564(), null);
            }
            data.setBlockState(2, 4, x, class_2246.field_10033.method_9564(), null);
            data.setBlockState(6, 4, x, class_2246.field_10033.method_9564(), null);
            data.setBlockState(x, 4, 2, class_2246.field_10033.method_9564(), null);
            data.setBlockState(x, 4, 6, class_2246.field_10033.method_9564(), null);
        }
        data.setBlockState(4, 5, 4, class_2246.field_10336.method_9564(), null);
        return data;
    }
}

