/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.creative;

import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.GuiUtils;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7225;

public class CreativeMotorBlockEntity
extends LockableBlockEntity {
    private double speed;
    private double stress;

    public CreativeMotorBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.CREATIVE_MOTOR, pos, state);
    }

    protected void createGui(class_3222 playerEntity) {
        new Gui(playerEntity);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        nbt.method_10549("Speed", this.speed);
        nbt.method_10549("Stress", this.stress);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        this.speed = nbt.method_68563("Speed", 0.0);
        this.stress = nbt.method_68563("Stress", 0.0);
    }

    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 serverWorld, class_2338 pos) {
        if (this.stress > 0.0) {
            modifier.provide(this.speed, this.stress, false);
        } else {
            modifier.stress(-this.stress);
        }
    }

    private class Gui
    extends SimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.setTitle(GuiTextures.FILL3.apply(CreativeMotorBlockEntity.this.getName()));
            this.updateNumbers();
            this.setSlot(1, GuiTextures.MINUS_BUTTON.get().unbreakable().setCallback(clickType -> {
                CreativeMotorBlockEntity.this.speed = Math.max(CreativeMotorBlockEntity.this.speed - (double)(clickType.shift ? 10 : 1), 0.0);
                CreativeMotorBlockEntity.this.method_5431();
            }));
            this.setSlot(7, GuiTextures.PLUS_BUTTON.get().unbreakable().setCallback(clickType -> {
                CreativeMotorBlockEntity.this.speed = Math.min(CreativeMotorBlockEntity.this.speed + (double)(clickType.shift ? 10 : 1), 9000.0);
                CreativeMotorBlockEntity.this.method_5431();
            }));
            this.setSlot(19, GuiTextures.MINUS_BUTTON.get().setCallback(clickType -> {
                CreativeMotorBlockEntity.this.stress = Math.max(CreativeMotorBlockEntity.this.stress - (double)(clickType.shift ? 10 : 1), -1000.0);
                CreativeMotorBlockEntity.this.method_5431();
            }));
            this.setSlot(25, GuiTextures.PLUS_BUTTON.get().setCallback(clickType -> {
                CreativeMotorBlockEntity.this.stress = Math.min(CreativeMotorBlockEntity.this.stress + (double)(clickType.shift ? 10 : 1), 99999.0);
                CreativeMotorBlockEntity.this.method_5431();
            }));
            this.open();
        }

        private void updateNumbers() {
            GuiUtils.drawFlatNumbers((SlotGuiInterface)this, 2, (int)CreativeMotorBlockEntity.this.speed, 5, class_124.field_1063.method_532(), false);
            GuiUtils.drawFlatNumbers((SlotGuiInterface)this, 20, (int)CreativeMotorBlockEntity.this.stress, 5, CreativeMotorBlockEntity.this.stress < 0.0 ? class_124.field_1079.method_532() : class_124.field_1063.method_532(), false);
        }

        public void onTick() {
            this.updateNumbers();
            super.onTick();
        }
    }
}

