/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.block.data.CableConnectable;
import eu.pb4.polyfactory.block.data.CableNetworkBlock;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.util.ColoredItem;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.nodes.generic.SelectiveSideNode;
import eu.pb4.polyfactory.util.ColorProvider;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiPredicate;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class AbstracterCableBlock
extends CableNetworkBlock
implements class_2343,
CableConnectable {
    public static final int DEFAULT_COLOR = 0xBBBBBB;

    public AbstracterCableBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (stack.method_31573(ConventionalItemTags.DYES) && this.setColor(state, world, pos, FactoryItems.CABLE.downSampleColor(DyeColorExtra.getColor(stack)))) {
            if (!player.method_68878()) {
                stack.method_7934(1);
            }
            world.method_45447(null, pos, class_3417.field_28391, class_3419.field_15245);
            return class_1269.field_52422;
        }
        if (stack.method_31574(FactoryItems.TREATED_DRIED_KELP) && this.setColor(state, world, pos, 0xBBBBBB)) {
            world.method_45447(null, pos, class_3417.field_28391, class_3419.field_15245);
            return class_1269.field_52422;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        ColorProvider be;
        class_1799 stack = super.method_9574(world, pos, state, includeData);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider && !(be = (ColorProvider)class_25862).isDefaultColor()) {
            ColoredItem.setColor(stack, be.getColor());
        }
        return stack;
    }

    public boolean setColor(class_2680 state, class_1937 world, class_2338 pos, int color) {
        ColorProvider provider;
        color = FactoryItems.CABLE.downSampleColor(color);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider && (provider = (ColorProvider)class_25862).getColor() != color) {
            provider.setColor(color);
            return true;
        }
        return false;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider) {
            ColorProvider be = (ColorProvider)class_25862;
            if (itemStack.method_7909() instanceof ColoredItem) {
                be.setColor(FactoryItems.CABLE.getItemColor(itemStack));
            }
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public static int getColor(class_4538 world, class_2338 pos) {
        int n;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider) {
            ColorProvider be = (ColorProvider)class_25862;
            n = be.getColor();
        } else {
            n = 0xBBBBBB;
        }
        return n;
    }

    protected boolean canConnectTo(class_4538 world, int ownColor, class_2338 neighborPos, class_2680 neighborState, class_2350 direction) {
        CableConnectable connectable;
        class_2248 class_22482 = neighborState.method_26204();
        return class_22482 instanceof CableConnectable && (connectable = (CableConnectable)class_22482).canCableConnect(world, ownColor, neighborPos, neighborState, direction);
    }

    @Override
    public Collection<BlockNode> createDataNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SelectiveSideNode(this.getDirections(state)));
    }

    @Override
    public Collection<BlockNode> createEnergyNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SelectiveSideNode(this.getDirections(state)));
    }

    public abstract EnumSet<class_2350> getDirections(class_2680 var1);

    protected abstract boolean isDirectionBlocked(class_2680 var1, class_2350 var2);

    @Override
    public boolean canCableConnect(class_4538 world, int cableColor, class_2338 pos, class_2680 state, class_2350 dir) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider) {
            ColorProvider be = (ColorProvider)class_25862;
            return be.getColor() == cableColor || be.isDefaultColor() || cableColor == 0xBBBBBB;
        }
        return true;
    }

    public boolean hasCable(class_2680 state) {
        return true;
    }

    protected abstract boolean checkModelDirection(class_2680 var1, class_2350 var2);

    public static class BaseCableModel
    extends BlockModel {
        private final ItemDisplayElement cable = ItemDisplayElementUtil.createSimple();
        private int color = 0xBBBBBB;
        private class_2680 state;

        public BaseCableModel(class_2680 state) {
            this.cable.setViewRange(0.5f);
            this.state = state;
            this.updateModel();
            if (((AbstracterCableBlock)state.method_26204()).hasCable(state)) {
                this.addElement((VirtualElement)this.cable);
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockAwareAttachment.BLOCK_STATE_UPDATE) {
                this.setState(this.blockState());
            }
        }

        protected void setState(class_2680 blockState) {
            this.state = blockState;
            if (this.hasCable(this.state)) {
                this.addElement((VirtualElement)this.cable);
            } else {
                this.removeElement((VirtualElement)this.cable);
            }
            this.updateModel();
        }

        protected final boolean hasCable(class_2680 state) {
            return ((AbstracterCableBlock)state.method_26204()).hasCable(state);
        }

        protected void updateModel() {
            class_1799 stack = this.getModel(this.state, ((AbstracterCableBlock)this.state.method_26204())::checkModelDirection);
            stack.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(), (List)IntList.of((int)this.color)));
            this.cable.setItem(stack);
            if (this.cable.getHolder() == this && this.color >= 0) {
                this.cable.tick();
            }
        }

        public void setColor(int color) {
            this.color = color;
            this.updateModel();
        }

        public class_1799 getModel(class_2680 state, BiPredicate<class_2680, class_2350> directionPredicate) {
            return FactoryModels.COLORED_CABLE.get(state, directionPredicate).method_7972();
        }
    }
}

