/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data.providers;

import com.kneelawk.graphlib.api.graph.NodeHolder;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.data.DataProvider;
import eu.pb4.polyfactory.block.data.providers.RecordPlayerBlock;
import eu.pb4.polyfactory.block.data.util.ChanneledDataBlockEntity;
import eu.pb4.polyfactory.block.data.util.ChanneledDataCache;
import eu.pb4.polyfactory.data.CapacityData;
import eu.pb4.polyfactory.nodes.FactoryNodes;
import eu.pb4.polyfactory.nodes.data.SpeakerNode;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.SingleStackInventory;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import net.minecraft.class_9792;
import net.minecraft.class_9793;
import org.jetbrains.annotations.Nullable;

public class RecordPlayerBlockEntity
extends ChanneledDataBlockEntity
implements SingleStackInventory,
ChanneledDataCache,
BlockEntityExtraListener {
    private final List<class_243> speakers = new ArrayList<class_243>();
    private class_1799 stack = class_1799.field_8037;
    private long ticksSinceSongStarted = 0L;
    @Nullable
    private class_6880<class_9793> song = null;
    private RecordPlayerBlock.Model model;
    private float volume = 1.0f;

    public RecordPlayerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(FactoryBlockEntities.RECORD_PLAYER, blockPos, blockState);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (t instanceof RecordPlayerBlockEntity) {
                RecordPlayerBlockEntity be = (RecordPlayerBlockEntity)t;
                be.tick(serverWorld, pos, state);
            }
        }
    }

    @Override
    public class_1799 getStack() {
        return this.stack;
    }

    @Override
    public void setStack(class_1799 stack) {
        this.stack = stack;
        class_9792 song = (class_9792)stack.method_58694(class_9334.field_52175);
        this.stopPlaying();
        if (song != null) {
            this.startPlaying((class_6880<class_9793>)((class_6880)song.comp_2833().method_60739((class_7225.class_7874)this.field_11863.method_30349()).get()));
        } else {
            DataProvider.sendData((class_4538)this.field_11863, this.field_11867, CapacityData.ZERO);
        }
        this.method_5431();
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        class_1799 newStack = FactoryUtil.fromNbtStack(lookup, (class_2520)nbt.method_68568("stack"));
        if (!class_1799.method_31577((class_1799)newStack, (class_1799)this.stack) || newStack.method_7960()) {
            this.stopPlaying();
        }
        this.stack = newStack;
        if (nbt.method_10545("ticks_since_song_started")) {
            class_9793.method_60753((class_7225.class_7874)lookup, (class_1799)this.stack).ifPresent(song -> this.setValues((class_6880<class_9793>)song, nbt.method_68080("ticks_since_song_started", 0L)));
        }
        this.volume = nbt.method_10545("volume") ? nbt.method_66563("volume", 0.0f) : 1.0f;
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        if (!this.stack.method_7960()) {
            nbt.method_10566("stack", this.stack.method_57358(lookup));
        }
        if (this.song != null) {
            nbt.method_10544("ticks_since_song_started", this.ticksSinceSongStarted);
        }
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.stack.method_7960() && stack.method_57826(class_9334.field_52175);
    }

    public boolean method_49104(class_1263 hopperInventory, int slot, class_1799 stack) {
        return hopperInventory.method_43256(class_1799::method_7960);
    }

    public int method_5444() {
        return 1;
    }

    private void tick(class_3218 serverWorld, class_2338 pos, class_2680 state) {
        if (this.song != null) {
            if (((class_9793)this.song.comp_349()).method_60751(this.ticksSinceSongStarted)) {
                DataProvider.sendData((class_4538)serverWorld, pos, new CapacityData(((class_9793)this.song.comp_349()).method_60750(), ((class_9793)this.song.comp_349()).method_60750()));
                this.stopPlaying();
            } else {
                Object object;
                DataProvider.sendData((class_4538)serverWorld, pos, new CapacityData(this.ticksSinceSongStarted, ((class_9793)this.song.comp_349()).method_60750()));
                Optional nodes = FactoryNodes.DATA.getGraphWorld(serverWorld).getNodesAt(pos).findFirst();
                if (nodes.isEmpty()) {
                    ++this.ticksSinceSongStarted;
                    return;
                }
                Collection speakers = ((NodeHolder)nodes.get()).getGraph().getCachedNodes(SpeakerNode.CACHE);
                this.speakers.clear();
                for (NodeHolder speaker : speakers) {
                    if (((SpeakerNode)speaker.getNode()).channel() != this.channel()) continue;
                    this.speakers.add(class_243.method_24953((class_2382)speaker.getBlockPos()).method_43206(((SpeakerNode)speaker.getNode()).facing(), 0.6));
                }
                if (this.hasSecondPassed()) {
                    serverWorld.method_43276((class_6880)class_5712.field_39485, this.field_11867, class_5712.class_7397.method_43287((class_2680)state));
                    float f = (float)serverWorld.method_8409().method_43048(4) / 24.0f;
                    object = this.speakers.iterator();
                    while (object.hasNext()) {
                        class_243 speaker = (class_243)object.next();
                        serverWorld.method_65096((class_2394)class_2398.field_11224, speaker.field_1352, speaker.field_1351, speaker.field_1350, 0, (double)f, 0.0, 0.0, 1.0);
                    }
                }
                if (this.model != null) {
                    this.model.updatePosition(this.speakers, this.volume);
                }
                if (!this.speakers.isEmpty() && this.ticksSinceSongStarted == 5L && (object = FactoryUtil.getClosestPlayer(this.field_11863, pos, 32.0)) instanceof class_3222) {
                    class_3222 player = (class_3222)object;
                    TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.CONNECT_RECORD_PLAYER_AND_SPEAKERS);
                }
                ++this.ticksSinceSongStarted;
            }
        }
    }

    public void setValues(class_6880<class_9793> song, long ticksPlaying) {
        if (!((class_9793)song.comp_349()).method_60751(ticksPlaying)) {
            this.song = song;
            this.ticksSinceSongStarted = ticksPlaying;
        }
    }

    public void startPlaying(class_6880<class_9793> song) {
        this.song = song;
        this.ticksSinceSongStarted = 0L;
        assert (this.field_11863 != null);
        DataProvider.sendData((class_4538)this.field_11863, this.field_11867, new CapacityData(0L, ((class_9793)this.song.comp_349()).method_60750()));
        if (this.model != null) {
            this.model.startPlaying();
            this.model.updatePosition(this.speakers, this.volume);
            this.model.playSoundIfActive((class_6880<class_3414>)((class_9793)song.comp_349()).comp_2835());
        }
        this.method_5431();
    }

    public void stopPlaying() {
        if (this.song != null) {
            this.song = null;
            this.ticksSinceSongStarted = 0L;
            if (this.model != null) {
                this.model.stopPlaying();
            }
            this.method_5431();
        }
    }

    private boolean hasSecondPassed() {
        return this.ticksSinceSongStarted % 20L == 0L;
    }

    @Override
    public void onListenerUpdate(class_2818 chunk) {
        this.model = (RecordPlayerBlock.Model)Objects.requireNonNull(BlockBoundAttachment.get((class_2818)chunk, (class_2338)this.field_11867)).holder();
        super.onListenerUpdate(chunk);
    }
}

