/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.DrainBlock;
import eu.pb4.polyfactory.block.fluids.FluidInputOutput;
import eu.pb4.polyfactory.fluid.FactoryFluids;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class DrainBlockEntity
extends class_2586
implements FluidInputOutput.ContainerBased,
BlockEntityExtraListener {
    public static final long CAPACITY = 81000L;
    private final FluidContainerImpl container = new FluidContainerImpl(81000L, this::onFluidChanged);
    private class_1799 catalyst = class_1799.field_8037;
    @Nullable
    private DrainBlock.Model model;

    public DrainBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.DRAIN, pos, state);
    }

    public DrainBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public FluidContainer getFluidContainer() {
        return this.container;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("fluid", this.container.toNbt(registryLookup));
        if (!this.catalyst.method_7960()) {
            nbt.method_10566("catalyst", this.catalyst.method_57358(registryLookup));
        }
        this.updateModel();
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.container.fromNbt(registryLookup, nbt, "fluid");
        this.setCatalyst(FactoryUtil.fromNbtStack(registryLookup, (class_2520)nbt.method_68568("catalyst")));
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        FluidComponent f = (FluidComponent)components.method_58694(FactoryDataComponents.FLUID);
        if (f != null) {
            this.container.clear();
            f.extractTo(this.container);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(FactoryDataComponents.FLUID, (Object)FluidComponent.copyFrom(this.container));
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551("fluid");
    }

    @Override
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.container;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.container;
    }

    private void onFluidChanged() {
        this.method_5431();
        this.updateModel();
    }

    private void updateModel() {
        if (this.model != null) {
            this.model.setFluid(this.container.topFluid(), this.container.getFilledPercentage());
            this.model.setCatalyst(this.catalyst);
        }
    }

    public void onListenerUpdate(class_2818 chunk) {
        ElementHolder elementHolder;
        BlockAwareAttachment x = BlockAwareAttachment.get((class_2818)chunk, (class_2338)this.field_11867);
        if (x != null && (elementHolder = x.holder()) instanceof DrainBlock.Model) {
            DrainBlock.Model model;
            this.model = model = (DrainBlock.Model)elementHolder;
            this.updateModel();
        }
    }

    public class_1799 catalyst() {
        return this.catalyst;
    }

    public void setCatalyst(class_1799 catalyst) {
        this.catalyst = catalyst;
        if (this.model != null) {
            this.model.setCatalyst(this.catalyst);
        }
        this.method_5431();
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        if (this.field_11863 != null) {
            class_1264.method_17349((class_1937)this.field_11863, (class_2338)pos, (class_2371)class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[]{this.catalyst}));
        }
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (!(t instanceof DrainBlockEntity)) {
            return;
        }
        DrainBlockEntity be = (DrainBlockEntity)t;
        if (world.method_8520(pos.method_10084())) {
            be.container.insert(FactoryFluids.WATER.defaultInstance(), 8L, false);
        }
    }
}

