/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.block.BlockHeat;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.FluidInputOutput;
import eu.pb4.polyfactory.block.fluids.PortableFluidTankBlock;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class PortableFluidTankBlockEntity
extends class_2586
implements FluidInputOutput.ContainerBased,
BlockEntityExtraListener {
    public static final long CAPACITY = 324000L;
    private final FluidContainerImpl container = new FluidContainerImpl(324000L, this::onFluidChanged);
    private float blockTemperature = 0.0f;
    @Nullable
    private PortableFluidTankBlock.Model model;

    public PortableFluidTankBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.PORTABLE_FLUID_TANK, pos, state);
    }

    public FluidContainer getFluidContainer() {
        return this.container;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("fluid", this.container.toNbt(registryLookup));
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.container.fromNbt(registryLookup, nbt, "fluid");
        if (this.model != null) {
            this.model.setFluid(this.container);
        }
    }

    public void method_57568(class_9473 components) {
        super.method_57568(components);
        FluidComponent f = (FluidComponent)components.method_58694(FactoryDataComponents.FLUID);
        if (f != null) {
            this.container.clear();
            f.extractTo(this.container);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(FactoryDataComponents.FLUID, (Object)FluidComponent.copyFrom(this.container));
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551("fluid");
    }

    @Override
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.method_11010().method_11654(PortableFluidTankBlock.FACING) == direction ? this.container : null;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.container;
    }

    private void onFluidChanged() {
        this.method_5431();
        if (this.model != null) {
            this.model.setFluid(this.container);
        }
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (!(t instanceof PortableFluidTankBlockEntity)) {
            return;
        }
        PortableFluidTankBlockEntity tank = (PortableFluidTankBlockEntity)t;
        tank.blockTemperature = BlockHeat.getReceived(world, pos) + tank.container.fluidTemperature();
        FluidContainerUtil.tick((FluidContainer)tank.container, (class_3218)world, pos, tank.blockTemperature, tank::dropItem);
    }

    private void dropItem(class_1799 stack) {
        class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.5), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)stack);
    }

    public void onListenerUpdate(class_2818 chunk) {
        ElementHolder elementHolder;
        BlockAwareAttachment x = BlockAwareAttachment.get((class_2818)chunk, (class_2338)this.field_11867);
        if (x != null && (elementHolder = x.holder()) instanceof PortableFluidTankBlock.Model) {
            PortableFluidTankBlock.Model model;
            this.model = model = (PortableFluidTankBlock.Model)elementHolder;
            this.model.setFluid(this.container);
        }
    }
}

