/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.smeltery;

import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.smeltery.CastingCauldronBlockEntity;
import eu.pb4.polyfactory.block.fluids.smeltery.FaucedBlock;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.casting.CauldronCastingRecipe;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.virtualentity.api.BlockWithElementHolder;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_811;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class CastingCauldronBlock
extends class_2248
implements PolymerBlock,
BlockWithElementHolder,
class_2343 {
    public CastingCauldronBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CastingCauldronBlockEntity(pos, state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return super.method_9605(ctx);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world instanceof class_3218 && type == FactoryBlockEntities.CASTING_CAULDRON ? CastingCauldronBlockEntity::ticker : null;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        CastingCauldronBlockEntity be;
        class_2586 class_25862;
        if (!player.method_21823() && (class_25862 = world.method_8321(pos)) instanceof CastingCauldronBlockEntity && !(be = (CastingCauldronBlockEntity)class_25862).getStack().method_7960()) {
            if (player.method_6047().method_7960()) {
                player.method_5673(class_1304.field_6173, be.method_5438(1));
            } else {
                player.method_64399(be.method_5438(1));
            }
            be.setStack(class_1799.field_8037);
            world.method_8501(pos, class_2246.field_10593.method_9564());
            return class_1269.field_52422;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    public class_1269 tryCauldronCasting(class_3218 world, class_2338 pos, FaucedBlock.FaucedProvider provider) {
        Optional recipe = world.method_64577().method_8132(FactoryRecipeTypes.CASTING_CAULDRON, (class_9695)provider.getFluidContainerInput(), (class_1937)world);
        if (recipe.isEmpty()) {
            return class_1269.field_5814;
        }
        world.method_8501(pos, this.method_9564());
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof CastingCauldronBlockEntity) {
            CastingCauldronBlockEntity be = (CastingCauldronBlockEntity)class_25862;
            be.setup((class_8786<CauldronCastingRecipe>)((class_8786)recipe.get()), provider);
        }
        return class_1269.field_52422;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, initialBlockState);
    }

    public class_2680 getPolymerBlockState(class_2680 blockState, PacketContext packetContext) {
        return class_2246.field_10593.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10593.method_9564();
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return class_1802.field_8638.method_7854();
    }

    public static final class Model
    extends RotationAwareModel {
        private final ItemDisplayElement fluid = LodItemDisplayElement.createSimple();
        private final ItemDisplayElement output;
        private double progress;
        private FluidInstance<?> castingFluid;
        private boolean isCooling;

        private Model(class_3218 world, class_2680 state) {
            this.fluid.setViewRange(0.4f);
            this.fluid.setScale((Vector3fc)new Vector3f(0.75f));
            this.fluid.setOffset(new class_243(0.0, -0.00390625, 0.0));
            this.output = LodItemDisplayElement.createSimple();
            this.output.setItemDisplayContext(class_811.field_4315);
            this.output.setViewRange(0.6f);
            this.output.setScale((Vector3fc)new Vector3f(0.75f));
            this.output.setOffset(new class_243(0.0, 0.125, 0.0));
            this.updateStatePos(state);
            this.addElement((VirtualElement)this.fluid);
            this.addElement((VirtualElement)this.output);
        }

        private void updateStatePos(class_2680 state) {
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }

        public void setProgress(boolean isCooling, double process, FluidInstance<?> castingFluid) {
            if (this.progress == process && this.castingFluid == castingFluid && this.isCooling == isCooling) {
                return;
            }
            if (castingFluid == null) {
                this.fluid.setItem(class_1799.field_8037);
                this.fluid.setTranslation((Vector3fc)new Vector3f(0.0f, -0.5f, 0.0f));
            } else {
                boolean isSolid = process > 0.5 && isCooling;
                float value = class_3532.method_15363((float)((float)(isSolid ? (process - 0.5) / 0.5 : 1.0 - process / 0.5)), (float)0.0f, (float)1.0f);
                int color = isCooling ? class_9848.method_61318((float)1.0f, (float)1.0f, (float)(0.6f + value * 0.4f), (float)(0.5f + value * 0.5f)) : 0xFFFFFF;
                this.fluid.setItem(FactoryModels.FLUID_FLAT_FULL_SPOUT.get(castingFluid, color, isSolid));
                this.fluid.setTranslation((Vector3fc)new Vector3f(0.0f, (float)((isCooling ? 1.0 : class_3532.method_15350((double)process, (double)0.0, (double)1.0)) - 0.5) * 12.0f / 16.0f + 0.125f, 0.0f));
            }
            if (process > this.progress && !isCooling) {
                this.fluid.startInterpolationIfDirty();
            }
            this.fluid.tick();
            this.progress = process;
            this.castingFluid = castingFluid;
            this.isCooling = isCooling;
        }

        public void setOutput(class_1799 stack) {
            if (class_1799.method_31577((class_1799)stack, (class_1799)this.output.getItem())) {
                return;
            }
            this.output.setItem(stack.method_46651(1));
            this.output.tick();
        }
    }
}

