/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.smeltery;

import com.mojang.serialization.DynamicOps;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.FactoryBlocks;
import eu.pb4.polyfactory.block.fluids.smeltery.CastingCauldronBlock;
import eu.pb4.polyfactory.block.fluids.smeltery.FaucedBlock;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.casting.CauldronCastingRecipe;
import eu.pb4.polyfactory.recipe.input.FluidContainerInput;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.SingleStackInventory;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class CastingCauldronBlockEntity
extends LockableBlockEntity
implements SingleStackInventory {
    protected class_1799 stack = class_1799.field_8037;
    protected double process = 0.0;
    @Nullable
    protected class_8786<CauldronCastingRecipe> currentRecipe = null;
    private CastingCauldronBlock.Model model;
    private boolean isCooling;
    private FaucedBlock.FaucedProvider provider = FaucedBlock.FaucedProvider.EMPTY;
    private boolean findRecipe = false;

    public CastingCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.CASTING_CAULDRON, pos, state);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        double time;
        CastingCauldronBlockEntity self = (CastingCauldronBlockEntity)t;
        if (self.model == null) {
            self.model = (CastingCauldronBlock.Model)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
        }
        self.model.setOutput(self.getStack());
        FluidContainerInput input = self.asInput();
        if (self.provider == FaucedBlock.FaucedProvider.EMPTY) {
            if (world.method_8320(pos.method_10084()).method_27852((class_2248)FactoryBlocks.FAUCED)) {
                self.provider = FaucedBlock.getOutput(world.method_8320(pos.method_10084()), (class_3218)world, pos.method_10084());
            } else {
                if (self.stack.method_7960()) {
                    world.method_8501(pos, class_2246.field_10593.method_9564());
                }
                return;
            }
        }
        if (self.findRecipe) {
            self.currentRecipe = ((class_3218)world).method_64577().method_8132(FactoryRecipeTypes.CASTING_CAULDRON, (class_9695)input, world).orElse(null);
        }
        if (self.currentRecipe == null && self.stack.method_7960()) {
            world.method_8501(pos, class_2246.field_10593.method_9564());
            return;
        }
        if (self.currentRecipe == null || !self.provider.isValid() || !((CauldronCastingRecipe)self.currentRecipe.comp_1933()).method_8115(input, world)) {
            self.currentRecipe = null;
            self.provider.setActiveFluid(null);
            self.provider = FaucedBlock.FaucedProvider.EMPTY;
            if (self.stack.method_7960()) {
                world.method_8501(pos, class_2246.field_10593.method_9564());
            }
            return;
        }
        if (!self.stack.method_7960()) {
            self.currentRecipe = null;
            self.findRecipe = false;
            return;
        }
        self.model.tick();
        double coolingTime = ((CauldronCastingRecipe)self.currentRecipe.comp_1933()).coolingTime(input);
        double d = time = self.isCooling ? coolingTime : ((CauldronCastingRecipe)self.currentRecipe.comp_1933()).time(input);
        if (self.process >= time) {
            self.provider.setActiveFluid(null);
            if (coolingTime > 0.0 && !self.isCooling) {
                self.isCooling = true;
                self.process = 0.0;
                self.method_5431();
                return;
            }
            class_1799 output = ((CauldronCastingRecipe)self.currentRecipe.comp_1933()).method_8116(input, (class_7225.class_7874)world.method_30349());
            self.setStack(output);
            class_1657 class_16572 = FactoryUtil.getClosestPlayer(world, pos, 16.0);
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.CASTING_METAL);
                class_174.field_44587.method_51350(serverPlayer, self.currentRecipe.comp_1932(), List.of());
            }
            self.provider.extract(((CauldronCastingRecipe)self.currentRecipe.comp_1933()).fluidInput(input));
            world.method_45447(null, pos, (class_3414)((CauldronCastingRecipe)self.currentRecipe.comp_1933()).soundEvent().comp_349(), class_3419.field_15245);
            self.process = 0.0;
            self.isCooling = false;
            self.model.setProgress(false, 0.0, null);
            self.model.setOutput(self.getStack());
            self.findRecipe = false;
            self.currentRecipe = null;
            self.method_5431();
        } else {
            self.process += 1.0;
            CastingCauldronBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)self.method_11010());
            FluidStack<?> fluid = ((CauldronCastingRecipe)self.currentRecipe.comp_1933()).fluidInput(input);
            double progress = self.process / time;
            if (!self.isCooling) {
                ((class_3218)world).method_65096(fluid.instance().particle(), (double)pos.method_10263() + 0.5 + (double)((float)self.provider.direction().method_10148() / 16.0f), (double)((float)(pos.method_10264() + 1) + 0.25f), (double)pos.method_10260() + 0.5 + (double)((float)self.provider.direction().method_10165() / 16.0f), 0, 0.0, -1.0, 0.0, 0.1);
                self.provider.setActiveFluid(fluid.instance());
            }
            self.model.setProgress(self.isCooling, progress, fluid.instance());
        }
    }

    private FluidContainerInput asInput() {
        return this.provider.getFluidContainerInput();
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        if (this.provider != null) {
            this.provider.setActiveFluid(null);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        nbt.method_67493("stack", class_1799.field_49266, (DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)this.stack);
        if (this.currentRecipe != null || this.findRecipe) {
            nbt.method_10549("Progress", this.process);
            nbt.method_10556("is_cooling", this.isCooling);
        }
        super.method_11007(nbt, lookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        this.stack = nbt.method_67492("stack", class_1799.field_49266, (DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560)).orElse(class_1799.field_8037);
        if (nbt.method_10545("Progress")) {
            this.process = nbt.method_68563("Progress", 0.0);
            this.isCooling = nbt.method_68566("is_cooling", false);
            this.findRecipe = true;
        }
        super.method_11014(nbt, lookup);
    }

    @Override
    public class_1799 getStack() {
        return this.stack;
    }

    @Override
    public void setStack(class_1799 stack) {
        this.stack = stack;
        this.method_5431();
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public boolean isOutputEmpty() {
        return this.stack.method_7960();
    }

    public int method_5444() {
        return 1;
    }

    public int method_58350(class_1799 stack) {
        return 1;
    }

    public void setup(class_8786<CauldronCastingRecipe> recipe, FaucedBlock.FaucedProvider provider) {
        this.currentRecipe = recipe;
        this.provider = provider;
    }
}

