/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.smeltery;

import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.smeltery.CastingTableBlockEntity;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.item.FactoryItemTags;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class CastingTableBlock
extends class_2248
implements FactoryBlock,
class_2343 {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;

    public CastingTableBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CastingTableBlockEntity(pos, state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)super.method_9605(ctx).method_11657(FACING, (Comparable)ctx.method_8042());
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world instanceof class_3218 && type == FactoryBlockEntities.CASTING_TABLE ? CastingTableBlockEntity::ticker : null;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862;
        if (!player.method_21823() && (class_25862 = world.method_8321(pos)) instanceof CastingTableBlockEntity) {
            CastingTableBlockEntity be = (CastingTableBlockEntity)class_25862;
            if (!be.method_5438(1).method_7960()) {
                if (player.method_6047().method_7960()) {
                    player.method_5673(class_1304.field_6173, be.method_5438(1));
                } else {
                    player.method_64399(be.method_5438(1));
                }
                be.method_5447(1, class_1799.field_8037);
                return class_1269.field_52422;
            }
            if (!be.method_5438(0).method_7960() && player.method_6047().method_7960()) {
                player.method_5673(class_1304.field_6173, be.method_5438(0));
                be.method_5447(0, class_1799.field_8037);
                return class_1269.field_52422;
            }
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        if (!player.method_21823() && (class_25862 = world.method_8321(pos)) instanceof CastingTableBlockEntity) {
            CastingTableBlockEntity be = (CastingTableBlockEntity)class_25862;
            if (!stack.method_7960() && be.isInputEmpty()) {
                be.method_5447(0, stack.method_46651(1));
                stack.method_7934(1);
                return class_1269.field_52422;
            }
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, initialBlockState);
    }

    public class_2680 getPolymerBlockState(class_2680 blockState, PacketContext packetContext) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10593.method_9564();
    }

    public static final class Model
    extends RotationAwareModel {
        private final ItemDisplayElement main;
        private final ItemDisplayElement fluid;
        private final ItemDisplayElement mold;
        private final ItemDisplayElement output;
        private double progress;
        private FluidInstance<?> castingFluid;
        private boolean isCooling;

        private Model(class_3218 world, class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.mold = ItemDisplayElementUtil.createSimple();
            this.mold.setScale((Vector3fc)new Vector3f(0.75f));
            this.mold.setLeftRotation((Quaternionfc)new Quaternionf().rotateX(1.5707964f).rotateY((float)Math.PI));
            this.mold.setTranslation((Vector3fc)new Vector3f(0.0f, 0.46875f, 0.0f));
            this.fluid = LodItemDisplayElement.createSimple();
            this.fluid.setViewRange(0.4f);
            this.fluid.setScale((Vector3fc)new Vector3f(0.75f));
            this.fluid.setOffset(new class_243(0.0, 0.4609375, 0.0));
            this.output = LodItemDisplayElement.createSimple();
            this.output.setViewRange(0.6f);
            this.output.setLeftRotation(this.mold.getLeftRotation());
            this.output.setScale((Vector3fc)new Vector3f(0.75f));
            this.output.setOffset(new class_243(0.0, 0.47265625, 0.0));
            this.updateStatePos(state);
            this.addElement((VirtualElement)this.main);
            this.addElement((VirtualElement)this.mold);
            this.addElement((VirtualElement)this.fluid);
            this.addElement((VirtualElement)this.output);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 direction = (class_2350)state.method_11654(FACING);
            this.main.setYaw(direction.method_10144());
            this.fluid.setYaw(direction.method_10144());
            this.mold.setYaw(direction.method_10144());
            this.output.setYaw(direction.method_10144());
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }

        public void setMold(class_1799 stack) {
            if (class_1799.method_31577((class_1799)stack, (class_1799)this.mold.getItem())) {
                return;
            }
            this.mold.setItem(stack.method_46651(1));
            this.mold.tick();
        }

        public void setProgress(boolean isCooling, double process, FluidInstance<?> castingFluid) {
            if (this.progress == process && this.castingFluid == castingFluid && this.isCooling == isCooling) {
                return;
            }
            if (castingFluid == null) {
                this.fluid.setItem(class_1799.field_8037);
                this.fluid.setTranslation((Vector3fc)new Vector3f(0.0f, -0.1f, 0.0f));
            } else {
                boolean isSolid = process > 0.5 && isCooling;
                float value = class_3532.method_15363((float)((float)(isSolid ? (process - 0.5) / 0.5 : 1.0 - process / 0.5)), (float)0.0f, (float)1.0f);
                int color = isCooling ? class_9848.method_61318((float)1.0f, (float)1.0f, (float)(0.6f + value * 0.4f), (float)(0.5f + value * 0.5f)) : 0xFFFFFF;
                this.fluid.setItem((this.mold.getItem().method_31573(FactoryItemTags.CASTING_SMALL_FLUID) ? FactoryModels.FLUID_FLAT_14_SPOUT : FactoryModels.FLUID_FLAT_FULL_SPOUT).get(castingFluid, color, isSolid));
                this.fluid.setTranslation((Vector3fc)new Vector3f(0.0f, (float)((isCooling ? 1.0 : class_3532.method_15350((double)process, (double)0.0, (double)1.0)) - 0.5) / 16.2f * 12.0f / 16.0f, 0.0f));
            }
            if (process > this.progress && !isCooling) {
                this.fluid.startInterpolationIfDirty();
            }
            this.fluid.tick();
            this.progress = process;
            this.castingFluid = castingFluid;
            this.isCooling = isCooling;
        }

        public void setOutput(class_1799 stack) {
            if (class_1799.method_31577((class_1799)stack, (class_1799)this.output.getItem())) {
                return;
            }
            this.output.setItem(stack.method_46651(1));
            this.output.tick();
        }
    }
}

