/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.smeltery;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.FactoryBlocks;
import eu.pb4.polyfactory.block.fluids.smeltery.CastingTableBlock;
import eu.pb4.polyfactory.block.fluids.smeltery.FaucedBlock;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryItemTags;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.casting.CastingRecipe;
import eu.pb4.polyfactory.recipe.input.SingleItemWithFluid;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.MinimalSidedInventory;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.Nullable;

public class CastingTableBlockEntity
extends LockableBlockEntity
implements MinimalSidedInventory {
    public static final int OUTPUT_FIRST = 1;
    public static final int INPUT_FIRST = 0;
    private static final int[] OUTPUT_SLOTS = new int[]{1};
    private static final int[] INPUT_SLOTS = new int[]{0};
    protected final class_2371<class_1799> stacks = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    protected double process = 0.0;
    @Nullable
    protected class_8786<CastingRecipe> currentRecipe = null;
    private boolean active;
    private CastingTableBlock.Model model;
    private boolean activate = false;
    private boolean isCooling;
    private FaucedBlock.FaucedProvider provider = FaucedBlock.FaucedProvider.EMPTY;

    public CastingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.CASTING_TABLE, pos, state);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        double time;
        CastingTableBlockEntity self = (CastingTableBlockEntity)t;
        if (self.model == null) {
            self.model = (CastingTableBlock.Model)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
        }
        self.model.setMold(self.method_5438(0));
        self.model.setOutput(self.method_5438(1));
        if (!self.provider.isValid()) {
            self.provider.setActiveFluid(null);
            self.provider = FaucedBlock.FaucedProvider.EMPTY;
            if (self.activate) {
                if (world.method_8320(pos.method_10084()).method_27852((class_2248)FactoryBlocks.FAUCED)) {
                    self.provider = FaucedBlock.getOutput(world.method_8320(pos.method_10084()), (class_3218)world, pos.method_10084());
                }
                if (!self.provider.isValid()) {
                    self.activate = false;
                }
            }
        }
        if (self.provider == FaucedBlock.FaucedProvider.EMPTY || !self.isOutputEmpty() || !self.activate) {
            self.process = 0.0;
            self.model.setProgress(false, 0.0, null);
            self.activate = false;
            self.active = false;
            self.isCooling = false;
            self.model.tick();
            self.provider.setActiveFluid(null);
            self.provider = FaucedBlock.FaucedProvider.EMPTY;
            return;
        }
        class_1799 inputStack = self.method_5438(0);
        SingleItemWithFluid input = self.asInput();
        if (self.currentRecipe == null || !((CastingRecipe)self.currentRecipe.comp_1933()).method_8115(input, world)) {
            self.process = 0.0;
            self.currentRecipe = ((class_3218)world).method_64577().method_8132(FactoryRecipeTypes.CASTING, (class_9695)input, world).orElse(null);
            if (self.currentRecipe == null) {
                self.active = false;
                self.model.tick();
                self.isCooling = false;
                self.provider.setActiveFluid(null);
                self.model.setProgress(false, 0.0, null);
                self.activate = false;
                return;
            }
        }
        self.active = true;
        self.model.tick();
        double coolingTime = ((CastingRecipe)self.currentRecipe.comp_1933()).coolingTime(input);
        double d = time = self.isCooling ? coolingTime : ((CastingRecipe)self.currentRecipe.comp_1933()).time(input);
        if (self.process >= time) {
            self.provider.setActiveFluid(null);
            if (coolingTime > 0.0 && !self.isCooling) {
                self.isCooling = true;
                self.process = 0.0;
                self.method_5431();
                return;
            }
            class_1799 itemOut = ((CastingRecipe)self.currentRecipe.comp_1933()).method_8116(input, (class_7225.class_7874)world.method_30349());
            self.method_5447(1, itemOut);
            class_1657 class_16572 = FactoryUtil.getClosestPlayer(world, pos, 16.0);
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.CASTING_METAL);
                if (itemOut.method_31573(FactoryItemTags.MOLDS)) {
                    TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.CASTING_MOLD);
                }
                class_174.field_44587.method_51350(serverPlayer, self.currentRecipe.comp_1932(), List.of(inputStack.method_7972()));
            }
            inputStack.method_7934(((CastingRecipe)self.currentRecipe.comp_1933()).decreasedInputItemAmount(input));
            int damage = ((CastingRecipe)self.currentRecipe.comp_1933()).damageInputItemAmount(input);
            if (damage > 0) {
                class_1799 x = inputStack.method_7972();
                inputStack.method_7956(damage, (class_3218)world, null, Consumers.nop());
                if (inputStack.method_7960()) {
                    if (x.method_57826(class_9334.field_56399)) {
                        world.method_45447(null, pos, (class_3414)((class_6880)x.method_58694(class_9334.field_56399)).comp_349(), class_3419.field_15245);
                    }
                    ((class_3218)world).method_65096((class_2394)new class_2392(class_2398.field_11218, x), (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.51, 5, 0.2, 0.0, 0.2, 0.5);
                }
            }
            if (inputStack.method_7960()) {
                self.method_5447(0, class_1799.field_8037);
            }
            self.provider.extract(((CastingRecipe)self.currentRecipe.comp_1933()).fluidInput(input));
            world.method_45447(null, pos, (class_3414)((CastingRecipe)self.currentRecipe.comp_1933()).soundEvent().comp_349(), class_3419.field_15245);
            self.process = 0.0;
            self.isCooling = false;
            self.model.setProgress(false, 0.0, null);
            self.model.setMold(self.method_5438(0));
            self.model.setOutput(self.method_5438(1));
            self.method_5431();
        } else {
            self.process += 1.0;
            CastingTableBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)self.method_11010());
            FluidStack<?> fluid = ((CastingRecipe)self.currentRecipe.comp_1933()).fluidInput(input);
            double progress = self.process / time;
            if (!self.isCooling) {
                ((class_3218)world).method_65096(fluid.instance().particle(), (double)pos.method_10263() + 0.5 + (double)((float)self.provider.direction().method_10148() / 16.0f), (double)((float)(pos.method_10264() + 1) + 0.25f), (double)pos.method_10260() + 0.5 + (double)((float)self.provider.direction().method_10165() / 16.0f), 0, 0.0, -1.0, 0.0, 0.1);
                self.provider.setActiveFluid(fluid.instance());
            }
            self.model.setProgress(self.isCooling, progress, fluid.instance());
        }
    }

    private SingleItemWithFluid asInput() {
        return new SingleItemWithFluid(this.method_5438(0).method_7972(), this.provider.getFluidContainerInput(), (class_3218)this.field_11863);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1262.method_5426((class_2487)nbt, this.stacks, (class_7225.class_7874)lookup);
        if (this.activate) {
            nbt.method_10549("Progress", this.process);
            nbt.method_10556("is_cooling", this.isCooling);
        }
        super.method_11007(nbt, lookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1262.method_5429((class_2487)nbt, this.stacks, (class_7225.class_7874)lookup);
        if (nbt.method_10545("Progress")) {
            this.process = nbt.method_68563("Progress", 0.0);
            this.isCooling = nbt.method_68566("is_cooling", false);
            this.activate = true;
        }
        super.method_11014(nbt, lookup);
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        if (this.provider != null) {
            this.provider.setActiveFluid(null);
        }
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public boolean isInputEmpty() {
        return ((class_1799)this.stacks.get(0)).method_7960();
    }

    public boolean isOutputEmpty() {
        return ((class_1799)this.stacks.get(1)).method_7960();
    }

    public int method_5444() {
        return 1;
    }

    public int method_58350(class_1799 stack) {
        return 1;
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.stacks;
    }

    public class_1269 activate(FaucedBlock.FaucedProvider provider) {
        if (this.isInputEmpty() && !this.isOutputEmpty()) {
            SingleItemWithFluid input = new SingleItemWithFluid(this.method_5438(1), provider.getFluidContainerInput(), (class_3218)this.field_11863);
            if (this.currentRecipe != null && ((CastingRecipe)this.currentRecipe.comp_1933()).method_8115(input, (class_1937)input.world()) || (this.currentRecipe = (class_8786)((class_3218)this.field_11863).method_64577().method_8132(FactoryRecipeTypes.CASTING, (class_9695)input, this.field_11863).orElse(null)) != null) {
                this.method_5447(0, this.method_5438(1));
                this.method_5447(1, class_1799.field_8037);
            }
        }
        if (this.activate || !this.isOutputEmpty() || !provider.isValid()) {
            return class_1269.field_5814;
        }
        this.provider = provider;
        this.activate = true;
        return class_1269.field_52422;
    }
}

