/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.smeltery;

import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.block.FactoryBlocks;
import eu.pb4.polyfactory.block.fluids.FluidOutput;
import eu.pb4.polyfactory.block.fluids.smeltery.CastingTableBlockEntity;
import eu.pb4.polyfactory.block.fluids.transport.PipeConnectable;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.drain.DrainRecipe;
import eu.pb4.polyfactory.recipe.input.DrainInput;
import eu.pb4.polyfactory.recipe.input.FluidContainerInput;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5328;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class FaucedBlock
extends class_2248
implements FactoryBlock,
PolymerTexturedBlock,
PipeConnectable {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    private static final Map<class_2350, class_2680> STATES_REGULAR = class_156.method_63541(class_2350.class, x -> PolymerBlockResourceUtils.requestEmpty((BlockModelType)BlockModelType.valueOf((String)((switch (x) {
        case class_2350.field_11036 -> "BOTTOM";
        case class_2350.field_11033 -> "TOP";
        default -> x.method_15434().toUpperCase(Locale.ROOT);
    }) + "_TRAPDOOR"))));

    public FaucedBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 dir = ctx.method_8038().method_10166() != class_2350.class_2351.field_11052 ? ctx.method_8038() : ctx.method_8042().method_10153();
        return (class_2680)super.method_9605(ctx).method_11657(FACING, (Comparable)dir);
    }

    public static FaucedProvider getOutput(class_2680 state, class_3218 world, class_2338 pos) {
        class_2586 be;
        ElementHolder elementHolder;
        class_2338 sourcePos = pos.method_10093(((class_2350)state.method_11654(FACING)).method_10153());
        class_2680 source = world.method_8320(sourcePos);
        BlockAwareAttachment blockAwareAttachment = BlockAwareAttachment.get((class_1937)world, (class_2338)pos);
        if (blockAwareAttachment instanceof BlockAwareAttachment) {
            BlockAwareAttachment attachment = blockAwareAttachment;
            elementHolder = attachment.holder();
        } else {
            elementHolder = null;
        }
        Model model = (Model)elementHolder;
        if (source.method_26204() instanceof FluidOutput.Getter) {
            return new DynamicProvider(model, state, pos, world, sourcePos, (class_2350)state.method_11654(FACING));
        }
        class_2586 class_25862 = world.method_8321(sourcePos);
        if (class_25862 instanceof class_2586 && (be = class_25862) instanceof FluidOutput) {
            FluidOutput output1 = (FluidOutput)be;
            return new SimpleProvider(model, state, pos, world, () -> ((class_2586)be).method_11015(), output1, (class_2350)state.method_11654(FACING));
        }
        return new ModelOnlyProvider(model, (class_2350)state.method_11654(FACING));
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 worldx, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_3218 world = (class_3218)worldx;
        FaucedProvider output = FaucedBlock.getOutput(state, world, pos);
        if (!output.isValid()) {
            return super.method_55765(stack, state, (class_1937)world, pos, player, hand, hit);
        }
        class_1799 copy = stack.method_7972();
        DrainInput input = new DrainInput(copy, class_1799.field_8037, output.getFluidContainerInput(), !(player instanceof FakePlayer));
        Optional optional = world.method_64577().method_8132(FactoryRecipeTypes.DRAIN, (class_9695)input, player.method_37908());
        if (optional.isEmpty() || !((DrainRecipe)((class_8786)optional.get()).comp_1933()).fluidOutput(input).isEmpty()) {
            return super.method_55765(stack, state, (class_1937)world, pos, player, hand, hit);
        }
        DrainRecipe recipe = (DrainRecipe)((class_8786)optional.get()).comp_1933();
        class_1799 itemOut = recipe.method_8116(input, (class_7225.class_7874)player.method_56673());
        for (FluidStack<?> fluid : recipe.fluidInput(input)) {
            output.extract(fluid);
        }
        class_5328.method_30270((class_1799)stack, (class_1657)player, (class_1799)itemOut, (boolean)false);
        player.method_17356((class_3414)recipe.soundEvent().comp_349(), class_3419.field_15245, 0.5f, 1.0f);
        return class_1269.field_52422;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862;
        FaucedProvider output = FaucedBlock.getOutput(state, (class_3218)world, pos);
        if (!output.isValid()) {
            return class_1269.field_5811;
        }
        if (!player.method_21823() && (class_25862 = world.method_8321(pos.method_10074())) instanceof CastingTableBlockEntity) {
            CastingTableBlockEntity be = (CastingTableBlockEntity)class_25862;
            return be.activate(output);
        }
        if (!player.method_21823() && world.method_8320(pos.method_10074()).method_27852(class_2246.field_10593)) {
            return FactoryBlocks.CASTING_CAULDRON.tryCauldronCasting((class_3218)world, pos.method_10074(), output);
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, initialBlockState);
    }

    public class_2680 getPolymerBlockState(class_2680 blockState, PacketContext packetContext) {
        return STATES_REGULAR.get(blockState.method_11654(FACING));
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return (class_2680)((class_2680)class_2246.field_47048.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)((class_2350)state.method_11654(FACING)))).method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public boolean canPipeConnect(class_4538 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return state.method_11654(FACING) == dir.method_10153();
    }

    public static final class Model
    extends RotationAwareModel {
        private final ItemDisplayElement main;
        private final ItemDisplayElement fluid;
        private FluidInstance<?> fluidType;

        private Model(class_3218 world, class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.main.setTranslation((Vector3fc)new Vector3f(0.0f, 0.0f, -0.3125f));
            this.fluid = ItemDisplayElementUtil.createSimple();
            this.fluid.setScale((Vector3fc)new Vector3f(2.0f));
            this.fluid.setTranslation((Vector3fc)new Vector3f(0.0f, 0.0f, -0.3125f));
            this.updateStatePos(state);
            this.addElement((VirtualElement)this.main);
            this.addElement((VirtualElement)this.fluid);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 direction = (class_2350)state.method_11654(FACING);
            this.main.setYaw(direction.method_10144());
            this.fluid.setYaw(direction.method_10144());
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }

        public void setFluid(FluidInstance<?> fluid) {
            if (this.fluidType == fluid) {
                return;
            }
            this.fluid.setItem(FactoryModels.FLUID_FAUCED.get(fluid));
            this.fluid.tick();
            this.fluidType = fluid;
        }
    }

    public record DynamicProvider(Model model, class_2680 selfState, class_2338 faucedPos, class_3218 world, class_2338 sourcePos, class_2350 direction) implements FaucedProvider
    {
        private FluidOutput getOutput() {
            FluidOutput fluidOutput;
            class_2248 class_22482 = this.world.method_8320(this.sourcePos).method_26204();
            if (class_22482 instanceof FluidOutput.Getter) {
                FluidOutput.Getter getter = (FluidOutput.Getter)class_22482;
                fluidOutput = getter.getFluidOutput(this.world, this.sourcePos, this.direction);
            } else {
                fluidOutput = null;
            }
            return fluidOutput;
        }

        @Override
        public FluidContainerInput getFluidContainerInput() {
            FluidOutput output = this.getOutput();
            return output != null ? output.getFluidContainerInput(this.direction) : FluidContainerInput.EMPTY;
        }

        @Override
        public boolean isValid() {
            return this.getOutput() != null && this.world.method_8320(this.faucedPos) == this.selfState;
        }

        @Override
        public void extract(FluidStack<?> fluid) {
            FluidOutput output = this.getOutput();
            if (output != null) {
                output.extractFluid(fluid.instance(), fluid.amount(), this.direction, true);
            }
        }

        @Override
        public void setActiveFluid(@Nullable FluidInstance<?> fluid) {
            if (this.model != null) {
                this.model.setFluid(fluid);
            }
        }
    }

    public record SimpleProvider(Model model, class_2680 selfState, class_2338 faucedPos, class_3218 world, BooleanSupplier removed, FluidOutput output, class_2350 direction) implements FaucedProvider
    {
        @Override
        public FluidContainerInput getFluidContainerInput() {
            return this.output.getFluidContainerInput(this.direction);
        }

        @Override
        public boolean isValid() {
            return !this.removed.getAsBoolean() && this.world.method_8320(this.faucedPos) == this.selfState;
        }

        @Override
        public void extract(FluidStack<?> fluid) {
            this.output.extractFluid(fluid.instance(), fluid.amount(), this.direction, true);
        }

        @Override
        public void setActiveFluid(@Nullable FluidInstance<?> fluid) {
            if (this.model != null) {
                this.model.setFluid(fluid);
            }
        }
    }

    public record ModelOnlyProvider(Model model, class_2350 direction) implements FaucedProvider
    {
        @Override
        public FluidContainerInput getFluidContainerInput() {
            return FluidContainerInput.EMPTY;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void extract(FluidStack<?> fluidStacks) {
        }

        @Override
        public void setActiveFluid(@Nullable FluidInstance<?> fluid) {
            if (this.model != null) {
                this.model.setFluid(fluid);
            }
        }
    }

    public static interface FaucedProvider {
        public static final FaucedProvider EMPTY = new FaucedProvider(){

            @Override
            public FluidContainerInput getFluidContainerInput() {
                return FluidContainerInput.EMPTY;
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public void extract(FluidStack<?> fluidStacks) {
            }

            @Override
            public void setActiveFluid(@Nullable FluidInstance<?> fluid) {
            }

            @Override
            public class_2350 direction() {
                return class_2350.field_11036;
            }
        };

        public FluidContainerInput getFluidContainerInput();

        public boolean isValid();

        public void extract(FluidStack<?> var1);

        public void setActiveFluid(@Nullable FluidInstance<?> var1);

        public class_2350 direction();
    }
}

