/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.transport;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.configurable.ConfigurableBlock;
import eu.pb4.polyfactory.block.fluids.transport.FilteredPipeBlockEntity;
import eu.pb4.polyfactory.block.fluids.transport.PipeConnectable;
import eu.pb4.polyfactory.block.network.NetworkBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.block.other.FilledStateProvider;
import eu.pb4.polyfactory.fluid.FluidBehaviours;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.generic.SimpleAxisNode;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class FilteredPipeBlock
extends NetworkBlock
implements FactoryBlock,
ConfigurableBlock,
PipeConnectable,
BarrierBasedWaterloggable,
class_2343,
NetworkComponent.Pipe {
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12496;
    public static final class_2746 INVERTED = class_2741.field_12501;

    public FilteredPipeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(false)));
        Model.NEGATED.method_7960();
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FilledStateProvider) {
            FilledStateProvider be = (FilledStateProvider)class_25862;
            return (int)(be.getFilledAmount() * 15L / be.getFillCapacity());
        }
        return 0;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.waterLog(ctx, (class_2680)this.method_9564().method_11657(AXIS, (Comparable)ctx.method_8038().method_10166()));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AXIS, INVERTED, WATERLOGGED});
    }

    @Override
    protected void updateNetworkAt(class_4538 world, class_2338 pos) {
        NetworkComponent.Pipe.updatePipeAt(world, pos);
    }

    @Override
    protected boolean isSameNetworkType(class_2248 block) {
        return block instanceof NetworkComponent.Pipe;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862;
        class_1799 stack = player.method_5998(class_1268.field_5808);
        Function<class_1799, FluidInstance<?>> func = FluidBehaviours.ITEM_TO_FLUID.get(stack.method_7909());
        if (func != null && (class_25862 = world.method_8321(pos)) instanceof FilteredPipeBlockEntity) {
            FilteredPipeBlockEntity be = (FilteredPipeBlockEntity)class_25862;
            be.setAllowedFluid(func.apply(stack));
            be.method_5431();
            return class_1269.field_52422;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        this.tickWater(state, world, tickView, pos);
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public boolean canPipeConnect(class_4538 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return dir.method_10166() == state.method_11654(AXIS);
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState, pos);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FilteredPipeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return FilteredPipeBlockEntity::tick;
    }

    @Override
    public Collection<BlockNode> createPipeNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SimpleAxisNode((class_2350.class_2351)state.method_11654(AXIS)));
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_27119.method_9564();
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.rotateAxis(state, AXIS, rotation);
    }

    @Override
    public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
        return List.of(BlockConfig.AXIS, BlockConfig.INVERTED);
    }

    public static final class Model
    extends RotationAwareModel {
        private static final class_1799 NEGATED = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/filtered_pipe_negated"));
        private final ItemDisplayElement mainElement;
        private final ItemDisplayElement fluid;

        private Model(class_2680 state, class_2338 pos) {
            this.mainElement = ItemDisplayElementUtil.createSimple((class_1799)((Boolean)state.method_11654((class_2769)INVERTED) != false ? NEGATED : ItemDisplayElementUtil.getModel((class_1792)state.method_26204().method_8389())));
            this.mainElement.setScale((Vector3fc)new Vector3f(2.0f));
            this.fluid = ItemDisplayElementUtil.createSimple();
            this.fluid.setScale((Vector3fc)new Vector3f(2.0f));
            this.fluid.setViewRange(0.4f);
            this.updateStatePos(state);
            this.addElement((VirtualElement)this.mainElement);
            this.addElement((VirtualElement)this.fluid);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 dir = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)((class_2350.class_2351)state.method_11654(AXIS)));
            float p = -90.0f;
            float y = 0.0f;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                p = 0.0f;
                y = dir.method_10144();
            } else if (dir == class_2350.field_11033) {
                p = 90.0f;
            }
            this.mainElement.setYaw(y);
            this.mainElement.setPitch(p);
            this.fluid.setYaw(y);
            this.fluid.setPitch(p);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.mainElement.setItem((Boolean)this.blockState().method_11654((class_2769)INVERTED) != false ? NEGATED : ItemDisplayElementUtil.getModel((class_1792)this.blockState().method_26204().method_8389()));
                this.updateStatePos(this.blockState());
            }
        }

        public void setAllowedFluid(FluidInstance<?> fluid) {
            if (fluid == null) {
                this.fluid.setItem(class_1799.field_8037);
            } else {
                this.fluid.setItem(FactoryModels.FLUID_FILTERED_PIPE.get(fluid));
            }
        }
    }
}

