/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.transport;

import eu.pb4.polyfactory.block.fluids.FluidInput;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.world.FluidWorldPullInteraction;
import eu.pb4.polyfactory.fluid.world.FluidWorldPushInteraction;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.util.DebugTextProvider;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public abstract class PipeLikeBlockEntity
extends class_2586
implements FluidInput.ContainerBased,
DebugTextProvider {
    protected final FluidContainerImpl container = this.createContainer();
    protected final FluidWorldPushInteraction fluidPush = new FluidWorldPushInteraction(this.container, () -> (class_3218)this.field_11863, () -> ((PipeLikeBlockEntity)this).method_11016());
    protected final FluidWorldPullInteraction fluidPull = new FluidWorldPullInteraction(this.container, () -> (class_3218)this.field_11863, () -> ((PipeLikeBlockEntity)this).method_11016());

    public PipeLikeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public FluidContainer getFluidContainer() {
        return this.container;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.container;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("fluid", this.container.toNbt(registryLookup));
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.container.fromNbt(registryLookup, nbt, "fluid");
        this.fluidPush.setMaxPush(this.container.stored());
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        FluidComponent f = (FluidComponent)components.method_58694(FactoryDataComponents.FLUID);
        if (f != null) {
            f.copyTo(this.container);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(FactoryDataComponents.FLUID, (Object)FluidComponent.copyFrom(this.container));
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551("fluid");
    }

    public void preTick() {
        FluidContainerUtil.tick((FluidContainer)this.container, (class_3218)this.field_11863, this.field_11867, this.container.fluidTemperature(), this::dropItem);
        this.fluidPush.lowerProgress(0.01);
        this.fluidPull.lowerProgress(0.01);
    }

    private void dropItem(class_1799 stack) {
        class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.5), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)stack);
    }

    public void postTick() {
        this.fluidPush.setMaxPush(this.container.stored());
    }

    public final void pushFluid(class_2350 direction, double strength) {
        this.fluidPush.pushFluid(direction, strength);
    }

    public final void pullFluid(class_2350 direction, double strength) {
        this.fluidPull.pullFluid(direction, strength);
    }

    protected FluidContainerImpl createContainer() {
        return FluidContainerImpl.singleFluid(81000L, () -> ((PipeLikeBlockEntity)this).method_5431());
    }

    @Override
    public class_2561 getDebugText() {
        return class_2561.method_43470((String)("F: " + this.container.getFilledPercentage()));
    }

    @Override
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.hasDirection(direction) ? this.container : null;
    }

    protected abstract boolean hasDirection(class_2350 var1);
}

