/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.mojang.serialization.Codec;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.configurable.ConfigurableBlock;
import eu.pb4.polyfactory.block.configurable.WrenchModifyValue;
import eu.pb4.polyfactory.block.mechanical.EjectorBlockEntity;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.RotationalNetworkBlock;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.generic.FunctionalAxisNode;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.other.FactorySoundEvents;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.LastFanEffectedTickConsumer;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1432;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class EjectorBlock
extends RotationalNetworkBlock
implements FactoryBlock,
RotationUser,
class_2343,
ConfigurableBlock {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2746 ENABLED = class_2741.field_12515;
    private static final List<BlockConfig<?>> WRENCH_ACTIONS = List.of(BlockConfig.FACING_HORIZONTAL, BlockConfig.ofBlockEntity("angle", Codec.FLOAT, EjectorBlockEntity.class, (x, world, pos, side, state) -> class_2561.method_43470((String)String.format(Locale.ROOT, "%.0f", x)), EjectorBlockEntity::angle, EjectorBlockEntity::setAngle, WrenchModifyValue.simple((x, n) -> Float.valueOf(FactoryUtil.wrap(x.floatValue() + (n != false ? 5.0f : -5.0f), 10.0f, 65.0f)))), BlockConfig.ofBlockEntity("strength", Codec.FLOAT, EjectorBlockEntity.class, (x, world, pos, side, state) -> class_2561.method_43470((String)String.format(Locale.ROOT, "%.2f", x)), EjectorBlockEntity::strength, EjectorBlockEntity::setStrength, WrenchModifyValue.simple((x, n) -> Float.valueOf(FactoryUtil.wrap(x.floatValue() + (n != false ? 0.25f : -0.25f), 1.0f, 2.5f)))));

    public EjectorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042());
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204())) {
            this.updateEnabled(world, pos, state);
        }
        super.method_9615(state, world, pos, oldState, notify);
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        this.updateEnabled(world, pos, state);
        super.method_9612(state, world, pos, sourceBlock, wireOrientation, notify);
    }

    private void updateEnabled(class_1937 world, class_2338 pos, class_2680 state) {
        boolean powered = world.method_49803(pos);
        if (powered == (Boolean)state.method_11654((class_2769)ENABLED)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(!powered)), 4);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ENABLED});
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new FunctionalAxisNode(((class_2350)state.method_11654(FACING)).method_10170().method_10166()));
    }

    public void onLandedUpon(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        EjectorBlockEntity be;
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof EjectorBlockEntity) || (be = (EjectorBlockEntity)class_25862).progress() < 1.0f && be.ignoredTick() + 4L < world.method_8510() || !((Boolean)state.method_11654((class_2769)ENABLED)).booleanValue()) {
            return;
        }
        super.method_9554(world, state, pos, entity, (double)fallDistance);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        EjectorBlockEntity be;
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof EjectorBlockEntity) || (be = (EjectorBlockEntity)class_25862).progress() < 1.0f && be.ignoredTick() + 4L < world.method_8510() || !((Boolean)state.method_11654((class_2769)ENABLED)).booleanValue()) {
            return;
        }
        if (be.progress() >= 1.0f) {
            world.method_45447(null, pos, FactorySoundEvents.BLOCK_EJECTOR_LAUNCH, class_3419.field_15245);
            be.setIgnoredTick(world.method_8510());
        }
        be.setProgress(0.0f);
        class_2350 rot = ((class_2350)state.method_11654(FACING)).method_10170();
        float verticalDrag = 0.98f;
        float horizontalDrag = 0.98f;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            float f = horizontalDrag = livingEntity.method_35053() ? 1.0f : 0.91f;
        }
        if (entity instanceof class_1432) {
            verticalDrag = horizontalDrag;
        }
        class_243 vec = new class_243(((class_2350)state.method_11654(FACING)).method_23955().mul(1.0f / verticalDrag, 1.0f / horizontalDrag, 1.0f / verticalDrag).mul(be.strength()).mul((float)(entity.method_56989() / 0.08)).rotateAxis(be.angle() * ((float)Math.PI / 180), (float)rot.method_10148(), (float)rot.method_10164(), (float)rot.method_10165()));
        entity.method_24830(false);
        entity.method_18799(vec);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            FactoryUtil.sendVelocityDelta(player, vec.method_1031(0.0, player.method_56989(), 0.0));
            TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.LAUNCHED_BY_EJECTOR);
        } else if (entity instanceof LastFanEffectedTickConsumer) {
            LastFanEffectedTickConsumer c = (LastFanEffectedTickConsumer)entity;
            c.polyfactory$setLastFanTick();
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new EjectorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world instanceof class_3218 && type == FactoryBlockEntities.EJECTOR ? EjectorBlockEntity::tick : null;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0), FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0), FACING);
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10085.method_9564();
    }

    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Override
    public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
        return WRENCH_ACTIONS;
    }

    @Override
    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof EjectorBlockEntity) {
            EjectorBlockEntity be = (EjectorBlockEntity)class_25862;
            be.updateRotationalData(modifier, state, world, pos);
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        int n;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof EjectorBlockEntity) {
            EjectorBlockEntity be = (EjectorBlockEntity)class_25862;
            n = (int)(be.progress() * 15.0f);
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public void wrenchTick(class_3222 player, class_3965 hit, class_2680 state) {
    }

    public static final class Model
    extends RotationAwareModel {
        public static final class_1799 BASE_MODEL = ItemDisplayElementUtil.getModel((class_2960)FactoryUtil.id("block/ejector_base"));
        public static final class_1799 PLATE_MODEL = ItemDisplayElementUtil.getModel((class_2960)FactoryUtil.id("block/ejector_plate"));
        public static final class_1799 LINK_MODEL = ItemDisplayElementUtil.getModel((class_2960)FactoryUtil.id("block/ejector_link"));
        private final ItemDisplayElement base = ItemDisplayElementUtil.createSimple((class_1799)BASE_MODEL);
        private final ItemDisplayElement plate = ItemDisplayElementUtil.createSimple((class_1799)PLATE_MODEL);
        private final ItemDisplayElement link;
        private float progress = -1.0f;

        private Model(class_2680 state) {
            this.plate.setInterpolationDuration(3);
            this.link = ItemDisplayElementUtil.createSimple((class_1799)LINK_MODEL);
            this.link.setInterpolationDuration(3);
            this.updateStatePos(state);
            this.updateProgress(0.0f);
            this.addElement((VirtualElement)this.base);
            this.addElement((VirtualElement)this.plate);
            this.addElement((VirtualElement)this.link);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 dir = (class_2350)state.method_11654(FACING);
            float y = dir.method_10144();
            this.base.setYaw(y);
            this.plate.setYaw(y);
            this.link.setYaw(y);
        }

        public void updateProgress(float progress) {
            if (this.progress == progress) {
                return;
            }
            this.progress = progress;
            this.plate.setTransformation(Model.mat().translate(0.0f, 0.3125f, 0.4375f).rotateX(progress));
            this.link.setTransformation(Model.mat().translate(0.0f, 0.3125f, 0.4375f).rotateX(progress).translate(0.0f, 0.0f, -0.625f).rotateX(-progress / 2.0f));
        }

        protected void onTick() {
            if (this.plate.isDirty()) {
                this.plate.startInterpolation();
                this.link.startInterpolation();
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }
    }
}

