/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical;

import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.EjectorBlock;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class EjectorBlockEntity
extends class_2586
implements BlockEntityExtraListener {
    @Nullable
    private EjectorBlock.Model model;
    private float angle = 45.0f;
    private float progress = 0.5f;
    private float strength = 2.0f;
    private long ignoredTick = -1L;

    public EjectorBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.EJECTOR, pos, state);
    }

    public static <T extends class_2586> void tick(class_1937 worldx, class_2338 pos, class_2680 state, T t) {
        EjectorBlockEntity be;
        class_3218 world;
        block3: {
            block2: {
                if (!(worldx instanceof class_3218)) break block2;
                world = (class_3218)worldx;
                if (!(t instanceof EjectorBlockEntity)) break block2;
                be = (EjectorBlockEntity)t;
                if (be.ignoredTick + 10L <= world.method_8510()) break block3;
            }
            return;
        }
        double speed = RotationUser.getRotation((class_1937)world, pos).speed();
        be.setProgress((float)((double)be.progress + speed / (double)(be.strength * be.strength * 60.0f)));
    }

    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 world, class_2338 pos) {
        if (this.progress < 1.0f) {
            modifier.stress((double)this.strength * 1.2);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_10548("angle", this.angle);
        nbt.method_10548("strength", this.strength);
        nbt.method_10548("progress", this.progress);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.angle = nbt.method_66563("angle", 45.0f);
        this.strength = nbt.method_66563("strength", 2.0f);
        this.progress = nbt.method_66563("process", 0.0f);
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.method_5431();
    }

    public float angle() {
        return this.angle;
    }

    public float progress() {
        return this.progress;
    }

    public float strength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        float old = this.strength;
        this.strength = strength;
        this.setProgress(this.progress * old / strength);
        this.method_5431();
    }

    public void onListenerUpdate(class_2818 worldChunk) {
        this.model = (EjectorBlock.Model)BlockAwareAttachment.get((class_2818)worldChunk, (class_2338)this.field_11867).holder();
    }

    public void setProgress(float progress) {
        this.progress = Math.min(progress, 1.0f);
        this.method_5431();
        if (this.model != null) {
            this.model.updateProgress((1.0f - this.progress) * (60.0f - this.angle * 0.4f) * ((float)Math.PI / 180));
            this.model.tick();
        }
    }

    public void setIgnoredTick(long ignoredTick) {
        this.ignoredTick = ignoredTick;
    }

    public long ignoredTick() {
        return this.ignoredTick;
    }
}

