/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.conveyor;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.configurable.ConfigurableBlock;
import eu.pb4.polyfactory.block.mechanical.conveyor.ConveyorLikeDirectional;
import eu.pb4.polyfactory.block.mechanical.conveyor.FunnelBlockEntity;
import eu.pb4.polyfactory.item.tool.AbstractFilterItem;
import eu.pb4.polyfactory.models.FilterIcon;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polyfactory.util.movingitem.MovingItemConsumer;
import eu.pb4.polyfactory.util.movingitem.MovingItemProvider;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_10225;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_811;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import xyz.nucleoid.packettweaker.PacketContext;

public class FunnelBlock
extends class_2248
implements FactoryBlock,
MovingItemConsumer,
MovingItemProvider,
ConfigurableBlock,
class_2343,
BarrierBasedWaterloggable {
    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2754<ConveyorLikeDirectional.TransferMode> MODE = class_2754.method_11849((String)"mode", ConveyorLikeDirectional.TransferMode.class, (Enum[])new ConveyorLikeDirectional.TransferMode[]{ConveyorLikeDirectional.TransferMode.FROM_CONVEYOR, ConveyorLikeDirectional.TransferMode.TO_CONVEYOR});
    private static final BlockConfig MODE_ACTION = BlockConfig.of("mode", MODE, (t, world, pos, side, state) -> class_2561.method_43471((String)("item.polyfactory.wrench.action.mode.transfer_mode." + t.method_15434())));

    public FunnelBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true)));
        Model.MODEL_OUT.method_7960();
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, MODE, ENABLED});
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        this.tickWater(state, world, tickView, pos);
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public boolean pushItemTo(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        FunnelBlockEntity funnelBlockEntity;
        class_2350 selfDir;
        class_2680 selfState;
        block8: {
            block7: {
                selfState = self.getBlockState();
                if (!((Boolean)selfState.method_11654((class_2769)ENABLED)).booleanValue()) {
                    return false;
                }
                selfDir = (class_2350)selfState.method_11654(FACING);
                ConveyorLikeDirectional.TransferMode mode = (ConveyorLikeDirectional.TransferMode)((Object)selfState.method_11654(MODE));
                if (!mode.fromConveyor || relative != class_2350.field_11036 || selfDir.method_10153() == pushDirection) break block7;
                double d = conveyor.movementDelta();
                double d2 = selfDir == pushDirection ? 0.9 : 0.48;
                if (!(d < d2) && selfDir.method_10166() != class_2350.class_2351.field_11052) break block8;
            }
            return false;
        }
        class_2586 be = self.getBlockEntity();
        if (be instanceof FunnelBlockEntity && !(funnelBlockEntity = (FunnelBlockEntity)be).matches(conveyor.getContainer().method_32327())) {
            return false;
        }
        MovingItem stack = conveyor.getContainer();
        if (FactoryUtil.tryInserting((class_1937)self.getWorld(), self.getPos().method_10093((class_2350)selfState.method_11654(FACING)), stack.method_32327(), selfDir.method_10153()) == -1) {
            return selfDir.method_10166() == pushDirection.method_10166();
        }
        if (stack.method_32327().method_7960()) {
            conveyor.clearContainer();
        }
        return selfDir.method_10166() == pushDirection.method_10166();
    }

    @Override
    public void getItemFrom(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        block12: {
            FunnelBlockEntity be;
            class_2350 selfFacing;
            block11: {
                class_1278 s;
                class_1278 sided;
                FunnelBlockEntity x;
                if (relative != class_2350.field_11033 || !conveyor.isContainerEmpty()) {
                    return;
                }
                class_2680 selfState = self.getBlockState();
                ConveyorLikeDirectional.TransferMode mode = (ConveyorLikeDirectional.TransferMode)((Object)selfState.method_11654(MODE));
                selfFacing = (class_2350)selfState.method_11654(FACING);
                if (!((Boolean)selfState.method_11654((class_2769)ENABLED)).booleanValue() || !mode.toConveyor || pushDirection == selfFacing) {
                    return;
                }
                class_2586 class_25862 = self.getBlockEntity();
                FunnelBlockEntity funnelBlockEntity = be = class_25862 instanceof FunnelBlockEntity ? (x = (FunnelBlockEntity)class_25862) : null;
                if (be == null) {
                    return;
                }
                class_1263 inv = class_2614.method_11250((class_1937)self.getWorld(), (class_2338)self.getPos().method_10093(selfFacing));
                class_1278 class_12782 = sided = inv instanceof class_1278 ? (s = (class_1278)inv) : null;
                if (inv == null) break block11;
                for (int i = 0; i < inv.method_5439(); ++i) {
                    class_1799 stack = inv.method_5438(i);
                    if (stack.method_7960() || !be.matches(stack) || sided != null && !sided.method_5493(i, stack, selfFacing.method_10153()) || !conveyor.pushNew(stack)) continue;
                    inv.method_5431();
                    if (stack.method_7960()) {
                        inv.method_5447(i, class_1799.field_8037);
                    }
                    conveyor.setMovementPosition(pushDirection.method_10153() == selfFacing ? 0.15 : 0.5);
                    return;
                }
                break block12;
            }
            Storage storage = (Storage)ItemStorage.SIDED.find((class_1937)self.getWorld(), self.getPos().method_10093(selfFacing), (Object)selfFacing);
            if (storage == null) break block12;
            for (StorageView view : storage) {
                if (view.isResourceBlank() || !be.matches(((ItemVariant)view.getResource()).toStack())) continue;
                Transaction t = Transaction.openOuter();
                try {
                    ItemVariant resource = (ItemVariant)view.getResource();
                    long val = view.extract((Object)((ItemVariant)view.getResource()), (long)conveyor.getMaxStackCount(resource.toStack()), (TransactionContext)t);
                    if (val == 0L) continue;
                    t.commit();
                    if (!conveyor.pushNew(resource.toStack((int)val))) continue;
                    conveyor.setMovementPosition(pushDirection.method_10153() == selfFacing ? 0.15 : 0.5);
                    return;
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204())) {
            this.updateEnabled(world, pos, state);
        }
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        this.updateEnabled(world, pos, state);
        super.method_9612(state, world, pos, sourceBlock, wireOrientation, notify);
    }

    private void updateEnabled(class_1937 world, class_2338 pos, class_2680 state) {
        boolean powered = world.method_49803(pos);
        if (powered == (Boolean)state.method_11654((class_2769)ENABLED)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(!powered)), 4);
        }
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        ConveyorLikeDirectional.TransferMode transferMode;
        class_2350 dir;
        if (ctx.method_8038() == class_2350.field_11033) {
            ((class_2680)this.method_9564().method_11657(FACING, (Comparable)class_2350.field_11036)).method_11657(MODE, (Comparable)((Object)ConveyorLikeDirectional.TransferMode.TO_CONVEYOR));
        }
        if ((dir = ctx.method_8038().method_10153()) == class_2350.field_11033) {
            dir = ctx.method_8042();
        }
        class_2338 selfPos = ctx.method_8037();
        if (ctx.method_8038() != class_2350.field_11036) {
            selfPos = selfPos.method_10093(ctx.method_8038());
        }
        selfPos = selfPos.method_10074();
        class_2680 below = ctx.method_8045().method_8320(selfPos);
        class_2248 class_22482 = below.method_26204();
        if (class_22482 instanceof ConveyorLikeDirectional) {
            ConveyorLikeDirectional directional = (ConveyorLikeDirectional)class_22482;
            transferMode = directional.getTransferMode(below, dir.method_10153());
        } else {
            transferMode = ConveyorLikeDirectional.TransferMode.TO_CONVEYOR;
        }
        ConveyorLikeDirectional.TransferMode mode = transferMode;
        return this.waterLog(ctx, (class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)dir)).method_11657(MODE, (Comparable)((Object)mode)));
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        AbstractFilterItem item;
        FunnelBlockEntity x;
        FunnelBlockEntity be;
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_2586 class_25862 = world.method_8321(pos);
        FunnelBlockEntity funnelBlockEntity = be = class_25862 instanceof FunnelBlockEntity ? (x = (FunnelBlockEntity)class_25862) : null;
        if (be == null || !be.checkUnlocked(player)) {
            return class_1269.field_5814;
        }
        class_25862 = stack.method_7909();
        if (class_25862 instanceof AbstractFilterItem && (item = (AbstractFilterItem)class_25862).isFilterSet(stack)) {
            if (!be.getFilter().method_7960()) {
                player.method_31548().method_7398(be.getFilter());
            }
            be.setFilter(stack.method_46651(1));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.ITEM_FILTER_USE);
            }
            stack.method_7934(1);
            return class_1269.field_52422;
        }
        if (stack.method_7960() && !be.getFilter().method_7960()) {
            player.method_6122(class_1268.field_5808, be.getFilter());
            be.setFilter(class_1799.field_8037);
            return class_1269.field_52422;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0), FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0), FACING);
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_9975.method_9564();
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FunnelBlockEntity(pos, state);
    }

    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState, pos);
    }

    @Override
    public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
        return List.of(BlockConfig.FACING, MODE_ACTION);
    }

    public static class Model
    extends BlockModel {
        private static final class_1799 MODEL_IN = ItemDisplayElementUtil.getModel((class_2960)FactoryUtil.id("block/funnel_in"));
        private static final class_1799 MODEL_OUT = ItemDisplayElementUtil.getModel((class_2960)FactoryUtil.id("block/funnel_out"));
        final FilterIcon filterElement = new FilterIcon((ElementHolder)this);
        private final ItemDisplayElement mainElement = new LodItemDisplayElement();
        private final float offset;

        protected Model(class_2680 state, class_2338 pos) {
            this.mainElement.setDisplaySize(1.0f, 1.0f);
            this.mainElement.setItemDisplayContext(class_811.field_4319);
            this.mainElement.setInvisible(true);
            this.mainElement.setViewRange(0.8f);
            this.offset = pos.method_19455(class_2338.field_11176) % 2 == 0 ? 0.002f : 0.0f;
            this.updateFacing(state);
            this.addElement((VirtualElement)this.mainElement);
        }

        private void updateFacing(class_2680 facing) {
            Quaternionf rot = ((class_2350)facing.method_11654(FACING)).method_23224().mul((Quaternionfc)class_2350.field_11043.method_23224());
            Matrix4f mat = Model.mat();
            mat.rotate((Quaternionfc)rot);
            mat.translate(0.0f, this.offset / 2.0f, this.offset);
            mat.scale(2.01f);
            boolean outModel = facing.method_11654(MODE) == ConveyorLikeDirectional.TransferMode.FROM_CONVEYOR;
            this.mainElement.setItem(this.getModel(outModel));
            this.mainElement.setTransformation(mat);
            mat.identity();
            mat.rotate((Quaternionfc)rot).rotateY((float)Math.PI);
            if (outModel) {
                mat.rotateX(-0.3926991f);
                mat.translate(0.0f, 0.453125f, 0.008f);
            } else {
                mat.translate(0.0f, 0.53125f, 0.025f);
            }
            mat.scale(0.3f, 0.3f, 0.005f);
            this.filterElement.setTransformation((Matrix4fc)mat);
            this.tick();
        }

        protected class_1799 getModel(boolean outModel) {
            return outModel ? MODEL_OUT : MODEL_IN;
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateFacing(this.blockState());
            }
        }
    }
}

