/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.machines;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.factorytools.api.block.OwnedBlockEntity;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.factorytools.api.util.LegacyNbtHelper;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.PlanterBlock;
import eu.pb4.polyfactory.item.FactoryItemTags;
import eu.pb4.polyfactory.ui.TagLimitedSlot;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.MinimalSidedInventory;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class PlanterBlockEntity
extends LockableBlockEntity
implements MinimalSidedInventory,
BlockEntityExtraListener,
OwnedBlockEntity {
    private static final int[] SLOTS = IntStream.range(0, 9).toArray();
    private final class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    protected GameProfile owner = null;
    protected double process = 0.0;
    private float stress = 0.0f;
    private int radius = 2;
    private PlanterBlock.Model model;

    public PlanterBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.PLANTER, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
        nbt.method_10549("progress", this.process);
        if (this.owner != null) {
            nbt.method_10566("owner", (class_2520)LegacyNbtHelper.writeGameProfile((class_2487)new class_2487(), (GameProfile)this.owner));
        }
        nbt.method_10569("radius", this.radius);
        super.method_11007(nbt, lookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        if (nbt.method_10545("stack") && !nbt.method_10545("Items")) {
            this.method_5447(0, FactoryUtil.fromNbtStack(lookup, (class_2520)nbt.method_68568("stack")));
        } else {
            class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
        }
        this.process = nbt.method_68563("progress", 0.0);
        if (nbt.method_10545("owner")) {
            this.owner = LegacyNbtHelper.toGameProfile((class_2487)nbt.method_68568("owner"));
        }
        this.radius = nbt.method_10545("radius") ? nbt.method_68083("radius", 2) : 1;
        super.method_11014(nbt, lookup);
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(GameProfile profile) {
        this.owner = profile;
        this.method_5431();
    }

    public int[] method_5494(class_2350 side) {
        return SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return stack.method_31573(FactoryItemTags.ALLOWED_IN_PLANTER);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    protected void createGui(class_3222 playerEntity) {
        new Gui(playerEntity);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        class_1657 class_16572;
        class_1792 x2;
        PlanterBlockEntity self = (PlanterBlockEntity)t;
        if (self.method_5442()) {
            self.stress = 0.0f;
            self.process = 0.0;
            return;
        }
        class_1799 stack = class_1799.field_8037;
        for (class_1792 x2 : self.items) {
            if (x2.method_7960()) continue;
            stack = x2;
            break;
        }
        if (!((x2 = stack.method_7909()) instanceof class_1747)) {
            self.stress = 0.0f;
            self.process = 0.0;
            return;
        }
        class_1747 blockItem = (class_1747)x2;
        class_2680 placableState = blockItem.method_7711().method_9564();
        double speed = Math.abs(RotationUser.getRotation((class_1937)((class_3218)world), pos).speed()) * 0.01745329238474369 * 2.5;
        class_2338 place = null;
        for (int y = 0; y < 2; ++y) {
            class_16572 = class_2338.method_30512((class_2338)pos.method_10087(y), (int)self.radius, (class_2350)class_2350.field_11043, (class_2350)class_2350.field_11039).iterator();
            while (class_16572.hasNext()) {
                class_2338.class_2339 mut = (class_2338.class_2339)class_16572.next();
                class_2680 targetState = world.method_8320((class_2338)mut);
                if (!targetState.method_26215() && (!targetState.method_45474() || !targetState.method_26227().method_15769()) || !placableState.method_26184((class_4538)world, (class_2338)mut) || !CommonProtection.canPlaceBlock((class_1937)world, (class_2338)mut, (GameProfile)(self.owner == null ? FactoryUtil.GENERIC_PROFILE : self.owner), null)) continue;
                place = mut.method_10062();
                break;
            }
            if (place != null) break;
        }
        if (place == null) {
            self.stress = 0.0f;
            self.process = 0.0;
            return;
        }
        self.stress = 6.0f;
        if (speed == 0.0) {
            return;
        }
        self.model.setDirection(pos, place);
        if (self.process == 0.0) {
            self.process += speed / 40.0;
            return;
        }
        self.process += speed / 40.0;
        if (self.process >= 1.0) {
            self.process = 0.0;
            self.stress = 0.0f;
            world.method_8501(place, placableState);
            stack.method_7934(1);
            world.method_8396(null, pos, placableState.method_26231().method_10598(), class_3419.field_15245, 0.5f, 1.0f);
            world.method_43276((class_6880)class_5712.field_28164, place, class_5712.class_7397.method_43287((class_2680)placableState));
            if (self.owner != null && (class_16572 = world.method_18470(self.owner.getId())) instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.PLANTER_PLANTS);
            }
            self.method_5431();
        }
    }

    public void method_11012() {
        super.method_11012();
    }

    public float getStress() {
        return this.stress;
    }

    public void onListenerUpdate(class_2818 chunk) {
        this.model = (PlanterBlock.Model)BlockBoundAttachment.get((class_2818)chunk, (class_2338)this.field_11867).holder();
    }

    public int radius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.method_5431();
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.items;
    }

    private class Gui
    extends SimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_17328, player, false);
            this.setTitle((class_2561)PlanterBlockEntity.this.method_11010().method_26204().method_9518());
            for (int i = 0; i < 9; ++i) {
                this.setSlotRedirect(i, new TagLimitedSlot(PlanterBlockEntity.this, i, FactoryItemTags.ALLOWED_IN_PLANTER));
            }
            this.open();
        }

        public void onClose() {
            super.onClose();
        }

        public void onTick() {
            if (this.player.method_19538().method_1025(class_243.method_24953((class_2382)PlanterBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            super.onTick();
        }
    }
}

