/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.machines.crafting;

import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.TallItemMachineBlock;
import eu.pb4.polyfactory.block.mechanical.machines.crafting.PressBlockEntity;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.models.GenericParts;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class PressBlock
extends TallItemMachineBlock {
    public PressBlock(class_4970.class_2251 settings) {
        super(settings);
        Model.MODEL_PISTON.method_7960();
    }

    @Override
    public boolean pushItemTo(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        if (self.getBlockState().method_11654(INPUT_FACING) == pushDirection || self.getBlockState().method_11654(PART) == TallItemMachineBlock.Part.TOP) {
            return false;
        }
        PressBlockEntity be = (PressBlockEntity)self.getBlockEntity();
        if (((class_2350)self.getBlockState().method_11654(INPUT_FACING)).method_10153() != pushDirection) {
            class_1799 stack = be.method_5438(1);
            if (stack.method_7960()) {
                be.method_5447(1, conveyor.pullAndDestroy().method_32327());
                return true;
            }
            MovingItem container = conveyor.getContainer();
            if (class_1799.method_31577((class_1799)container.method_32327(), (class_1799)stack)) {
                int i = Math.min(container.method_32327().method_7947(), stack.method_7914() - stack.method_7947());
                stack.method_7933(i);
                container.method_32327().method_7934(i);
            }
            if (container.method_32327().method_7960()) {
                conveyor.clearContainer();
            }
            return true;
        }
        ContainerHolder container = be.getContainerHolder(0);
        if (container.isContainerEmpty()) {
            container.pushAndAttach(conveyor.pullAndRemove());
        } else {
            class_1799 targetStack = container.getContainer().method_32327();
            class_1799 sourceStack = conveyor.getContainer().method_32327();
            if (class_1799.method_31577((class_1799)container.getContainer().method_32327(), (class_1799)conveyor.getContainer().method_32327())) {
                int count = Math.min(targetStack.method_7947() + sourceStack.method_7947(), container.getMaxStackCount(sourceStack));
                if (count != targetStack.method_7947()) {
                    int dec = count - targetStack.method_7947();
                    targetStack.method_7933(dec);
                    sourceStack.method_7934(dec);
                }
                if (sourceStack.method_7960()) {
                    conveyor.clearContainer();
                }
            }
        }
        return true;
    }

    @Override
    public void getItemFrom(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        class_2350 inputDir = (class_2350)self.getBlockState().method_11654(INPUT_FACING);
        if (!conveyor.isContainerEmpty() || pushDirection == inputDir || inputDir.method_10153() != relative || self.getBlockState().method_11654(PART) == TallItemMachineBlock.Part.TOP) {
            return;
        }
        PressBlockEntity be = (PressBlockEntity)self.getBlockEntity();
        ContainerHolder out = be.getContainerHolder(2);
        if (out.isContainerEmpty()) {
            return;
        }
        class_1799 stack = out.getContainer().method_32327();
        int amount = Math.min(stack.method_7947(), out.getMaxStackCount(stack));
        if (stack.method_7947() == amount) {
            conveyor.pushAndAttach(out.pullAndRemove());
        } else {
            stack.method_7934(amount);
            conveyor.setMovementPosition(pushDirection == inputDir.method_10153() ? 0.0 : 0.5);
            conveyor.pushNew(stack.method_46651(amount));
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world instanceof class_3218 && type == FactoryBlockEntities.PRESS ? PressBlockEntity::ticker : null;
    }

    @Override
    protected class_2586 createSourceBlockEntity(class_2338 pos, class_2680 state) {
        return new PressBlockEntity(pos, state);
    }

    @Override
    protected ElementHolder createModel(class_3218 serverWorld, class_2338 pos, class_2680 initialBlockState) {
        return new Model(serverWorld, initialBlockState);
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10535.method_9564();
    }

    public static final class Model
    extends RotationAwareModel {
        public static final class_1799 MODEL_PISTON = ItemDisplayElementUtil.getModel((class_2960)FactoryUtil.id("block/press_piston"));
        private final Matrix4fStack mat = new Matrix4fStack(2);
        private final ItemDisplayElement piston;
        private final ItemDisplayElement pistonItem;
        private final ItemDisplayElement main = ItemDisplayElementUtil.createSimple((class_1792)FactoryItems.PRESS);
        private final ItemDisplayElement gearA;
        private final ItemDisplayElement gearB;
        private float value;

        private Model(class_3218 world, class_2680 state) {
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.main.setTranslation((Vector3fc)new Vector3f(0.0f, 0.5f, 0.0f));
            this.piston = LodItemDisplayElement.createSimple((class_1799)MODEL_PISTON, (int)2, (float)0.4f, (float)0.8f);
            this.pistonItem = LodItemDisplayElement.createSimple((class_1799)class_1799.field_8037, (int)2, (float)0.4f, (float)0.8f);
            this.gearA = LodItemDisplayElement.createSimple((class_1799)GenericParts.SMALL_GEAR, (int)this.getUpdateRate(), (float)0.3f, (float)0.5f);
            this.gearB = LodItemDisplayElement.createSimple((class_1799)GenericParts.SMALL_GEAR, (int)this.getUpdateRate(), (float)0.3f, (float)0.5f);
            this.piston.setViewRange(0.4f);
            this.pistonItem.setViewRange(0.4f);
            this.gearA.setViewRange(0.4f);
            this.gearB.setViewRange(0.4f);
            this.updateStatePos(state);
            class_2350 dir = (class_2350)state.method_11654(TallItemMachineBlock.INPUT_FACING);
            this.updateAnimation(true, true, 0.0f, dir.method_10171() == class_2350.class_2352.field_11060 == (dir.method_10166() == class_2350.class_2351.field_11048));
            this.addElement((VirtualElement)this.piston);
            this.addElement((VirtualElement)this.pistonItem);
            this.addElement((VirtualElement)this.main);
            this.addElement((VirtualElement)this.gearA);
            this.addElement((VirtualElement)this.gearB);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 direction = (class_2350)state.method_11654(TallItemMachineBlock.INPUT_FACING);
            this.main.setYaw(direction.method_10144());
            this.pistonItem.setYaw(direction.method_10144());
            this.piston.setYaw(direction.method_10144());
            this.gearA.setYaw(direction.method_10144());
            this.gearB.setYaw(direction.method_10144());
        }

        private void updateAnimation(boolean b, boolean c, float rotation, boolean negative) {
            this.mat.identity();
            this.mat.translate(0.0f, 0.5f, 0.0f);
            if (b) {
                this.mat.pushMatrix();
                this.mat.rotateY(negative ? 1.5707964f : -1.5707964f);
                this.mat.translate(0.0f, 0.5f, 0.4f);
                this.mat.rotateZ(rotation);
                this.gearA.setTransformation((Matrix4f)this.mat);
                this.mat.translate(0.0f, 0.0f, -0.8f);
                this.gearB.setTransformation((Matrix4f)this.mat);
                this.mat.popMatrix();
            }
            if (c) {
                this.mat.scale(2.0f);
                this.mat.translate(0.0f, 0.5f - this.value * 0.3f, 0.0f);
                this.piston.setTransformation((Matrix4f)this.mat);
                this.mat.translate(0.0f, -0.25f, 0.0f);
                this.mat.scale(0.2f);
                this.mat.rotateX(1.5707964f);
                this.pistonItem.setTransformation((Matrix4f)this.mat);
            }
        }

        protected void onTick() {
            int tick = this.getTick();
            boolean b = tick % this.getUpdateRate() == 0;
            boolean c = tick % 2 == 0;
            class_2350 dir = (class_2350)this.blockState().method_11654(TallItemMachineBlock.INPUT_FACING);
            this.updateAnimation(b, c, b ? RotationUser.getRotation((class_1937)this.getAttachment().getWorld(), this.blockPos().method_10084()).rotation() : 0.0f, dir.method_10171() == class_2350.class_2352.field_11060 == (dir.method_10166() == class_2350.class_2351.field_11048));
            if (c && this.piston.isDirty()) {
                this.piston.startInterpolation();
                this.pistonItem.startInterpolation();
            }
            if (b && this.gearA.isDirty()) {
                this.gearA.startInterpolation();
                this.gearB.startInterpolation();
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }

        public void updatePiston(double i) {
            this.value = i < 0.0 ? (float)Math.min(-i * (double)1.7f, 1.0) : (float)Math.min(i * 2.2, 1.0);
        }

        public void setItem(class_1799 stack) {
            this.pistonItem.setItem(stack);
        }
    }
}

